/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.FifoSet;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.PrioritySetEntry;
import com.sun.messaging.jmq.util.lists.SetEntry;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public class PriorityFifoSet
extends FifoSet
implements Prioritized {
    SetEntry[] priorities = null;
    protected int defaultPriority = 0;
    int levels = 0;

    public PriorityFifoSet() {
        this(10);
    }

    public int getLevels() {
        return this.levels;
    }

    @Override
    public void clear() {
        super.clear();
        for (int i = 0; i < this.levels; ++i) {
            this.priorities[i] = null;
        }
    }

    public PriorityFifoSet(int levels) {
        this.levels = levels;
        this.priorities = new SetEntry[levels + 1];
        this.defaultPriority = levels / 2;
    }

    @Override
    public boolean add(Object o) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        return this.add(this.defaultPriority, o);
    }

    @Override
    public void addAllOrdered(Collection c) {
    }

    @Override
    public void addAllToFront(Collection c, int priority) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        if (this.priorities[priority] == null) {
            for (Object o : c) {
                this.add(priority, o);
            }
        } else {
            SetEntry startOfList = null;
            SetEntry endEntry = this.priorities[priority];
            for (Object o : c) {
                if (this.lookup.get(o) != null) {
                    this.remove(o);
                }
                SetEntry e = this.createSetEntry(o, priority);
                this.lookup.put(o, e);
                endEntry.insertEntryBefore(e);
                if (startOfList != null) continue;
                startOfList = e;
            }
            this.priorities[priority] = startOfList;
            if (this.head == endEntry) {
                this.head = startOfList;
            }
        }
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public void setDefaultPriority(int p) {
        this.defaultPriority = p;
    }

    protected SetEntry createSetEntry(Object o, int p) {
        return new PrioritySetEntry(o, p);
    }

    @Override
    public boolean add(int pri, Object o) {
        int tpri;
        assert (this.lock == null || Thread.holdsLock(this.lock));
        if (this.parent != null) {
            if (this.end != null && pri >= ((PrioritySetEntry)this.end).getPriority()) {
                throw new IllegalArgumentException("Object added is past end of subset");
            }
            if (this.start != null && pri <= ((PrioritySetEntry)this.start).getPriority()) {
                throw new IllegalArgumentException("Object added is past begining of subset");
            }
            return ((PriorityFifoSet)this.parent).add(pri, o);
        }
        if (pri >= this.priorities.length) {
            throw new OutOfLimitsException(3, pri, this.priorities.length);
        }
        if (this.lookup.get(o) != null) {
            this.remove(o);
        }
        SetEntry e = this.createSetEntry(o, pri);
        this.lookup.put(o, e);
        if (this.head == null) {
            this.priorities[pri] = e;
            this.head = this.tail = e;
            return true;
        }
        int hpri = ((PrioritySetEntry)this.head).getPriority();
        if (hpri > pri) {
            this.priorities[pri] = e;
            this.head.insertEntryBefore(e);
            this.head = e;
            return true;
        }
        if (this.tail == null) {
            SetEntry fix = this.head;
            while (fix.getNext() != null) {
                fix = fix.getNext();
            }
            this.tail = fix;
        }
        if ((tpri = ((PrioritySetEntry)this.tail).getPriority()) <= pri) {
            this.tail.insertEntryAfter(e);
            if (this.priorities[pri] == null) {
                this.priorities[pri] = e;
            }
            this.tail = e;
            return true;
        }
        SetEntry target = null;
        for (int i = pri + 1; i < this.priorities.length; ++i) {
            if (this.priorities[i] == null) continue;
            target = this.priorities[i];
            break;
        }
        if (target != null) {
            target.insertEntryBefore(e);
            if (this.priorities[pri] == null) {
                this.priorities[pri] = e;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDebugString() {
        StringBuffer str = new StringBuffer();
        str.append("PriorityFifoSet[" + this.hashCode() + "]\n\tpriorities:\n");
        for (int i = 0; i < this.priorities.length; ++i) {
            str.append("\t\t" + i + "\t" + this.priorities[i] + "\n");
        }
        str.append("\thead=" + this.head + "\n");
        str.append("\ttail=" + this.tail + "\n");
        str.append("\tstart=" + this.start + "\n");
        str.append("\tend=" + this.end + "\n");
        Map map = this.lookup;
        synchronized (map) {
            str.append("\tlookup: size=" + this.lookup.size() + ", isEmpty=" + this.lookup.isEmpty() + "\n");
            for (Object key : this.lookup.keySet()) {
                str.append("\t\t[" + key + "," + this.lookup.get(key) + "]\n");
            }
        }
        return str.toString();
    }

    @Override
    protected boolean cleanupEntry(SetEntry e) {
        assert (this.lock == null || Thread.holdsLock(this.lock));
        PrioritySetEntry pe = (PrioritySetEntry)e;
        int pri = pe.getPriority();
        if (this.priorities[pri] == pe) {
            PrioritySetEntry nexte = (PrioritySetEntry)pe.getNext();
            this.priorities[pri] = nexte != null && nexte.getPriority() == pri ? nexte : null;
        }
        assert (pe.getPrevious() != null || pe == this.head) : pe;
        assert (pe.getNext() != null || pe == this.tail) : pe;
        return super.cleanupEntry(e);
    }

    @Override
    public boolean remove(Object o) {
        assert (this.lock == null || Thread.holdsLock(this.lock)) : this.lock + ":" + this;
        return super.remove(o);
    }

    @Override
    public void sort(Comparator c) {
        super.sort(c);
        for (int i = 0; i < this.levels; ++i) {
            if (this.priorities[i] == null) continue;
            this.priorities[i] = this.priorities[i].sort(c);
        }
    }
}

