/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.model;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingFieldElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingReferenceKeyElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingRelationshipElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingTableElementImpl;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.spi.persistence.support.sqlstore.ConfigCache;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceConfig;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.KeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ReferenceKeyDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.TableDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.RetrieveDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.UpdateObjectDescImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.Concurrency;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.ConcurrencyCheckDirty;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.ConcurrencyDBExplicit;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.ConcurrencyDBNative;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency.ConcurrencyOptVerify;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateQueryPlan;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.TableElement;

public class ClassDesc
implements PersistenceConfig {
    private ArrayList fetchGroups;
    private int maxHierarchicalGroupID;
    private boolean hasLocalNonDFGField;
    public ArrayList fields;
    public ArrayList hiddenFields;
    public ArrayList foreignFields;
    private LocalFieldDesc[] versionFields;
    private ArrayList tables;
    private Class pcClass;
    private Class oidClass;
    public int maxFields;
    public int maxVisibleFields;
    public int maxHiddenFields;
    private Concurrency optimisticConcurrency;
    private Concurrency checkDirtyConcurrency;
    private Concurrency databaseConcurrency;
    private Concurrency explicitConcurrency;
    private MappingClassElementImpl mdConfig;
    private ClassLoader classLoader;
    private Constructor constructor;
    private PersistenceClassElement pcElement;
    private PersistenceFieldElement[] persistentFields;
    private Field[] keyFields;
    private String[] keyFieldNames;
    private LocalFieldDesc[] keyFieldDescs;
    private static Logger logger = LogHelperSQLStore.getLogger();
    private final Map retrieveDescCache = new HashMap();
    private final Map foreignRetrieveDescCache = new HashMap();
    private RetrieveDesc retrieveDescForVerification;
    private Object retrieveDescForVerificationSynchObj = new Object();
    private final Map updateQueryPlanCache = new HashMap();
    private UpdateQueryPlan updateQueryPlanForInsert;
    private Object updateQueryPlanForInsertSynchObj = new Object();
    private UpdateQueryPlan updateQueryPlanForDelete;
    private Object updateQueryPlanForDeleteSynchObj = new Object();
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", ClassDesc.class.getClassLoader());
    private static final Class[] sigSM = new Class[]{StateManager.class};

    public ClassDesc(MappingClassElement mdConfig, Class pcClass) {
        this.mdConfig = (MappingClassElementImpl)mdConfig;
        this.pcElement = this.mdConfig.getPersistenceElement();
        this.pcClass = pcClass;
        this.classLoader = pcClass.getClassLoader();
        try {
            this.constructor = pcClass.getConstructor(sigSM);
        }
        catch (Exception e) {
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerimpl.assertpersistencecapable.error", pcClass.getName()), e);
        }
        this.fields = new ArrayList();
        this.foreignFields = new ArrayList();
        this.tables = new ArrayList();
        this.fetchGroups = new ArrayList();
    }

    public String toString() {
        return this.getName();
    }

    static ClassDesc newInstance(Class pcClass) {
        Model model = Model.RUNTIME;
        String className = pcClass.getName();
        ClassLoader classLoader = pcClass.getClassLoader();
        ClassDesc rc = null;
        try {
            MappingClassElement mdConfig = model.getMappingClass(className, classLoader);
            ClassDesc.validateModel(model, className, classLoader);
            rc = new ClassDesc(mdConfig, pcClass);
        }
        catch (JDOException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.loadfailed.class", className), e);
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.loadfailed.class", className), e);
        }
        return rc;
    }

    private static void validateModel(Model model, String className, ClassLoader classLoader) {
        Collection c = null;
        c = model.validate(className, classLoader, null);
        if (!c.isEmpty()) {
            Iterator iter = c.iterator();
            StringBuffer validationMsgs = new StringBuffer();
            while (iter.hasNext()) {
                Exception ex = (Exception)iter.next();
                String validationMsg = ex.getLocalizedMessage();
                logger.fine(I18NHelper.getMessage(messages, "core.configuration.validationproblem", className, validationMsg));
                validationMsgs.append(validationMsg).append('\n');
            }
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.validationfailed", className, validationMsgs.toString()));
        }
    }

    public void initialize(ConfigCache cache) {
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("sqlstore.model.classdesc.persistconfiginit", (Object)this.mdConfig);
        }
        this.loadOidClass();
        this.initializeFields();
        this.computeTrackedPrimitiveFields();
        this.initializeTables();
        this.initializeJoinTables();
        this.initializeVersionFields();
        this.initializeConcurrency();
        this.initializeKeyFields();
        this.initializeFetchGroups();
        this.fixupForeignReferences(cache);
        this.fixupFieldProperties();
        this.computeTrackedRelationshipFields();
        this.cleanupTrackedFields();
        if (this.hiddenFields != null) {
            this.maxHiddenFields = this.hiddenFields.size();
        }
        this.maxFields = this.maxVisibleFields + this.maxHiddenFields;
        if (debug) {
            logger.fine("sqlstore.model.classdesc.persistconfiginit.exit");
        }
    }

    private void loadOidClass() {
        if (this.oidClass != null) {
            return;
        }
        String keyClassName = this.pcElement.getKeyClass();
        String suffix = keyClassName.substring(keyClassName.length() - 4);
        if (suffix.compareToIgnoreCase(".oid") == 0) {
            StringBuffer buf = new StringBuffer(keyClassName);
            buf.setCharAt(buf.length() - 4, '$');
            keyClassName = buf.toString();
        }
        try {
            this.oidClass = Class.forName(keyClassName, true, this.classLoader);
        }
        catch (Throwable e) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.cantloadclass", keyClassName));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.model.classdesc.loadedclass", (Object)this.oidClass);
        }
    }

    private void initializeFields() {
        ArrayList concurrencyGroups = new ArrayList();
        this.persistentFields = this.pcElement.getFields();
        for (int i = 0; i < this.persistentFields.length; ++i) {
            PersistenceFieldElement pcf = this.persistentFields[i];
            MappingFieldElementImpl mdf = (MappingFieldElementImpl)this.mdConfig.getField(pcf.getName());
            if (mdf == null) {
                throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.fieldnotmapped", pcf.getName(), this.pcElement.getName()));
            }
            FieldDesc f = !(mdf instanceof MappingRelationshipElement) ? this.createLocalField(mdf) : this.createForeignField((RelationshipElement)pcf, (MappingRelationshipElementImpl)mdf);
            this.initializeFetchAndConcurrencyGroup(f, pcf, mdf, concurrencyGroups);
            if (mdf.isReadOnly()) {
                f.sqlProperties |= 4;
            }
            try {
                f.setupDesc(this.pcClass, pcf.getName());
            }
            catch (JDOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.loadfailed.field", pcf.getName(), this.pcElement.getName()), e);
            }
            f.absoluteID = pcf.getFieldNumber();
            this.addField(f);
            if (!logger.isLoggable(300)) continue;
            Object[] items = new Object[]{f.getName(), new Integer(f.absoluteID)};
            logger.finest("sqlstore.model.classdesc.fieldinfo", items);
        }
        this.maxVisibleFields = this.fields.size();
    }

    private LocalFieldDesc createLocalField(MappingFieldElementImpl mdf) {
        ArrayList columnDesc = mdf.getColumnObjects();
        if (columnDesc == null || columnDesc.size() == 0) {
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.fieldnotmapped", mdf.getName(), this.pcElement.getName()));
        }
        return new LocalFieldDesc(this, columnDesc);
    }

    private LocalFieldDesc createLocalHiddenField(ColumnElement column) {
        ArrayList<ColumnElement> columnDesc = new ArrayList<ColumnElement>();
        columnDesc.add(column);
        LocalFieldDesc lf = new LocalFieldDesc(this, columnDesc);
        if (this.hiddenFields == null) {
            this.hiddenFields = new ArrayList();
        }
        this.hiddenFields.add(lf);
        lf.absoluteID = -this.hiddenFields.size();
        if (logger.isLoggable(300)) {
            Object[] items = new Object[]{this.pcClass, lf.getName(), column.getName().getFullName()};
            logger.finest("sqlstore.model.classdesc.getlocalfielddesc", items);
        }
        return lf;
    }

    private FieldDesc createForeignField(RelationshipElement fpcf, MappingRelationshipElementImpl fmdf) {
        ForeignFieldDesc ff = new ForeignFieldDesc(this);
        this.addForeignField(ff);
        ff.cardinalityLWB = fpcf.getLowerBound();
        ff.cardinalityUPB = fpcf.getUpperBound();
        ff.deleteAction = fpcf.getDeleteAction();
        this.initializeColumnLists(ff, fmdf);
        if (Model.RUNTIME.isCollection(fpcf.getCollectionClass()) && ff.cardinalityUPB <= 1) {
            ff.cardinalityUPB = Integer.MAX_VALUE;
        }
        if (ff.cardinalityUPB > 1) {
            try {
                ff.setComponentType(Class.forName(fpcf.getElementClass(), true, this.classLoader));
            }
            catch (Throwable e) {
                logger.log(900, "sqlstore.exception.log", e);
            }
        }
        return ff;
    }

    private void initializeColumnLists(ForeignFieldDesc ff, MappingRelationshipElementImpl fmdf) {
        ArrayList assocPairs = fmdf.getAssociatedColumnObjects();
        ArrayList pairs = fmdf.getColumnObjects();
        ArrayList<ColumnElement> localColumns = new ArrayList<ColumnElement>();
        ArrayList<ColumnElement> foreignColumns = new ArrayList<ColumnElement>();
        if (assocPairs == null || assocPairs.size() == 0) {
            for (int i = 0; i < pairs.size(); ++i) {
                ColumnPairElement fce = (ColumnPairElement)pairs.get(i);
                localColumns.add(fce.getLocalColumn());
                foreignColumns.add(fce.getReferencedColumn());
            }
            ff.localColumns = localColumns;
            ff.foreignColumns = foreignColumns;
        } else {
            int i;
            ArrayList<ColumnElement> assocLocalColumns = new ArrayList<ColumnElement>();
            ArrayList<ColumnElement> assocForeignColumns = new ArrayList<ColumnElement>();
            for (i = 0; i < pairs.size(); ++i) {
                ColumnPairElement alc = (ColumnPairElement)pairs.get(i);
                localColumns.add(alc.getLocalColumn());
                assocLocalColumns.add(alc.getReferencedColumn());
            }
            for (i = 0; i < assocPairs.size(); ++i) {
                ColumnPairElement afc = (ColumnPairElement)assocPairs.get(i);
                assocForeignColumns.add(afc.getLocalColumn());
                foreignColumns.add(afc.getReferencedColumn());
            }
            ff.localColumns = localColumns;
            ff.assocLocalColumns = assocLocalColumns;
            ff.assocForeignColumns = assocForeignColumns;
            ff.foreignColumns = foreignColumns;
        }
    }

    private void initializeFetchAndConcurrencyGroup(FieldDesc f, PersistenceFieldElement pcf, MappingFieldElementImpl mdf, ArrayList concurrencyGroups) {
        f.fetchGroup = mdf.getFetchGroup();
        ConcurrencyGroupElement[] cgroups = pcf.getConcurrencyGroups();
        if (cgroups == null || cgroups.length == 0) {
            if (f.fetchGroup == 1) {
                f.concurrencyGroup = f.fetchGroup;
            }
        } else {
            ConcurrencyGroupElement cge = cgroups[0];
            int index = 0;
            index = concurrencyGroups.indexOf(cge);
            if (index == -1) {
                index = concurrencyGroups.size();
                concurrencyGroups.add(cge);
            }
            f.concurrencyGroup = index;
        }
    }

    private void createSecondaryTableKey(TableDesc table, MappingReferenceKeyElementImpl mappingSecondaryKey) {
        ColumnPairElement[] pairs = mappingSecondaryKey.getColumnPairs();
        KeyDesc referencingKey = new KeyDesc();
        KeyDesc referencedKey = new KeyDesc();
        TableDesc secondaryTable = this.findTableDesc(((MappingTableElementImpl)mappingSecondaryKey.getTable()).getTableObject());
        for (int i = 0; i < pairs.length; ++i) {
            ColumnPairElement pair = pairs[i];
            ColumnElement lc = pair.getLocalColumn();
            ColumnElement fc = pair.getReferencedColumn();
            referencingKey.addColumn(lc);
            LocalFieldDesc lf = this.getLocalFieldDesc(lc);
            referencingKey.addField(lf);
            lf.fetchGroup = 1;
            referencedKey.addColumn(fc);
            referencedKey.addField(this.getLocalFieldDesc(fc));
        }
        table.addSecondaryTableKey(new ReferenceKeyDesc(secondaryTable, referencingKey, referencedKey));
        secondaryTable.setPrimaryTableKey(new ReferenceKeyDesc(table, referencedKey, referencingKey));
    }

    private void initializeTables() {
        ArrayList mdTables = this.mdConfig.getTables();
        this.createTables(mdTables);
        this.processSecondaryTables(mdTables);
    }

    private void createTables(ArrayList mdTables) {
        for (int i = 0; i < mdTables.size(); ++i) {
            MappingTableElementImpl mdt = (MappingTableElementImpl)mdTables.get(i);
            TableDesc t = new TableDesc(mdt.getTableObject());
            ArrayList keys = mdt.getKeyObjects();
            KeyDesc key = new KeyDesc();
            t.setKey(key);
            key.addColumns(keys);
            for (int j = 0; j < keys.size(); ++j) {
                ColumnElement c = (ColumnElement)keys.get(j);
                if (c == null) continue;
                key.addField(this.getLocalFieldDesc(c));
            }
            this.addTableDesc(t);
        }
    }

    private void processSecondaryTables(ArrayList mdTables) {
        for (int i = 0; i < this.tables.size(); ++i) {
            MappingTableElementImpl mdt = (MappingTableElementImpl)mdTables.get(i);
            TableDesc t = (TableDesc)this.tables.get(i);
            ArrayList secondaryKeys = mdt.getReferencingKeys();
            for (int j = 0; j < secondaryKeys.size(); ++j) {
                MappingReferenceKeyElementImpl mappingSecondaryKey = (MappingReferenceKeyElementImpl)secondaryKeys.get(j);
                this.createSecondaryTableKey(t, mappingSecondaryKey);
            }
        }
    }

    private void initializeJoinTables() {
        for (ForeignFieldDesc ff : this.foreignFields) {
            TableElement joinTable;
            TableDesc joinTableDesc;
            if (!ff.useJoinTable() || (joinTableDesc = this.findTableDesc(joinTable = ((ColumnElement)ff.assocLocalColumns.get(0)).getDeclaringTable())) != null) continue;
            joinTableDesc = new TableDesc(joinTable);
            joinTableDesc.setJoinTable(true);
            this.addTableDesc(joinTableDesc);
        }
    }

    public ArrayList getFetchGroup(int groupID) {
        int index = 0;
        if (groupID >= 0) {
            index = groupID;
        } else if (groupID < 0) {
            index = -groupID + this.maxHierarchicalGroupID;
        }
        for (int i = this.fetchGroups.size(); i <= index; ++i) {
            this.fetchGroups.add(null);
        }
        ArrayList group = (ArrayList)this.fetchGroups.get(index);
        if (group == null) {
            group = new ArrayList();
            this.fetchGroups.set(index, group);
        }
        return group;
    }

    private void addField(FieldDesc f) {
        this.fields.add(f);
    }

    private void addForeignField(ForeignFieldDesc f) {
        this.foreignFields.add(f);
    }

    private void initializeFetchGroups() {
        int i;
        for (i = 0; i < 2; ++i) {
            ArrayList theFields = null;
            if (i == 0) {
                theFields = this.fields;
            } else {
                theFields = this.hiddenFields;
                if (theFields == null) continue;
            }
            for (int j = 0; j < theFields.size(); ++j) {
                FieldDesc f = (FieldDesc)theFields.get(j);
                if (f.fetchGroup > 0) {
                    this.getFetchGroup(f.fetchGroup).add(f);
                }
                if (i != 0 || f.isRelationshipField() || f.fetchGroup == 1) continue;
                this.hasLocalNonDFGField = true;
            }
        }
        this.maxHierarchicalGroupID = this.fetchGroups.size() - 1;
        for (i = 0; i < this.fields.size(); ++i) {
            FieldDesc f = (FieldDesc)this.fields.get(i);
            if (f.fetchGroup >= 0) continue;
            this.getFetchGroup(f.fetchGroup).add(f);
        }
    }

    private void initializeConcurrency() {
        this.optimisticConcurrency = new ConcurrencyOptVerify();
        this.optimisticConcurrency.configPersistence(this);
        this.checkDirtyConcurrency = new ConcurrencyCheckDirty();
        this.checkDirtyConcurrency.configPersistence(this);
        this.databaseConcurrency = new ConcurrencyDBNative();
        this.databaseConcurrency.configPersistence(this);
        this.explicitConcurrency = new ConcurrencyDBExplicit();
        this.explicitConcurrency.configPersistence(this);
    }

    private void initializeKeyFields() {
        boolean debug = logger.isLoggable(300);
        if (this.oidClass == null) {
            return;
        }
        this.keyFields = this.oidClass.getFields();
        this.keyFieldNames = new String[this.keyFields.length];
        this.keyFieldDescs = new LocalFieldDesc[this.keyFields.length];
        if (debug) {
            logger.finest("sqlstore.model.classdesc.createsqldesc", (Object)this.oidClass);
        }
        for (int i = 0; i < this.keyFields.length; ++i) {
            String name;
            Field kf = this.keyFields[i];
            this.keyFieldNames[i] = name = kf.getName();
            if (name.equals("serialVersionUID")) continue;
            LocalFieldDesc f = this.getLocalFieldDesc(name);
            if (f != null) {
                if (debug) {
                    logger.finest("sqlstore.model.classdesc.pkfield", (Object)f.getName());
                }
                f.fetchGroup = 1;
                f.sqlProperties &= 0xFFFFFFEF;
                f.sqlProperties &= 0xFFFFFFFE;
                f.sqlProperties |= 0x100;
                this.keyFieldDescs[i] = f;
                continue;
            }
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.noneexistentpkfield", name, this.oidClass.getName(), this.pcClass.getName()));
        }
    }

    private void initializeVersionFields() {
        int size = this.mdConfig.getVersionFields().size();
        Iterator versionFieldIterator = this.mdConfig.getVersionFields().iterator();
        this.versionFields = new LocalFieldDesc[size];
        for (int i = 0; i < size; ++i) {
            MappingFieldElement mdField = (MappingFieldElement)versionFieldIterator.next();
            LocalFieldDesc f = (LocalFieldDesc)this.getField(mdField.getName());
            if (f != null) {
                if (logger.isLoggable()) {
                    logger.finest("sqlstore.model.classdesc.vcfield", (Object)f.getName());
                }
                this.versionFields[i] = f;
                this.registerVersionFieldWithTable(f);
                f.fetchGroup = 1;
                f.sqlProperties &= 0xFFFFFFEF;
                f.sqlProperties |= 0x200;
                continue;
            }
            throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.noneexistentvcfield", mdField.getName(), this.pcClass.getName()));
        }
    }

    private void registerVersionFieldWithTable(LocalFieldDesc versionField) {
        ColumnElement ce = (ColumnElement)versionField.getColumnElements().next();
        for (TableDesc table : this.tables) {
            if (table.isJoinTable() || ce.getDeclaringTable() != table.getTableElement()) continue;
            table.setVersionField(versionField);
            break;
        }
    }

    private void computeTrackedPrimitiveFields() {
        for (int i = 0; i < this.fields.size(); ++i) {
            FieldDesc f = (FieldDesc)this.fields.get(i);
            if (f.isRelationshipField()) continue;
            LocalFieldDesc lf = (LocalFieldDesc)f;
            lf.computeTrackedPrimitiveFields();
            lf.computePrimaryTrackedPrimitiveField();
        }
    }

    private void computeTrackedRelationshipFields() {
        for (int i = 0; i < 2; ++i) {
            ArrayList theFields = null;
            if (i == 0) {
                theFields = this.fields;
            } else {
                theFields = this.hiddenFields;
                if (theFields == null) continue;
            }
            for (int j = 0; j < theFields.size(); ++j) {
                FieldDesc f = (FieldDesc)theFields.get(j);
                f.computeTrackedRelationshipFields();
            }
        }
    }

    private void cleanupTrackedFields() {
        for (int i = 0; i < this.fields.size(); ++i) {
            FieldDesc f = (FieldDesc)this.fields.get(i);
            if (!(f instanceof LocalFieldDesc)) continue;
            ((LocalFieldDesc)f).cleanupTrackedFields();
        }
    }

    private void fixupForeignReferences(ConfigCache cache) {
        for (int i = 0; i < this.foreignFields.size(); ++i) {
            ClassDesc foreignConfig;
            ForeignFieldDesc ff = (ForeignFieldDesc)this.foreignFields.get(i);
            Class classType = null;
            classType = ff.getComponentType();
            if (classType == null) {
                classType = ff.getType();
            }
            if ((foreignConfig = (ClassDesc)cache.getPersistenceConfig(classType)) == null) continue;
            String irName = this.pcElement.getRelationship(ff.getName()).getInverseRelationshipName();
            ForeignFieldDesc inverseField = null;
            if (irName != null) {
                inverseField = (ForeignFieldDesc)foreignConfig.getField(irName);
            }
            ff.fixupForeignReference(foreignConfig, inverseField);
        }
    }

    private void fixupFieldProperties() {
        for (int i = 0; i < this.foreignFields.size(); ++i) {
            ForeignFieldDesc ff = (ForeignFieldDesc)this.foreignFields.get(i);
            ff.fixupFieldProperties();
        }
    }

    LocalFieldDesc getLocalFieldDesc(ColumnElement column) {
        LocalFieldDesc result;
        for (int i = 0; i < 2; ++i) {
            ArrayList theFields = null;
            theFields = i == 0 ? this.fields : this.hiddenFields;
            if (theFields == null) continue;
            for (int j = 0; j < theFields.size(); ++j) {
                FieldDesc f = (FieldDesc)theFields.get(j);
                if (!(f instanceof LocalFieldDesc)) continue;
                result = (LocalFieldDesc)f;
                for (int k = 0; k < result.columnDescs.size(); ++k) {
                    ColumnElement c = (ColumnElement)result.columnDescs.get(k);
                    if (c.getName().getFullName().compareTo(column.getName().getFullName()) != 0 || f.getTrackedFields() != null && (f.sqlProperties & 0x20) == 0) continue;
                    return result;
                }
            }
        }
        result = this.createLocalHiddenField(column);
        return result;
    }

    public LocalFieldDesc getLocalFieldDesc(String name) {
        FieldDesc desc = this.getField(name);
        if (desc == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.unknownfield", name, this.getName()));
        }
        if (!(desc instanceof LocalFieldDesc)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", desc.getClass().getName(), "LocalFieldDesc"));
        }
        return (LocalFieldDesc)desc;
    }

    public TableDesc findTableDesc(TableElement mdTable) {
        for (int i = 0; i < this.tables.size(); ++i) {
            TableDesc t = (TableDesc)this.tables.get(i);
            if (!t.getTableElement().equals((Object)mdTable)) continue;
            return t;
        }
        return null;
    }

    private void addTableDesc(TableDesc t) {
        if (!t.isJoinTable()) {
            t.setConsistencyLevel(this.mdConfig.getConsistencyLevel());
        }
        this.tables.add(t);
    }

    public int getTableIndex(TableDesc tableDesc) {
        return this.tables.indexOf(tableDesc);
    }

    public FieldDesc getField(String name) {
        FieldDesc f;
        int i;
        for (i = 0; i < this.fields.size(); ++i) {
            f = (FieldDesc)this.fields.get(i);
            if (f == null || f.getName().compareTo(name) != 0) continue;
            return f;
        }
        if (this.hiddenFields != null) {
            for (i = 0; i < this.hiddenFields.size(); ++i) {
                f = (FieldDesc)this.hiddenFields.get(i);
                if (f.getName().compareTo(name) != 0) continue;
                return f;
            }
        }
        return null;
    }

    public FieldDesc getField(int index) {
        if (index >= 0) {
            return (FieldDesc)this.fields.get(index);
        }
        return (FieldDesc)this.hiddenFields.get(-(index + 1));
    }

    @Override
    public Constructor getConstructor() {
        return this.constructor;
    }

    @Override
    public Class getPersistenceCapableClass() {
        return this.pcClass;
    }

    @Override
    public Class getOidClass() {
        return this.oidClass;
    }

    public String getName() {
        return this.pcClass.getName();
    }

    public Iterator getTables() {
        return this.tables.iterator();
    }

    public TableDesc getPrimaryTable() {
        return (TableDesc)this.tables.get(0);
    }

    public boolean isNavigable() {
        return this.mdConfig.isNavigable();
    }

    @Override
    public boolean hasVersionConsistency() {
        return this.mdConfig.getConsistencyLevel() == 16;
    }

    public LocalFieldDesc[] getVersionFields() {
        return this.versionFields;
    }

    public Concurrency getConcurrency(boolean optimistic) {
        Concurrency concurrency = null;
        int consistencyLevel = this.mdConfig.getConsistencyLevel();
        if (consistencyLevel == 0) {
            concurrency = optimistic ? (Concurrency)this.optimisticConcurrency.clone() : (Concurrency)this.databaseConcurrency.clone();
        } else {
            switch (consistencyLevel) {
                case 1: {
                    concurrency = (Concurrency)this.checkDirtyConcurrency.clone();
                    break;
                }
                case 8: {
                    concurrency = (Concurrency)this.explicitConcurrency.clone();
                    break;
                }
                case 16: {
                    concurrency = (Concurrency)this.databaseConcurrency.clone();
                    break;
                }
                default: {
                    throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "core.configuration.unsupportedconsistencylevel", this.pcClass));
                }
            }
        }
        return concurrency;
    }

    public boolean hasModifiedCheckAtCommitConsistency() {
        return this.mdConfig.getConsistencyLevel() == 1;
    }

    public boolean isPKField(int index) {
        return this.persistentFields[index].isKey();
    }

    @Override
    public Field[] getKeyFields() {
        return this.keyFields;
    }

    @Override
    public String[] getKeyFieldNames() {
        return this.keyFieldNames;
    }

    public LocalFieldDesc[] getKeyFieldDescs() {
        return this.keyFieldDescs;
    }

    public SQLStateManager newStateManagerInstance(PersistenceStore store) {
        return new SQLStateManager(store, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrieveDesc getRetrieveDescForPKQuery(FieldDesc additionalField, PersistenceStore store) {
        RetrieveDescImpl rd = null;
        String cacheKey = this.generateRDCacheKey(additionalField);
        Map map = this.retrieveDescCache;
        synchronized (map) {
            rd = (RetrieveDescImpl)this.retrieveDescCache.get(cacheKey);
            if (rd == null) {
                rd = (RetrieveDescImpl)store.getRetrieveDesc(this.pcClass);
                if (additionalField != null) {
                    RetrieveDesc frd = null;
                    String name = additionalField.getName();
                    if (additionalField instanceof ForeignFieldDesc) {
                        Class additionalClass = ((ForeignFieldDesc)additionalField).foreignConfig.getPersistenceCapableClass();
                        frd = store.getRetrieveDesc(additionalClass);
                    }
                    rd.addPrefetchedField(name, frd);
                }
                this.addPKConstraints(rd);
                this.retrieveDescCache.put(cacheKey, rd);
            }
        }
        return rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrieveDesc getRetrieveDescForFKQuery(ForeignFieldDesc foreignField, PersistenceStore store) {
        RetrieveDescImpl rd = null;
        String cacheKey = this.generateRDCacheKey(foreignField);
        Map map = this.foreignRetrieveDescCache;
        synchronized (map) {
            rd = (RetrieveDescImpl)this.foreignRetrieveDescCache.get(cacheKey);
            if (rd == null) {
                rd = (RetrieveDescImpl)store.getRetrieveDesc(foreignField.foreignConfig.getPersistenceCapableClass());
                this.addFKConstraints(rd, foreignField);
                this.foreignRetrieveDescCache.put(cacheKey, rd);
            }
        }
        return rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrieveDesc getRetrieveDescForVerificationQuery(PersistenceStore store) {
        assert (this.hasVersionConsistency());
        Object object = this.retrieveDescForVerificationSynchObj;
        synchronized (object) {
            if (this.retrieveDescForVerification == null) {
                RetrieveDescImpl rd = (RetrieveDescImpl)store.getRetrieveDesc(this.pcClass);
                int index = this.addPKConstraints(rd);
                rd.addParameterConstraints(this.versionFields, index);
                rd.setOption(4096);
                this.retrieveDescForVerification = rd;
            }
        }
        return this.retrieveDescForVerification;
    }

    private int addPKConstraints(RetrieveDescImpl rd) {
        rd.addParameterConstraints(this.keyFieldDescs, 0);
        return this.keyFieldDescs.length;
    }

    private void addFKConstraints(RetrieveDescImpl rd, ForeignFieldDesc foreignField) {
        for (int i = 0; i < foreignField.foreignFields.size(); ++i) {
            LocalFieldDesc fff = (LocalFieldDesc)foreignField.foreignFields.get(i);
            rd.addParameterConstraint(fff, i);
        }
    }

    private String generateRDCacheKey(FieldDesc additionalField) {
        StringBuffer key = new StringBuffer();
        key.append(this.pcClass.getName());
        if (additionalField != null) {
            key.append('/');
            key.append(additionalField.getName());
            key.append('/');
            key.append(additionalField.absoluteID);
        }
        return key.toString();
    }

    @Override
    public boolean hasLocalNonDFGFields() {
        return this.hasLocalNonDFGField;
    }

    public UpdateQueryPlan getUpdateQueryPlan(UpdateObjectDescImpl desc, SQLStoreManager store) {
        switch (desc.getUpdateAction()) {
            case 1: {
                return this.getUpdateQueryPlanForInsert(desc, store);
            }
            case 2: {
                return this.getUpdateQueryPlanForDelete(desc, store);
            }
            case 3: {
                return this.getUpdateQueryPlanForUpdate(desc, store);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateQueryPlan getUpdateQueryPlanForInsert(UpdateObjectDescImpl desc, SQLStoreManager store) {
        Object object = this.updateQueryPlanForInsertSynchObj;
        synchronized (object) {
            if (this.updateQueryPlanForInsert == null) {
                this.updateQueryPlanForInsert = this.buildQueryPlan(store, desc);
            }
        }
        return this.updateQueryPlanForInsert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateQueryPlan getUpdateQueryPlanForDelete(UpdateObjectDescImpl desc, SQLStoreManager store) {
        Object object = this.updateQueryPlanForDeleteSynchObj;
        synchronized (object) {
            if (this.updateQueryPlanForDelete == null) {
                this.updateQueryPlanForDelete = this.buildQueryPlan(store, desc);
            }
        }
        return this.updateQueryPlanForDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateQueryPlan getUpdateQueryPlanForUpdate(UpdateObjectDescImpl desc, SQLStoreManager store) {
        UpdateQueryPlan plan;
        String key = this.getSortedFieldNumbers(desc.getUpdatedFields());
        Map map = this.updateQueryPlanCache;
        synchronized (map) {
            plan = (UpdateQueryPlan)this.updateQueryPlanCache.get(key);
            if (plan == null) {
                plan = this.buildQueryPlan(store, desc);
                this.updateQueryPlanCache.put(key, plan);
            }
        }
        return plan;
    }

    private UpdateQueryPlan buildQueryPlan(SQLStoreManager store, UpdateObjectDescImpl desc) {
        UpdateQueryPlan plan = new UpdateQueryPlan(desc, store);
        plan.build(true);
        plan.getStatements();
        return plan;
    }

    private String getSortedFieldNumbers(List fields) {
        int size = fields.size();
        int[] fieldNos = new int[size];
        for (int i = 0; i < size; ++i) {
            FieldDesc f = (FieldDesc)fields.get(i);
            fieldNos[i] = f.absoluteID;
        }
        Arrays.sort(fieldNos);
        return StringHelper.intArrayToSeparatedList((int[])fieldNos, (String)",");
    }
}

