/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.api.server.AccessControlContext;
import com.sun.messaging.jmq.auth.api.server.model.AccessControlModel;
import com.sun.messaging.jmq.auth.jaas.MQUser;
import com.sun.messaging.jmq.jmsserver.Globals;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class JMQAccessControlContext
implements AccessControlContext {
    private MQUser mquser;
    private Subject subject;
    private Properties authProps;
    private AccessControlModel acs = null;

    public JMQAccessControlContext(MQUser mquser, Subject subject, Properties authProperties) throws LoginException {
        this.mquser = mquser;
        this.subject = subject;
        this.authProps = authProperties;
        String acEnabled = this.authProps.getProperty("imq.accesscontrol.enabled");
        if (acEnabled != null && acEnabled.equals("false")) {
            return;
        }
        try {
            this.loadAccessControlModel();
        }
        catch (AccessControlException e) {
            throw new LoginException(e.getMessage());
        }
    }

    private void loadAccessControlModel() throws AccessControlException {
        String type = this.authProps.getProperty("imq.accesscontrol.type");
        if (type == null || type.trim().equals("")) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4044"));
        }
        String cn = this.authProps.getProperty("imq.accesscontrol." + type + ".class");
        if (cn == null) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4045", type));
        }
        try {
            this.acs = (AccessControlModel)Class.forName(cn).newInstance();
            this.acs.initialize(type, this.authProps);
        }
        catch (ClassNotFoundException e) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "ClassNotFoundException: " + e.getMessage()));
        }
        catch (InstantiationException e) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "InstantiationExcetpion: " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "IllegalAccessException: " + e.getMessage()));
        }
        catch (ClassCastException e) {
            throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "ClassCastException: " + e.getMessage()));
        }
    }

    @Override
    public Principal getClientUser() {
        return this.mquser;
    }

    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public void checkConnectionPermission(String serviceName, String serviceType) throws AccessControlException {
        String acEnabled;
        if (serviceType.equals("ADMIN") && (acEnabled = this.authProps.getProperty("imq.accesscontrol.enabled")) != null && acEnabled.equals("false")) {
            Class<?> mqadminc = null;
            try {
                mqadminc = Class.forName("com.sun.messaging.jmq.auth.jaas.MQAdminGroup");
            }
            catch (ClassNotFoundException e) {
                throw new AccessControlException(Globals.getBrokerResources().getKString("B4117", "ClassNotFoundException: " + e.getMessage()));
            }
            Set<?> s = this.subject.getPrincipals(mqadminc);
            if (s == null || s.size() == 0) {
                throw new AccessControlException(Globals.getBrokerResources().getKString("B4052", this.mquser.getName()));
            }
            return;
        }
        if (this.acs == null) {
            this.loadAccessControlModel();
        }
        this.acs.checkConnectionPermission(this.mquser, serviceName, serviceType, this.subject);
    }

    @Override
    public void checkDestinationPermission(String serviceName, String serviceType, String operation, String destination, String destinationType) throws AccessControlException {
        if (this.acs == null) {
            this.loadAccessControlModel();
        }
        this.acs.checkDestinationPermission(this.mquser, serviceName, serviceType, this.subject, operation, destination, destinationType);
    }
}

