/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.common.DoNothingActionReporter;
import com.sun.enterprise.v3.server.AppServerStartup;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.internal.api.DomainUpgrade;
import org.glassfish.internal.api.InternalSystemAdministrator;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="upgrade")
public class UpgradeStartup
implements ModuleStartup {
    @Inject
    CommandRunner runner;
    @Inject
    AppServerStartup appservStartup;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    ServerEnvironment env;
    @Inject
    @Named(value="default-instance-name")
    Server server;
    @Inject
    Domain domain;
    @Inject
    CommandRunner commandRunner;
    @Inject
    @Optional
    IterableProvider<DomainUpgrade> upgrades;
    @Inject
    Logger logger;
    @Inject
    private InternalSystemAdministrator kernelIdentity;
    private static final String MODULE_TYPE = "moduleType";
    private static final String J2EE_APPS = "j2ee-apps";
    private static final String J2EE_MODULES = "j2ee-modules";
    private static final String DOMAIN_TARGET = "domain";
    private static final String SIGNATURE_TYPES_PARAM = "-signatureTypes";
    private List<String> sigTypeList = new ArrayList<String>();

    public void setStartupContext(StartupContext startupContext) {
        this.appservStartup.setStartupContext(startupContext);
    }

    public void start() {
        ArrayList<Application> enabledApps = new ArrayList<Application>();
        ArrayList<String> enabledAppNames = new ArrayList<String>();
        for (Application app : this.domain.getApplications().getApplications()) {
            this.logger.log(Level.INFO, "app " + app.getName() + " is " + app.getEnabled() + " resulting in " + Boolean.parseBoolean(app.getEnabled()));
            if (!Boolean.parseBoolean(app.getEnabled())) continue;
            this.logger.log(Level.INFO, "Disabling application " + app.getName());
            enabledApps.add(app);
            enabledAppNames.add(app.getName());
        }
        if (enabledApps.size() > 0) {
            try {
                ConfigSupport.apply(new ConfigCode(){

                    @Override
                    public Object run(ConfigBeanProxy ... configBeanProxies) throws PropertyVetoException, TransactionFailure {
                        for (ConfigBeanProxy proxy : configBeanProxies) {
                            Application app = (Application)proxy;
                            app.setEnabled(Boolean.FALSE.toString());
                        }
                        return null;
                    }
                }, (ConfigBeanProxy[])enabledApps.toArray(new Application[enabledApps.size()]));
            }
            catch (TransactionFailure tf) {
                this.logger.log(Level.SEVERE, "Exception while disabling applications", tf);
                return;
            }
        }
        this.appservStartup.start();
        this.initializeSigTypeList();
        for (Application app : this.applications.getApplications()) {
            if (Boolean.valueOf(app.getDeployProperties().getProperty("isLifecycle")).booleanValue()) continue;
            this.logger.log(Level.INFO, "Redeploy application " + app.getName() + " located at " + app.getLocation());
            this.redeployApp(app);
        }
        if (enabledAppNames.size() > 0) {
            for (Application app : this.domain.getApplications().getApplications()) {
                if (!enabledAppNames.contains(app.getName())) continue;
                this.logger.log(Level.INFO, "Enabling application " + app.getName());
                try {
                    ConfigSupport.apply(new SingleConfigCode<Application>(){

                        @Override
                        public Object run(Application param) throws PropertyVetoException, TransactionFailure {
                            if (!Boolean.parseBoolean(param.getEnabled())) {
                                param.setEnabled(Boolean.TRUE.toString());
                            }
                            return null;
                        }
                    }, app);
                }
                catch (TransactionFailure tf) {
                    this.logger.log(Level.SEVERE, "Exception while disabling applications", tf);
                    return;
                }
            }
        }
        this.cleanupLeftOverDirectories();
        KernelLoggerInfo.getLogger().info("NCLS-CORE-00082");
        try {
            Thread.sleep(3000L);
            if (this.runner != null) {
                this.runner.getCommandInvocation("stop-domain", new DoNothingActionReporter(), this.kernelIdentity.getSubject()).execute();
            }
        }
        catch (InterruptedException e) {
            KernelLoggerInfo.getLogger().log(Level.SEVERE, "NCLS-CORE-00083", e);
        }
    }

    public void stop() {
        this.appservStartup.stop();
    }

    private void cleanupLeftOverDirectories() {
        File oldJ2eeAppsRepository = new File(this.env.getApplicationRepositoryPath(), J2EE_APPS);
        FileUtils.whack((File)oldJ2eeAppsRepository);
        File oldJ2eeModulesRepository = new File(this.env.getApplicationRepositoryPath(), J2EE_MODULES);
        FileUtils.whack((File)oldJ2eeModulesRepository);
        File oldJ2eeAppsGeneratedXMLDir = new File(this.env.getApplicationGeneratedXMLPath(), J2EE_APPS);
        FileUtils.whack((File)oldJ2eeAppsGeneratedXMLDir);
        File oldJ2eeModulesGeneratedXMLDir = new File(this.env.getApplicationGeneratedXMLPath(), J2EE_MODULES);
        FileUtils.whack((File)oldJ2eeModulesGeneratedXMLDir);
        File oldJ2eeAppsEJBStubDir = new File(this.env.getApplicationEJBStubPath(), J2EE_APPS);
        FileUtils.whack((File)oldJ2eeAppsEJBStubDir);
        File oldJ2eeModulesEJBStubDir = new File(this.env.getApplicationEJBStubPath(), J2EE_MODULES);
        FileUtils.whack((File)oldJ2eeModulesEJBStubDir);
        File oldJ2eeAppsJSPCompileDir = new File(this.env.getApplicationCompileJspPath(), J2EE_APPS);
        FileUtils.whack((File)oldJ2eeAppsJSPCompileDir);
        File oldJ2eeModulesJSPCompileDir = new File(this.env.getApplicationCompileJspPath(), J2EE_MODULES);
        FileUtils.whack((File)oldJ2eeModulesJSPCompileDir);
        File policyRootDir = this.env.getApplicationPolicyFilePath();
        File adminapp = new File(policyRootDir, "adminapp");
        FileUtils.whack((File)adminapp);
        File admingui = new File(policyRootDir, "admingui");
        FileUtils.whack((File)admingui);
        File ejbtimer = new File(policyRootDir, "__ejb_container_timer_app");
        FileUtils.whack((File)ejbtimer);
        File mejbapp = new File(policyRootDir, "MEjbApp");
        FileUtils.whack((File)mejbapp);
        File wstx = new File(policyRootDir, "WSTXServices");
        FileUtils.whack((File)wstx);
        File jwsappclient = new File(policyRootDir, "__JWSappclients");
        FileUtils.whack((File)jwsappclient);
    }

    private boolean redeployApp(Application app) {
        if (app.getModule().size() > 0) {
            this.logger.log(Level.INFO, "Skip redeploying v3 type application " + app.getName());
            return true;
        }
        DeployCommandParameters deployParams = app.getDeployParameters(null);
        if (!Boolean.valueOf(app.getDirectoryDeployed()).booleanValue()) {
            File repackagedFile = null;
            try {
                repackagedFile = this.repackageArchive(app);
            }
            catch (IOException ioe) {
                this.logger.log(Level.SEVERE, "Repackaging of application " + app.getName() + " failed: " + ioe.getMessage(), ioe);
                return false;
            }
            if (repackagedFile == null) {
                this.logger.log(Level.SEVERE, "Repackaging of application " + app.getName() + " failed.");
                return false;
            }
            this.logger.log(Level.INFO, "Repackaged application " + app.getName() + " at " + repackagedFile.getPath());
            deployParams.path = repackagedFile;
        }
        deployParams.properties = app.getDeployProperties();
        deployParams.properties.remove(MODULE_TYPE);
        deployParams.properties.setProperty("compatibility", "v2");
        deployParams.enabled = null;
        deployParams.force = true;
        deployParams.dropandcreatetables = false;
        deployParams.createtables = false;
        deployParams.target = DOMAIN_TARGET;
        DoNothingActionReporter report = new DoNothingActionReporter();
        this.commandRunner.getCommandInvocation("deploy", report, this.kernelIdentity.getSubject()).parameters(deployParams).execute();
        if (((ActionReport)report).getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
            this.logger.log(Level.SEVERE, "Redeployment of application " + app.getName() + " failed: " + ((ActionReport)report).getMessage() + "\nPlease redeploy " + app.getName() + " manually.", ((ActionReport)report).getFailureCause());
            return false;
        }
        return true;
    }

    private File repackageArchive(Application app) throws IOException {
        URI uri = null;
        try {
            uri = new URI(app.getLocation());
        }
        catch (URISyntaxException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (uri == null) {
            return null;
        }
        Properties appProperties = app.getDeployProperties();
        String moduleType = appProperties.getProperty(MODULE_TYPE);
        String suffix = this.getSuffixFromType(moduleType);
        if (suffix == null) {
            suffix = ".jar";
        }
        File repositoryDir = new File(uri);
        File tmp = File.createTempFile("upgrade", null);
        String targetParentDir = tmp.getParent();
        boolean isDeleted = tmp.delete();
        if (!isDeleted) {
            this.logger.log(Level.WARNING, "Error in deleting file " + tmp.getAbsolutePath());
        }
        if (moduleType.equals("j2ee-application")) {
            return this.repackageApplication(repositoryDir, targetParentDir, suffix);
        }
        return this.repackageStandaloneModule(repositoryDir, targetParentDir, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File repackageApplication(File appDir, String targetParentDir, String suffix) throws IOException {
        boolean isDeleted;
        String appName = appDir.getName();
        ReadableArchive source = this.archiveFactory.openArchive(appDir);
        File tempEar = new File(targetParentDir, appName + suffix);
        if (tempEar.exists() && !(isDeleted = tempEar.delete())) {
            this.logger.log(Level.WARNING, "Error in deleting file " + tempEar.getAbsolutePath());
        }
        WritableArchive target = this.archiveFactory.createArchive("jar", tempEar);
        Collection<String> directoryEntries = source.getDirectories();
        ArrayList<String> subModuleEntries = new ArrayList<String>();
        ArrayList<String> entriesToExclude = new ArrayList<String>();
        for (String directoryEntry : directoryEntries) {
            if (!directoryEntry.endsWith("_jar") && !directoryEntry.endsWith("_war") && !directoryEntry.endsWith("_rar")) continue;
            subModuleEntries.add(directoryEntry);
            File moduleJar = this.processModule(new File(appDir, directoryEntry), targetParentDir, null);
            OutputStream os = null;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(moduleJar));
            try {
                os = target.putNextEntry(moduleJar.getName());
                FileUtils.copy((InputStream)is, (OutputStream)os, (long)moduleJar.length());
            }
            finally {
                if (os != null) {
                    target.closeEntry();
                }
                ((InputStream)is).close();
            }
        }
        for (String subModuleEntry : subModuleEntries) {
            Enumeration<String> ee = source.entries(subModuleEntry);
            while (ee.hasMoreElements()) {
                String eeEntryName = ee.nextElement();
                entriesToExclude.add(eeEntryName);
            }
        }
        Enumeration<String> e = source.entries();
        while (e.hasMoreElements()) {
            String entryName = e.nextElement();
            if (entriesToExclude.contains(entryName)) continue;
            InputStream sis = source.getEntry(entryName);
            if (this.isSigFile(entryName)) {
                this.logger.log(Level.INFO, "Excluding signature file: " + entryName + " from repackaged application: " + appName + "\n");
                continue;
            }
            if (sis == null) continue;
            BufferedInputStream is = new BufferedInputStream(sis);
            OutputStream os = null;
            try {
                os = target.putNextEntry(entryName);
                FileUtils.copy((InputStream)is, (OutputStream)os, (long)source.getEntrySize(entryName));
            }
            finally {
                if (os != null) {
                    target.closeEntry();
                }
                ((InputStream)is).close();
            }
        }
        Manifest m = source.getManifest();
        if (m != null) {
            this.processManifest(m, appName);
            OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
            m.write(os);
            target.closeEntry();
        }
        source.close();
        target.close();
        return tempEar;
    }

    private File repackageStandaloneModule(File moduleDirName, String targetParentDir, String suffix) throws IOException {
        return this.processModule(moduleDirName, targetParentDir, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File processModule(File moduleDir, String targetParentDir, String suffix) throws IOException {
        boolean isDeleted;
        String moduleName = moduleDir.getName();
        if (moduleName.endsWith("_jar") || moduleName.endsWith("_war") || moduleName.endsWith("_rar")) {
            suffix = "." + moduleName.substring(moduleName.length() - 3);
            moduleName = moduleName.substring(0, moduleName.lastIndexOf(95));
        }
        ReadableArchive source = this.archiveFactory.openArchive(moduleDir);
        File tempJar = new File(targetParentDir, moduleName + suffix);
        if (tempJar.exists() && !(isDeleted = tempJar.delete())) {
            this.logger.log(Level.WARNING, "Error in deleting file " + tempJar.getAbsolutePath());
        }
        WritableArchive target = this.archiveFactory.createArchive("jar", tempJar);
        Enumeration<String> e = source.entries();
        while (e.hasMoreElements()) {
            String entryName = e.nextElement();
            if (this.isSigFile(entryName)) {
                this.logger.log(Level.INFO, "Excluding signature file: " + entryName + " from repackaged module: " + moduleName + "\n");
                continue;
            }
            InputStream sis = source.getEntry(entryName);
            if (sis == null) continue;
            BufferedInputStream is = new BufferedInputStream(sis);
            OutputStream os = null;
            try {
                os = target.putNextEntry(entryName);
                FileUtils.copy((InputStream)is, (OutputStream)os, (long)source.getEntrySize(entryName));
            }
            finally {
                if (os != null) {
                    target.closeEntry();
                }
                ((InputStream)is).close();
            }
        }
        Manifest m = source.getManifest();
        if (m != null) {
            this.processManifest(m, moduleName);
            OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
            m.write(os);
            target.closeEntry();
        }
        source.close();
        target.close();
        return tempJar;
    }

    private String getSuffixFromType(String moduleType) {
        if (moduleType == null) {
            return null;
        }
        if (moduleType.equals("connector-module")) {
            return ".rar";
        }
        if (moduleType.equals("ejb-module")) {
            return ".jar";
        }
        if (moduleType.equals("web-module")) {
            return ".war";
        }
        if (moduleType.equals("appclient-module")) {
            return ".jar";
        }
        if (moduleType.equals("j2ee-application")) {
            return ".ear";
        }
        return null;
    }

    private void initializeSigTypeList() {
        String sigTypesParam = this.env.getStartupContext().getArguments().getProperty(SIGNATURE_TYPES_PARAM);
        if (sigTypesParam != null) {
            this.sigTypeList = StringUtils.parseStringList((String)sigTypesParam, (String)",");
        }
        this.sigTypeList.add(".SF");
        this.sigTypeList.add(".sf");
        this.sigTypeList.add(".RSA");
        this.sigTypeList.add(".rsa");
        this.sigTypeList.add(".DSA");
        this.sigTypeList.add(".dsa");
        this.sigTypeList.add(".PGP");
        this.sigTypeList.add(".pgp");
    }

    private boolean isSigFile(String entryName) {
        for (String sigType : this.sigTypeList) {
            if (!entryName.endsWith(sigType)) continue;
            return true;
        }
        return false;
    }

    private void processManifest(Manifest m, String moduleName) {
        Map<String, Attributes> entries = m.getEntries();
        Iterator<Map.Entry<String, Attributes>> entryItr = entries.entrySet().iterator();
        while (entryItr.hasNext()) {
            Attributes attr = entryItr.next().getValue();
            Iterator<Map.Entry<Object, Object>> attrItr = attr.entrySet().iterator();
            while (attrItr.hasNext()) {
                Attributes.Name attrKey2;
                Object attrKey = attrItr.next().getKey();
                if (!(attrKey instanceof Attributes.Name) || !(attrKey2 = (Attributes.Name)attrKey).toString().trim().equals("Digest-Algorithms") && attrKey2.toString().indexOf("-Digest") == -1) continue;
                this.logger.log(Level.INFO, "Removing signature attribute " + attrKey2 + " from manifest in " + moduleName + "\n");
                attrItr.remove();
            }
            if (attr.size() != 0) continue;
            entryItr.remove();
        }
    }
}

