/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.admin.commands.CLIUtil;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-jvm-options")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.jvm.options")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-jvm-options", description="list-jvm-options")})
public final class ListJvmOptions
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="profiler", optional=true)
    Boolean profiler = false;
    @Inject
    Target targetService;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    private static final StringManager lsm = StringManager.getManager(ListJvmOptions.class);
    @AccessRequired.To(value={"read"})
    private JavaConfig jc;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.updateConfigIfNeeded(this.config, this.targetService, this.target);
        this.jc = this.config.getJavaConfig();
        return true;
    }

    @Override
    public void execute(AdminCommandContext context) {
        List opts;
        ActionReport report = context.getActionReport();
        if (this.profiler.booleanValue()) {
            if (this.jc.getProfiler() == null) {
                report.setMessage(lsm.getString("create.profiler.first"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            opts = this.jc.getProfiler().getJvmOptions();
        } else {
            opts = this.jc.getJvmOptions();
        }
        try {
            for (String option : opts) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(option);
            }
        }
        catch (Exception e) {
            report.setMessage(lsm.getStringWithDefault("list.jvm.options.failed", "Command: list-jvm-options failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

