/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui.emfresource;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hawk.emfresource.impl.LocalHawkResourceImpl;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.timeaware.graph.DefaultTimeGraphWrapper;
import org.eclipse.hawk.ui.emfresource.Activator;
import org.eclipse.hawk.ui2.util.HUIManager;

public class LocalHawkResourceFactoryImpl
implements Resource.Factory {
    public static final String FILE_ENCODING = "UTF-8";
    public static final String OPTION_UNSPLIT = "unsplit";
    public static final String OPTION_RPATTERNS = "repos";
    public static final String OPTION_FPATTERNS = "files";
    public static final String OPTION_TIMEPOINT = "timepoint";
    public static final String KEYVAL_SEPARATOR = "=";
    public static final String PATTERN_SEPARATOR = ",";

    public Resource createResource(URI uri) {
        String hawkInstance;
        List<String> repoPatterns;
        boolean isSplit = true;
        List<String> filePatterns = repoPatterns = Arrays.asList("*");
        Long timepoint = null;
        if ("hawk+local".equals(uri.scheme())) {
            hawkInstance = uri.host();
        } else {
            String filePath = CommonPlugin.resolve((URI)uri).toFileString();
            if (filePath == null) {
                Activator.logWarn("Could not resolve " + uri + " into a file: returning an empty resource");
                return this.createEmptyResource(uri);
            }
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), FILE_ENCODING));){
                    String optionLine;
                    hawkInstance = br.readLine();
                    while ((optionLine = br.readLine()) != null) {
                        String[] parts = (optionLine = optionLine.trim()).split(KEYVAL_SEPARATOR, 2);
                        if (parts.length == 1 && parts[0].equals(OPTION_UNSPLIT)) {
                            isSplit = false;
                            continue;
                        }
                        if (parts.length == 2 && parts[0].equals(OPTION_RPATTERNS)) {
                            repoPatterns = Arrays.asList(parts[1].split(PATTERN_SEPARATOR));
                            continue;
                        }
                        if (parts.length == 2 && parts[0].equals(OPTION_FPATTERNS)) {
                            filePatterns = Arrays.asList(parts[1].split(PATTERN_SEPARATOR));
                            continue;
                        }
                        if (parts.length != 2 || !parts[0].equals(OPTION_TIMEPOINT)) continue;
                        timepoint = Long.parseLong(parts[1].trim());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.logError("Could not read " + filePath, e);
                return this.createEmptyResource(uri);
            }
        }
        HUIManager manager = HUIManager.getInstance();
        HModel hawkModel = manager.getHawkByName(hawkInstance);
        if (hawkModel == null) {
            return this.createEmptyResource(uri);
        }
        if (!hawkModel.isRunning()) {
            hawkModel.start((HManager)manager);
        }
        if (timepoint == null) {
            return new LocalHawkResourceImpl(uri, hawkModel.getIndexer(), isSplit, repoPatterns, filePatterns);
        }
        long fTimepoint = timepoint;
        return new LocalHawkResourceImpl(uri, hawkModel.getIndexer(), idx -> new DefaultTimeGraphWrapper(idx.getGraph(), fTimepoint), isSplit, repoPatterns, filePatterns);
    }

    protected LocalHawkResourceImpl createEmptyResource(URI uri) {
        return new LocalHawkResourceImpl(uri, null, true, Arrays.asList("*"), Arrays.asList("*"));
    }
}

