/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.emf;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.graph.syncValidationListener.SyncValidationListener;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.eclipse.hawk.localfolder.LocalFolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class CountInstancesTest
extends ModelIndexingTest {
    @Rule
    public ModelIndexingTest.GraphChangeListenerRule<SyncValidationListener> syncValidation = new ModelIndexingTest.GraphChangeListenerRule((ModelIndexingTest)this, (IGraphChangeListener)new SyncValidationListener());

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public CountInstancesTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new EMFModelSupportFactory());
    }

    @Test
    public void tree() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/Tree.ecore")});
        this.requestFolderIndex(new File(this.baseDir, "resources/models/tree"));
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Assert.assertEquals((Object)2, (Object)this.eol("return Tree.all.size;"));
            Assert.assertEquals((Object)"t3", (Object)this.eol("return Tree.all.selectOne(t|t.label='t9000').eContainer.label;"));
            Assert.assertEquals((Object)0, (Object)this.eol("return Tree.all.selectOne(t|t.label='t3').eContainers.size;"));
            Assert.assertEquals((Object)1, (Object)this.eol("return Tree.all.selectOne(t|t.label='t9000').eContainers.size;"));
            return null;
        });
    }

    @Test
    public void treeCrossResourceContainment() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/Tree.ecore")});
        this.requestFolderIndex(new File(this.baseDir, "resources/models/tree-xres"));
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Assert.assertEquals((Object)3, (Object)this.eol("return Model.allContents.select(t:Tree|true).size;"));
            Collection labels = (Collection)this.eol("return Model.allContents.collect(t:Tree|t.label);");
            Assert.assertEquals((long)3L, (long)labels.size());
            for (String e : Arrays.asList("xyz", "root", "abc")) {
                Assert.assertTrue((boolean)labels.contains(e));
            }
            Assert.assertEquals((Object)3, (Object)this.eol("return Tree.all.size;"));
            Assert.assertEquals((Object)2, (Object)this.eol("return Tree.all.selectOne(t|t.label='root').children.size;"));
            Assert.assertEquals((Object)"root", (Object)this.eol("return Tree.all.selectOne(t|t.label='xyz').eContainer.label;"));
            Assert.assertEquals((Object)"root", (Object)this.eol("return Tree.all.selectOne(t|t.label='abc').eContainer.label;"));
            return null;
        });
    }

    @Test
    public void set0() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/JDTAST.ecore")});
        this.requestFolderIndex(new File(this.baseDir, "resources/models/set0"));
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Assert.assertEquals((Object)1, (Object)this.eol("return IJavaProject.all.size;"));
            Assert.assertEquals((Object)1, (Object)this.eol("return `org.amma.dsl.jdt.core`::IJavaProject.all.size;"));
            Assert.assertEquals((Object)1, (Object)this.eol("return Core::IJavaProject.all.size;"));
            int reportedSize = (Integer)this.eol("return TypeDeclaration.all.size;");
            Collection actualList = (Collection)this.eol("return TypeDeclaration.all;");
            Assert.assertEquals((long)reportedSize, (long)actualList.size());
            return null;
        });
    }

    @Test
    public void treeWithSpaces() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/Tree.ecore")});
        LocalFolder vcs = new LocalFolder();
        File folder = new File(this.baseDir, "resources/models");
        vcs.init(folder.getAbsolutePath(), this.indexer);
        vcs.setFileFilter(f -> f.getPath().contains("tree with spaces"));
        vcs.run();
        this.indexer.addVCSManager((IVcsManager)vcs, true);
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Assert.assertEquals((Object)1, (Object)this.eol("return Tree.all.size;"));
            Assert.assertEquals((Object)1, (Object)this.eol("return Model.getAllOf('Tree', 'Tree', '/tree with spaces/space tree.model').size;"));
            Assert.assertEquals((Object)1, (Object)this.eol("return Model.getAllOf('Tree', 'Tree', '/tree%20with%20spaces/space%20tree.model').size;"));
            return null;
        });
    }
}

