/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emfresource.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphNodeReference;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.emfresource.HawkResource;
import org.eclipse.hawk.emfresource.HawkResourceChangeListener;
import org.eclipse.hawk.emfresource.impl.HawkFileResourceImpl;
import org.eclipse.hawk.emfresource.impl.LocalHawkResourceUpdater;
import org.eclipse.hawk.emfresource.util.AttributeUtils;
import org.eclipse.hawk.emfresource.util.LazyEObjectFactory;
import org.eclipse.hawk.emfresource.util.LazyResolver;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.MetamodelNode;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.TypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHawkResourceImpl
extends ResourceImpl
implements HawkResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalHawkResourceImpl.class);
    private final Cache<String, EObject> nodeIdToEObjectCache = CacheBuilder.newBuilder().softValues().build();
    private final Cache<EObject, String> eObjectToNodeIdCache = CacheBuilder.newBuilder().weakKeys().build();
    private final Map<EObject, Object> dirtyObjects = new IdentityHashMap<EObject, Object>();
    private final Map<String, HawkFileResourceImpl> uriToResource = new HashMap<String, HawkFileResourceImpl>();
    private final Map<String, FileNode> uriToFileNode = new HashMap<String, FileNode>();
    private final Function<IModelIndexer, GraphWrapper> graphWrapperProvider;
    private LazyResolver lazyResolver;
    private IGraphChangeListener changeListener;
    private LazyEObjectFactory eobFactory;
    private IModelIndexer indexer;
    private Set<Runnable> syncEndListeners = new HashSet<Runnable>();
    private final boolean isSplit;
    private List<String> repositoryPatterns;
    private List<String> filePatterns;

    private static EClass getEClass(String metamodelUri, String typeName, EPackage.Registry packageRegistry) {
        EPackage pkg = packageRegistry.getEPackage(metamodelUri);
        if (pkg == null) {
            throw new NoSuchElementException(String.format("Could not find EPackage with URI '%s' in the registry %s", metamodelUri, packageRegistry));
        }
        EClassifier eClassifier = pkg.getEClassifier(typeName);
        if (!(eClassifier instanceof EClass)) {
            throw new NoSuchElementException(String.format("Received an element of type '%s', which is not an EClass", eClassifier));
        }
        EClass eClass = (EClass)eClassifier;
        return eClass;
    }

    public LocalHawkResourceImpl() {
        this.isSplit = true;
        this.graphWrapperProvider = idx -> new GraphWrapper(idx.getGraph());
    }

    public LocalHawkResourceImpl(URI uri, IModelIndexer indexer, boolean isSplit, List<String> repoPatterns, List<String> filePatterns) {
        this(uri, indexer, idx -> new GraphWrapper(idx.getGraph()), isSplit, repoPatterns, filePatterns);
    }

    public LocalHawkResourceImpl(URI uri, IModelIndexer indexer, Function<IModelIndexer, GraphWrapper> graphProvider, boolean isSplit, List<String> repoPatterns, List<String> filePatterns) {
        super(uri);
        if (indexer == null) {
            throw new NullPointerException("indexer cannot be null");
        }
        this.indexer = indexer;
        this.isSplit = isSplit;
        this.repositoryPatterns = repoPatterns;
        this.filePatterns = filePatterns;
        this.graphWrapperProvider = graphProvider;
    }

    public void load(Map<?, ?> options) throws IOException {
        this.doLoad();
    }

    public void save(Map<?, ?> options) throws IOException {
        this.doSave(null, null);
    }

    @Override
    public String getEObjectNodeID(EObject obj) {
        return (String)this.eObjectToNodeIdCache.getIfPresent((Object)obj);
    }

    @Override
    public boolean hasChildren(EObject o) {
        String nodeId = (String)this.eObjectToNodeIdCache.getIfPresent((Object)o);
        GraphWrapper gW = this.graphWrapperProvider.apply(this.indexer);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (IGraphTransaction tx = this.indexer.getGraph().beginTransaction();){
                ModelElementNode node = gW.getModelElementNodeById((Object)nodeId);
                boolean ret = node.hasChildren();
                tx.success();
                return ret;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            return false;
        }
    }

    @Override
    public void fetchAttributes(Map<String, EObject> idToEObject) {
    }

    public EList<EObject> fetchByQuery(String language, String query, Map<String, Object> context) throws Exception {
        Map knownQL = this.indexer.getKnownQueryLanguages();
        IQueryEngine queryEngine = (IQueryEngine)knownQL.get(language);
        if (queryEngine == null) {
            throw new IllegalArgumentException(String.format("Unknown query langue %s: known query languages are %s", language, knownQL.keySet()));
        }
        ArrayList<String> ids = new ArrayList<String>();
        Object rawResult = queryEngine.query(this.indexer, query, context);
        this.addAllResults(rawResult, ids);
        return this.fetchNodes(ids, true);
    }

    private List<String> addAllResults(Object rawResult, List<String> ids) {
        if (rawResult instanceof Iterable) {
            for (Object rawElem : (Iterable)rawResult) {
                this.addAllResults(rawElem, ids);
            }
        } else if (rawResult instanceof IGraphNodeReference) {
            IGraphNodeReference ref = (IGraphNodeReference)rawResult;
            ids.add(ref.getId());
        }
        return ids;
    }

    @Override
    public EList<EObject> fetchNodes(List<String> ids, boolean fetchAttributes) throws Exception {
        EObject cached22;
        ArrayList<EObject> allCached = new ArrayList<EObject>();
        ArrayList<String> toBeFetched = new ArrayList<String>();
        for (String id : ids) {
            cached22 = (EObject)this.nodeIdToEObjectCache.getIfPresent((Object)id);
            if (cached22 != null) {
                allCached.add(cached22);
                continue;
            }
            toBeFetched.add(id);
        }
        EList<EObject> fetched = null;
        if (!toBeFetched.isEmpty()) {
            Object object = null;
            cached22 = null;
            try (IGraphTransaction tx = this.indexer.getGraph().beginTransaction();){
                GraphWrapper gw = this.graphWrapperProvider.apply(this.indexer);
                ArrayList<ModelElementNode> elems = new ArrayList<ModelElementNode>();
                for (String id : toBeFetched) {
                    elems.add(gw.getModelElementNodeById((Object)id));
                }
                fetched = this.createOrUpdateEObjects(elems);
                tx.success();
            }
            catch (Throwable cached22) {
                if (object == null) {
                    object = cached22;
                } else if (object != cached22) {
                    ((Throwable)object).addSuppressed(cached22);
                }
                throw object;
            }
        }
        BasicEList finalList = new BasicEList(ids.size());
        for (String id : ids) {
            EObject eObject = (EObject)this.nodeIdToEObjectCache.getIfPresent((Object)id);
            finalList.add((Object)eObject);
        }
        return finalList;
    }

    @Override
    public EList<EObject> fetchNodes(EClass eClass, boolean fetchAttributes) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (IGraphTransaction tx = this.indexer.getGraph().beginTransaction();){
            GraphWrapper gw = this.graphWrapperProvider.apply(this.indexer);
            MetamodelNode mn = gw.getMetamodelNodeByNsURI(eClass.getEPackage().getNsURI());
            for (TypeNode tn : mn.getTypes()) {
                if (!eClass.getName().equals(tn.getTypeName())) continue;
                Iterable instances = tn.getAll();
                return this.createOrUpdateEObjects(instances);
            }
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        LOGGER.warn("Could not find a type node for EClass {}:{}", (Object)eClass.getEPackage().getNsURI(), (Object)eClass.getName());
        return new BasicEList();
    }

    @Override
    public Object performRawQuery(String queryLanguage, String query, Map<String, Object> context) throws Exception {
        IQueryEngine ql = (IQueryEngine)this.indexer.getKnownQueryLanguages().get(queryLanguage);
        return ql.query(this.indexer, query, context);
    }

    @Override
    public EObject fetchNode(String id, boolean fetchAttributes) throws Exception {
        EList<EObject> fetched = this.fetchNodes(Arrays.asList(id), fetchAttributes);
        if (!fetched.isEmpty()) {
            return (EObject)fetched.get(0);
        }
        return null;
    }

    @Override
    public EObject fetchNode(HawkResource containerResource, String uriFragment, boolean fetchAttributes) throws Exception {
        if (!(containerResource instanceof HawkFileResourceImpl)) {
            return null;
        }
        HawkFileResourceImpl r = (HawkFileResourceImpl)containerResource;
        FileNode fileNode = this.uriToFileNode.get(r.getURI().toString());
        LOGGER.warn("Iterating over the contents of {}{} to find fragment {}: inefficient!", new Object[]{fileNode.getRepositoryURL(), fileNode.getFilePath(), uriFragment});
        String nodeId = null;
        Throwable throwable = null;
        Object var8_9 = null;
        try (IGraphTransaction tx = fileNode.getNode().getGraph().beginTransaction();){
            for (ModelElementNode me : fileNode.getModelElements()) {
                String fragment = me.getElementId();
                String currentNodeId = me.getNodeId();
                if (!uriFragment.equals(fragment)) continue;
                nodeId = currentNodeId;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (nodeId != null) {
            return this.fetchNode(nodeId, fetchAttributes);
        }
        return null;
    }

    protected EList<EObject> fetchNodesByQueryResults(List<Object> queryResults) throws Exception {
        ArrayList<ModelElementNode> nodes = new ArrayList<ModelElementNode>();
        for (Object r : queryResults) {
            if (!(r instanceof IGraphNodeReference)) continue;
            IGraphNodeReference ref = (IGraphNodeReference)r;
            IGraphNode node = ref.getNode();
            ModelElementNode men = new ModelElementNode(node);
            nodes.add(men);
        }
        return this.createOrUpdateEObjects(nodes);
    }

    @Override
    public List<Object> fetchValuesByEClassifier(EClassifier dataType) throws Exception {
        Map<EClass, List<EStructuralFeature>> candidateTypes = this.fetchTypesWithEClassifier(dataType);
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<EClass, List<EStructuralFeature>> entry : candidateTypes.entrySet()) {
            EClass eClass = entry.getKey();
            List<EStructuralFeature> attrsWithType = entry.getValue();
            for (EObject eob : this.fetchNodes(eClass, true)) {
                for (EStructuralFeature attr : attrsWithType) {
                    Object o = eob.eGet(attr);
                    if (o == null) continue;
                    values.add(o);
                }
            }
        }
        return values;
    }

    @Override
    public Map<EClass, List<EStructuralFeature>> fetchTypesWithEClassifier(EClassifier dataType) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (IGraphTransaction tx = this.indexer.getGraph().beginTransaction();){
            GraphWrapper gw = this.graphWrapperProvider.apply(this.indexer);
            IdentityHashMap<EClass, List<EStructuralFeature>> candidateTypes = new IdentityHashMap<EClass, List<EStructuralFeature>>();
            for (MetamodelNode mn : gw.getMetamodelNodes()) {
                String nsURI = mn.getUri();
                EPackage pkg = this.getResourceSet().getPackageRegistry().getEPackage(nsURI);
                if (pkg != null) {
                    for (TypeNode tn : mn.getTypes()) {
                        EClassifier classifier;
                        if (!tn.getAll().iterator().hasNext()) continue;
                        String name = tn.getTypeName();
                        if (pkg == null || !((classifier = pkg.getEClassifier(name)) instanceof EClass)) continue;
                        EClass eClass = (EClass)classifier;
                        for (EStructuralFeature sf : eClass.getEAllStructuralFeatures()) {
                            if (sf.getEType() != dataType) continue;
                            ArrayList<EStructuralFeature> features = (ArrayList<EStructuralFeature>)candidateTypes.get(eClass);
                            if (features == null) {
                                features = new ArrayList<EStructuralFeature>();
                                candidateTypes.put(eClass, features);
                            }
                            features.add(sf);
                        }
                    }
                    continue;
                }
                LOGGER.warn("We do not have the '{}' EPackage in the registry, skipping", (Object)nsURI);
            }
            tx.success();
            return candidateTypes;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Map<EObject, Object> fetchValuesByEStructuralFeature(EStructuralFeature feature) throws Exception {
        EClass featureEClass = feature.getEContainingClass();
        EList<EObject> eobs = this.fetchNodes(featureEClass, true);
        if (feature instanceof EReference) {
            EReference ref = (EReference)feature;
            ArrayList<String> allPending = new ArrayList<String>();
            for (EObject eob : eobs) {
                EList<Object> pending = this.lazyResolver.getPending(eob, ref);
                if (pending == null) continue;
                for (Object p : pending) {
                    if (!(p instanceof String)) continue;
                    allPending.add((String)p);
                }
            }
            this.fetchNodes(allPending, false);
        }
        IdentityHashMap<EObject, Object> values = new IdentityHashMap<EObject, Object>();
        for (EObject eob : eobs) {
            Object value = eob.eGet(feature);
            if (value == null) continue;
            values.put(eob, value);
        }
        return values;
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        this.doLoad();
    }

    protected void doLoad() throws IOException {
        try {
            if (!this.indexer.isRunning()) {
                throw new IOException(String.format("The Hawk instance with name '%s' is not running: please start it first", this.indexer.getName()));
            }
            this.lazyResolver = new LazyResolver(this);
            this.eobFactory = new LazyEObjectFactory(this.getResourceSet().getPackageRegistry(), new LazyReferenceResolver());
            GraphWrapper gw = this.graphWrapperProvider.apply(this.indexer);
            Throwable throwable = null;
            Object var3_6 = null;
            try (IGraphTransaction tx = this.indexer.getGraph().beginTransaction();){
                for (FileNode fileNode : gw.getFileNodes(this.repositoryPatterns, this.filePatterns)) {
                    for (ModelElementNode elem : fileNode.getRootModelElements()) {
                        if (elem.isContained()) continue;
                        EObject eob = this.createOrUpdateEObject(elem);
                        this.getContents().add((Object)eob);
                    }
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.changeListener = new LocalHawkResourceUpdater(this);
            this.indexer.addGraphChangeListener(this.changeListener);
            this.setLoaded(true);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void doUnload() {
        if (!this.getContents().isEmpty()) {
            this.getContents().clear();
        }
        this.getErrors().clear();
        this.getWarnings().clear();
        for (Resource resource : this.uriToResource.values()) {
            resource.unload();
        }
        this.uriToResource.clear();
        this.uriToFileNode.clear();
        if (this.indexer != null) {
            this.indexer.removeGraphChangeListener(this.changeListener);
        }
        this.nodeIdToEObjectCache.invalidateAll();
        this.eObjectToNodeIdCache.invalidateAll();
        this.lazyResolver = null;
        this.changeListener = null;
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        LOGGER.warn("Hawk views are read-only: ignoring request to save");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EList<EObject> createOrUpdateEObjects(Iterable<ModelElementNode> elems) throws Exception {
        Cache<String, EObject> cache = this.nodeIdToEObjectCache;
        synchronized (cache) {
            BasicEList eObjects = new BasicEList();
            for (ModelElementNode me : elems) {
                EObject eob = this.createOrUpdateEObject(me);
                eObjects.add((Object)eob);
            }
            return eObjects;
        }
    }

    protected EObject getNodeEObject(String id) {
        return (EObject)this.nodeIdToEObjectCache.getIfPresent((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNode(String id) {
        Cache<String, EObject> cache = this.nodeIdToEObjectCache;
        synchronized (cache) {
            EObject eob = (EObject)this.nodeIdToEObjectCache.getIfPresent((Object)id);
            if (eob == null) {
                return;
            }
            this.nodeIdToEObjectCache.invalidate((Object)id);
            this.eObjectToNodeIdCache.invalidate((Object)eob);
            EObject container = eob.eContainer();
            Resource r = eob.eResource();
            if (r instanceof HawkFileResourceImpl) {
                ((HawkFileResourceImpl)r).removeFragment(id);
            }
            if (container == null) {
                if (r != null) {
                    r.getContents().remove((Object)eob);
                }
            } else {
                EStructuralFeature containingFeature = eob.eContainingFeature();
                if (containingFeature.isMany()) {
                    ((Collection)container.eGet(containingFeature)).remove(eob);
                } else {
                    container.eUnset(containingFeature);
                }
            }
        }
    }

    protected IGraphTransaction beginGraphTransaction() throws Exception {
        return this.indexer.getGraph().beginTransaction();
    }

    protected EObject createOrUpdateEObject(ModelElementNode me) throws Exception {
        Object attrValue;
        String attrName;
        EObject eob;
        EPackage.Registry registry = this.getResourceSet().getPackageRegistry();
        TypeNode typeNode = me.getTypeNode();
        String nsURI = typeNode.getMetamodelURI();
        EClass eClass = LocalHawkResourceImpl.getEClass(nsURI, typeNode.getTypeName(), registry);
        EObject existing = (EObject)this.nodeIdToEObjectCache.getIfPresent((Object)me.getNodeId());
        EObject eObject = eob = existing != null ? existing : this.eobFactory.createInstance(eClass);
        if (existing == null) {
            this.nodeIdToEObjectCache.put((Object)me.getNodeId(), (Object)eob);
            this.eObjectToNodeIdCache.put((Object)eob, (Object)me.getNodeId());
            eob.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    LocalHawkResourceImpl.this.markChanged(eob);
                }
            });
        }
        HashMap<String, Object> attributeValues = new HashMap<String, Object>();
        HashMap<String, Object> referenceValues = new HashMap<String, Object>();
        HashMap<String, Object> mixedValues = new HashMap<String, Object>();
        this.getSlotValues(me, attributeValues, referenceValues, mixedValues);
        EFactory factory = registry.getEFactory(nsURI);
        if (existing != null) {
            for (EAttribute attr : eClass.getEAllAttributes()) {
                if (attr.isDerived() || !attr.isChangeable() || attributeValues.containsKey(attr.getName()) || mixedValues.containsKey(attr.getName()) || !existing.eIsSet((EStructuralFeature)attr)) continue;
                existing.eUnset((EStructuralFeature)attr);
            }
        }
        for (Map.Entry entry : attributeValues.entrySet()) {
            attrName = (String)entry.getKey();
            attrValue = entry.getValue();
            AttributeUtils.setAttribute(factory, eClass, eob, attrName, attrValue);
        }
        for (Map.Entry entry : mixedValues.entrySet()) {
            attrName = (String)entry.getKey();
            attrValue = entry.getValue();
            EAttribute eAttr = (EAttribute)eClass.getEStructuralFeature(attrName);
            boolean isMixed = ExtendedMetaData.INSTANCE.getMixedFeature(eClass) == eAttr;
            FeatureMap fmap = (FeatureMap)eob.eGet((EStructuralFeature)eAttr);
            for (Object o : (Collection)attrValue) {
                EObject node = this.fetchNode(o.toString(), true);
                if (node == null) continue;
                for (Map.Entry refEntry : referenceValues.entrySet()) {
                    EReference ref = (EReference)eClass.getEStructuralFeature((String)refEntry.getKey());
                    if (!isMixed && ExtendedMetaData.INSTANCE.getGroup((EStructuralFeature)ref) != eAttr) continue;
                    if (o.equals(refEntry.getValue())) {
                        fmap.add((EStructuralFeature)ref, (Object)node);
                        continue;
                    }
                    if (!(refEntry.getValue() instanceof Collection) || !((Collection)refEntry.getValue()).contains(o)) continue;
                    fmap.add((EStructuralFeature)ref, (Object)node);
                }
            }
        }
        if (existing != null) {
            for (EReference ref : eClass.getEAllReferences()) {
                if (ref.isDerived() || !ref.isChangeable() || referenceValues.containsKey(ref.getName())) continue;
                this.lazyResolver.removeLazyReference(existing, ref);
            }
        }
        for (Map.Entry entry : referenceValues.entrySet()) {
            EReference ref = (EReference)eClass.getEStructuralFeature((String)entry.getKey());
            if (ref.isDerived() || !ref.isChangeable()) continue;
            BasicEList ids = new BasicEList();
            if (entry.getValue() instanceof Collection) {
                for (Object o : (Collection)entry.getValue()) {
                    String id = o.toString();
                    ids.add((Object)id);
                }
            } else {
                String id = entry.getValue().toString();
                ids.add((Object)id);
            }
            if (ids.isEmpty()) continue;
            this.lazyResolver.putLazyReference(eob, ref, (EList<Object>)ids);
        }
        return eob;
    }

    protected void getSlotValues(ModelElementNode me, Map<String, Object> attributeValues, Map<String, Object> referenceValues, Map<String, Object> mixedValues) {
        HashMap derivedValues = new HashMap();
        me.getSlotValues(attributeValues, referenceValues, mixedValues, derivedValues);
        for (Map.Entry derivedEntry : derivedValues.entrySet()) {
            Object value = derivedEntry.getValue();
            if (value instanceof IGraphNode) {
                referenceValues.put((String)derivedEntry.getKey(), ((IGraphNode)value).getId());
                continue;
            }
            if (value instanceof Iterable) {
                Iterable iterableValue = (Iterable)value;
                Iterator itValue = iterableValue.iterator();
                if (itValue.hasNext() && itValue.next() instanceof IGraphNode) {
                    BasicEList ids = new BasicEList();
                    for (Object element : iterableValue) {
                        ids.add(((IGraphNode)element).getId());
                    }
                    referenceValues.put((String)derivedEntry.getKey(), ids);
                    continue;
                }
                attributeValues.put((String)derivedEntry.getKey(), value);
                continue;
            }
            attributeValues.put((String)derivedEntry.getKey(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToResource(ModelElementNode modelElementNode, EObject eob) {
        FileNode fileNode = modelElementNode.getFileNode();
        String repoURL = fileNode.getRepositoryURL();
        String path = fileNode.getFilePath();
        String fullURL = String.valueOf(repoURL) + (repoURL.endsWith("/") || path.startsWith("/") ? "" : "/") + path;
        if (this.isSplit) {
            Map<String, HawkFileResourceImpl> map = this.uriToResource;
            synchronized (map) {
                HawkFileResourceImpl resource = this.uriToResource.get(fullURL);
                if (resource == null) {
                    resource = new HawkFileResourceImpl(URI.createURI((String)fullURL), this);
                    this.getResourceSet().getResources().add((Object)resource);
                    this.uriToResource.put(fullURL, resource);
                    this.uriToFileNode.put(fullURL, fileNode);
                }
                if (eob.eContainer() == null) {
                    resource.getContents().add((Object)eob);
                }
                resource.addFragment(modelElementNode.getNodeId(), modelElementNode.getElementId());
            }
        } else if (eob.eContainer() == null) {
            this.getContents().add((Object)eob);
        }
    }

    private void removeRedundantRoot(EObject child) {
        Resource r = child.eResource();
        EObject eContainer = child.eContainer();
        if (r != null && eContainer != null && r == eContainer.eResource() && r.getContents().contains((Object)child)) {
            r.getContents().remove((Object)child);
        }
    }

    @Override
    public boolean addSyncEndListener(Runnable r) {
        return this.syncEndListeners.add(r);
    }

    @Override
    public boolean removeSyncEndListener(Runnable r) {
        return this.syncEndListeners.remove(r);
    }

    public Set<Runnable> getSyncEndListeners() {
        return Collections.unmodifiableSet(this.syncEndListeners);
    }

    @Override
    public boolean addChangeListener(HawkResourceChangeListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeChangeListener(HawkResourceChangeListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getRegisteredMetamodels() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IGraphTransaction tx = this.indexer.getGraph().beginTransaction();){
            IGraphNodeIndex idx = this.indexer.getGraph().getMetamodelIndex();
            ArrayList<String> metamodels = new ArrayList<String>();
            for (IGraphNode mmNode : idx.query("*", (Object)"*")) {
                metamodels.add(new MetamodelNode(mmNode).getUri());
            }
            return metamodels;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public List<String> getRegisteredTypes(String metamodelURI) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (IGraphTransaction tx = this.indexer.getGraph().beginTransaction();){
            IGraphNodeIndex idx = this.indexer.getGraph().getMetamodelIndex();
            ArrayList<String> types = new ArrayList<String>();
            for (IGraphNode mmNode : idx.get("id", (Object)metamodelURI)) {
                MetamodelNode metamodel = new MetamodelNode(mmNode);
                for (TypeNode type : metamodel.getTypes()) {
                    types.add(type.getTypeName());
                }
            }
            return types;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public IModelIndexer getIndexer() {
        return this.indexer;
    }

    @Override
    public void markChanged(EObject eob) {
        this.dirtyObjects.put(eob, 1);
    }

    private final class LazyReferenceResolver
    implements MethodInterceptor {
        private LazyReferenceResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object o, Method m, Object[] args, MethodProxy proxy) throws Throwable {
            EObject eob = (EObject)o;
            switch (m.getName()) {
                case "eIsSet": {
                    if (!((Boolean)proxy.invokeSuper(o, args)).booleanValue() && !LocalHawkResourceImpl.this.lazyResolver.isLazy(eob, (EStructuralFeature)args[0])) {
                        return false;
                    }
                    return true;
                }
                case "eContainmentFeature": 
                case "eContainingFeature": {
                    EReference sfContainingF = LocalHawkResourceImpl.this.lazyResolver.getContainingFeature(eob);
                    return sfContainingF != null ? sfContainingF : proxy.invokeSuper(o, args);
                }
                case "eContainerFeatureID": {
                    EReference sfContaining = LocalHawkResourceImpl.this.lazyResolver.getContainingFeature(eob);
                    if (sfContaining != null) {
                        assert (sfContaining.isContainment()) : "containing feature should be containment";
                        if (sfContaining.getEOpposite() != null) {
                            return sfContaining.getEOpposite().getFeatureID();
                        }
                        return -1 - sfContaining.getFeatureID();
                    }
                    return proxy.invokeSuper(o, args);
                }
                case "eInternalContainer": 
                case "eContainer": {
                    EObject rawContainer = (EObject)proxy.invokeSuper(o, args);
                    return rawContainer != null ? rawContainer : (LocalHawkResourceImpl.this.lazyResolver != null ? LocalHawkResourceImpl.this.lazyResolver.getContainer(eob) : null);
                }
                case "eResource": {
                    Object rawResource = proxy.invokeSuper(o, args);
                    if (rawResource != null) {
                        return rawResource;
                    }
                    EObject container = LocalHawkResourceImpl.this.lazyResolver.getContainer(eob);
                    if (container != null) {
                        return container.eResource();
                    }
                    return null;
                }
                case "eGet": {
                    EStructuralFeature sf = (EStructuralFeature)args[0];
                    return this.interceptEGet(o, args, proxy, eob, sf);
                }
                case "eContents": {
                    Cache cache = LocalHawkResourceImpl.this.nodeIdToEObjectCache;
                    synchronized (cache) {
                        for (EReference ref : eob.eClass().getEAllReferences()) {
                            if (!ref.isContainment()) continue;
                            LocalHawkResourceImpl.this.lazyResolver.resolve(eob, (EStructuralFeature)ref, false, true);
                        }
                        break;
                    }
                }
                default: {
                    EReference eRef;
                    if (!m.getName().startsWith("get") || (eRef = LocalHawkResourceImpl.this.eobFactory.guessEReferenceFromGetter(eob.eClass(), m.getName())) == null) break;
                    return this.interceptEGet(o, args, proxy, eob, (EStructuralFeature)eRef);
                }
            }
            Object ret = proxy.invokeSuper(o, args);
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object interceptEGet(Object o, Object[] args, MethodProxy proxy, EObject eob, EStructuralFeature sf) throws Throwable {
            if (sf instanceof EReference && LocalHawkResourceImpl.this.lazyResolver.isLazy(eob, sf)) {
                Object value;
                EReference ref = (EReference)sf;
                Cache cache = LocalHawkResourceImpl.this.nodeIdToEObjectCache;
                synchronized (cache) {
                    value = LocalHawkResourceImpl.this.lazyResolver.resolve(eob, sf, false, true);
                }
                if (value != null) {
                    if (ref.isContainer()) {
                        LocalHawkResourceImpl.this.removeRedundantRoot(eob);
                    } else if (ref.isContainment()) {
                        if (ref.isMany()) {
                            for (EObject child : (Iterable)value) {
                                LocalHawkResourceImpl.this.removeRedundantRoot(child);
                            }
                        } else {
                            LocalHawkResourceImpl.this.removeRedundantRoot((EObject)value);
                        }
                    }
                    return value;
                }
            }
            return proxy.invokeSuper(o, args);
        }
    }
}

