/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkPackage;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.modelio.exml.metamodel.AbstractModelioObject;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioClass;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioMetaModelResource;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MClass;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MPackage;

public class ModelioPackage
extends AbstractModelioObject
implements IHawkPackage {
    protected final ModelioMetaModelResource resource;
    protected final ModelioPackage parent;
    protected final MPackage rawPackage;
    protected List<ModelioPackage> packages;
    protected Map<String, ModelioClass> classes;

    public ModelioPackage(ModelioMetaModelResource mr, MPackage pkg) {
        this.resource = mr;
        this.parent = null;
        this.rawPackage = pkg;
    }

    public ModelioPackage(ModelioMetaModelResource mr, ModelioPackage parent, MPackage pkg) {
        this.resource = mr;
        this.parent = parent;
        this.rawPackage = pkg;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String getUri() {
        return String.valueOf(this.getNsURI()) + "#" + this.getUriFragment();
    }

    public String getUriFragment() {
        return this.rawPackage.getId();
    }

    public boolean isFragmentUnique() {
        return true;
    }

    public IHawkClassifier getType() {
        return this.resource.getMetaType();
    }

    public boolean isSet(IHawkStructuralFeature hsf) {
        switch (hsf.getName()) {
            case "name": {
                return true;
            }
            case "version": {
                return true;
            }
        }
        return false;
    }

    public Object get(IHawkAttribute attr) {
        switch (attr.getName()) {
            case "name": {
                return this.rawPackage.getName();
            }
            case "version": {
                return this.rawPackage.getVersion();
            }
        }
        return null;
    }

    public Object get(IHawkReference ref, boolean b) {
        return null;
    }

    public String getName() {
        return this.rawPackage.getName();
    }

    public ModelioClass getClassifier(String name) {
        return this.getModelioClasses().get(name);
    }

    protected String getUnprefixedNsURI() {
        return this.parent == null ? this.rawPackage.getName() : String.valueOf(this.parent.getUnprefixedNsURI()) + "/" + this.rawPackage.getName();
    }

    public String getNsURI() {
        return "modelio://" + this.rawPackage.getId();
    }

    public Set<IHawkClassifier> getClasses() {
        return new HashSet<ModelioClass>(this.getModelioClasses().values());
    }

    public ModelioMetaModelResource getResource() {
        return this.resource;
    }

    @Override
    public String getExml() {
        return null;
    }

    public String getXml() {
        return this.rawPackage.getXml();
    }

    public Collection<ModelioPackage> getPackages() {
        if (this.packages == null) {
            this.packages = new ArrayList<ModelioPackage>();
            for (MPackage mpkg : this.rawPackage.getMPackages()) {
                this.packages.add(new ModelioPackage(this.resource, this, mpkg));
            }
        }
        return this.packages;
    }

    public Map<String, ModelioClass> getModelioClasses() {
        if (this.classes == null) {
            this.classes = new HashMap<String, ModelioClass>();
            for (MClass mc : this.rawPackage.getMClass()) {
                this.classes.put(mc.getName(), new ModelioClass(this, mc));
            }
        }
        return this.classes;
    }

    public String toString() {
        return "ModelioPackage [uri=" + this.getNsURI() + "]";
    }

    public MPackage getRawPackage() {
        return this.rawPackage;
    }

    public String getVersion() {
        return this.rawPackage.getVersion();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rawPackage == null ? 0 : this.rawPackage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelioPackage other = (ModelioPackage)obj;
        return !(this.rawPackage == null ? other.rawPackage != null : !this.rawPackage.equals(other.rawPackage));
    }
}

