/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb;

import com.orientechnologies.common.collection.OCollection;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.orientdb.OrientDatabase;
import org.eclipse.hawk.orientdb.OrientEdge;
import org.eclipse.hawk.orientdb.OrientLightEdge;
import org.eclipse.hawk.orientdb.util.OrientNameCleaner;

public class OrientNode
implements IGraphNode {
    private static final String PREFIX_PROPERTY = "_hp_";
    private static final String ATTR_INDEX_KEYS = "_hIndexKeys";
    private static final String PREFIX_INCOMING = "in_";
    private static final String PREFIX_OUTGOING = "out_";
    private static final String PREFIX_INCOMING_OLD = "_hi_";
    private static final String PREFIX_OUTGOING_OLD = "_ho_";
    private final OrientDatabase graph;
    private ORID id;
    private ODocument changedVertex;

    public OrientNode(ODocument doc, OrientDatabase graph) {
        this.graph = graph;
        this.changedVertex = doc;
        this.id = doc.getIdentity();
    }

    public OrientNode(ORID id, OrientDatabase graph) {
        this.id = id;
        this.graph = graph;
    }

    public ORID getId() {
        if (this.changedVertex != null) {
            return this.changedVertex.getIdentity();
        }
        return this.id;
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> keys = new HashSet<String>();
        ODocument tmpVertex = this.getDocument();
        String[] stringArray = tmpVertex.fieldNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && s.startsWith(PREFIX_PROPERTY)) {
                keys.add(OrientNameCleaner.unescapeFromField(s.substring(PREFIX_PROPERTY.length())));
            }
            ++n2;
        }
        return keys;
    }

    public Object getProperty(String name) {
        String fieldName = PREFIX_PROPERTY + name;
        try {
            Object val = this.internalGetProperty(fieldName);
            if (val != null) {
                return val;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.internalGetProperty(PREFIX_PROPERTY + OrientNameCleaner.escapeToField(name));
    }

    public Object internalGetProperty(String fieldName) {
        Object value;
        block29: {
            ODocument tmpVertex = this.getDocument();
            value = tmpVertex.field(fieldName);
            if (!(value instanceof OTrackedList)) break block29;
            OTrackedList cValue = (OTrackedList)value;
            Class genericClass = cValue.getGenericClass();
            if (genericClass == null) {
                genericClass = !cValue.isEmpty() ? cValue.get(0).getClass() : Object.class;
            }
            switch (genericClass.getSimpleName()) {
                case "Long": {
                    long[] newArray = new long[cValue.size()];
                    int i = 0;
                    for (Object o : cValue) {
                        newArray[i++] = (Long)o;
                    }
                    return newArray;
                }
                case "Integer": {
                    int[] newArray = new int[cValue.size()];
                    int i = 0;
                    for (Object o : cValue) {
                        newArray[i++] = (Integer)o;
                    }
                    return newArray;
                }
                case "Short": {
                    short[] newArray = new short[cValue.size()];
                    int i = 0;
                    for (Object o : cValue) {
                        newArray[i++] = (Short)o;
                    }
                    return newArray;
                }
                case "Byte": {
                    byte[] newArray = new byte[cValue.size()];
                    int i = 0;
                    for (Object o : cValue) {
                        newArray[i++] = (Byte)o;
                    }
                    return newArray;
                }
                case "Double": {
                    double[] newArray = new double[cValue.size()];
                    int i = 0;
                    for (Object o : cValue) {
                        newArray[i++] = (Double)o;
                    }
                    return newArray;
                }
                case "Float": {
                    float[] newArray = new float[cValue.size()];
                    int i = 0;
                    for (Object o : cValue) {
                        newArray[i++] = ((Float)o).floatValue();
                    }
                    return newArray;
                }
            }
            Object[] newArray = (Object[])Array.newInstance(genericClass, cValue.size());
            return cValue.toArray(newArray);
        }
        return value;
    }

    public static void setProperties(ODocument doc, Map<String, Object> props) {
        HashMap<String, Object> mappedProps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String fieldName = entry.getKey();
            mappedProps.put(PREFIX_PROPERTY + OrientNameCleaner.escapeToField(fieldName), entry.getValue());
        }
        doc.fromMap(mappedProps);
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.removeProperty(name);
        } else {
            this.changedVertex = this.getDocument();
            try {
                this.changedVertex.field(PREFIX_PROPERTY + name, value);
            }
            catch (IllegalArgumentException ex) {
                this.changedVertex.field(PREFIX_PROPERTY + OrientNameCleaner.escapeToField(name), value);
            }
            this.graph.markNodeAsDirty(this);
        }
    }

    public Iterable<IGraphEdge> getEdges() {
        return this.getEdges(Direction.BOTH);
    }

    private List<IGraphEdge> getEdges(Direction dir) {
        ArrayList<IGraphEdge> edges = new ArrayList<IGraphEdge>();
        ODocument tmpVertex = this.getDocument();
        String[] stringArray = tmpVertex.fieldNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propName = stringArray[n2];
            String edgeLabel = null;
            Direction propDir = null;
            if (propName.startsWith(PREFIX_INCOMING) && dir != Direction.OUT) {
                edgeLabel = OrientNameCleaner.unescapeFromField(propName.substring(PREFIX_INCOMING.length()));
                propDir = Direction.IN;
            } else if (propName.startsWith(PREFIX_OUTGOING) && dir != Direction.IN) {
                edgeLabel = OrientNameCleaner.unescapeFromField(propName.substring(PREFIX_OUTGOING.length()));
                propDir = Direction.OUT;
            } else if (propName.startsWith(PREFIX_INCOMING_OLD) && dir != Direction.OUT) {
                edgeLabel = OrientNameCleaner.unescapeFromField(propName.substring(PREFIX_INCOMING_OLD.length()));
                propDir = Direction.IN;
            } else if (propName.startsWith(PREFIX_OUTGOING_OLD) && dir != Direction.IN) {
                edgeLabel = OrientNameCleaner.unescapeFromField(propName.substring(PREFIX_OUTGOING_OLD.length()));
                propDir = Direction.OUT;
            }
            if (edgeLabel != null) {
                Iterable odocs = (Iterable)tmpVertex.field(propName);
                this.addAllOIdentifiable(edges, odocs, propDir, edgeLabel);
            }
            ++n2;
        }
        return edges;
    }

    private void addAllOIdentifiable(List<IGraphEdge> edges, Iterable<Object> odocs, Direction dir, String edgeLabel) {
        if (odocs != null) {
            for (Object odoc : odocs) {
                if (!(odoc instanceof OIdentifiable)) continue;
                edges.add(this.convertToEdge((OIdentifiable)odoc, dir, edgeLabel));
            }
        }
    }

    private IGraphEdge convertToEdge(OIdentifiable odoc, Direction dir, String edgeLabel) {
        OrientNode n = this.graph.getNodeById(odoc);
        ODocument doc = n.getDocument();
        if (doc.getSchemaClass().getName().startsWith("V_")) {
            if (dir == Direction.OUT) {
                return new OrientLightEdge(this, n, edgeLabel);
            }
            return new OrientLightEdge(n, this, edgeLabel);
        }
        return new OrientEdge(doc, this.graph);
    }

    public Iterable<IGraphEdge> getEdgesWithType(String type) {
        return this.getEdges(type, Direction.BOTH);
    }

    private List<IGraphEdge> getEdges(String type, Direction direction) {
        try {
            List<IGraphEdge> l = this.internalGetEdges(type, direction);
            if (l != null && !l.isEmpty()) {
                return l;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.internalGetEdges(OrientNameCleaner.escapeToField(type), direction);
    }

    public List<IGraphEdge> internalGetEdges(String type, Direction direction) {
        String fldNameOld;
        String fldName;
        ArrayList<IGraphEdge> edges = new ArrayList<IGraphEdge>();
        ODocument tmpVertex = this.getDocument();
        if (direction == Direction.IN || direction == Direction.BOTH) {
            fldName = PREFIX_INCOMING + type;
            Iterable inODocs = (Iterable)tmpVertex.field(fldName);
            this.addAllOIdentifiable(edges, inODocs, Direction.IN, type);
            fldNameOld = PREFIX_INCOMING_OLD + type;
            Iterable inODocsOld = (Iterable)tmpVertex.field(fldNameOld);
            this.addAllOIdentifiable(edges, inODocsOld, Direction.IN, type);
        }
        if (direction == Direction.OUT || direction == Direction.BOTH) {
            fldName = PREFIX_OUTGOING + type;
            Iterable outODocs = (Iterable)tmpVertex.field(fldName);
            this.addAllOIdentifiable(edges, outODocs, Direction.OUT, type);
            fldNameOld = PREFIX_OUTGOING_OLD + type;
            Iterable outODocsOld = (Iterable)tmpVertex.field(fldNameOld);
            this.addAllOIdentifiable(edges, outODocsOld, Direction.OUT, type);
        }
        return edges;
    }

    public Iterable<IGraphEdge> getOutgoingWithType(String type) {
        return this.getEdges(type, Direction.OUT);
    }

    public Iterable<IGraphEdge> getIncomingWithType(String type) {
        return this.getEdges(type, Direction.IN);
    }

    public Iterable<IGraphEdge> getIncoming() {
        return this.getEdges(Direction.IN);
    }

    public Iterable<IGraphEdge> getOutgoing() {
        return this.getEdges(Direction.OUT);
    }

    public void delete() {
        for (IGraphEdge e : this.getEdges()) {
            e.delete();
        }
        for (String idxName : this.getIndexKeys().keySet()) {
            this.graph.getOrCreateNodeIndex(idxName).remove((IGraphNode)this);
        }
        this.graph.getGraph().delete(this.getId());
        this.changedVertex = null;
        this.graph.unmarkNodeAsDirty(this);
    }

    public IGraphDatabase getGraph() {
        return this.graph;
    }

    public void removeProperty(String name) {
        this.changedVertex = this.getDocument();
        Object oldValue = this.changedVertex.removeField(PREFIX_PROPERTY + OrientNameCleaner.escapeToField(name));
        if (oldValue == null) {
            this.changedVertex.removeField(PREFIX_PROPERTY + name);
        }
        this.graph.markNodeAsDirty(this);
    }

    public int hashCode() {
        int prime = 5381;
        int result = 1;
        result = 5381 * result + (this.getId() == null ? 0 : this.getId().toString().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrientNode other = (OrientNode)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals((Object)other.getId()));
    }

    public String toString() {
        return "OrientNode [" + this.getId() + "]";
    }

    public ODocument getDocument() {
        if (this.changedVertex != null) {
            return this.changedVertex;
        }
        ODocument vertex = this.graph.getNodeById((Object)this.getId()).changedVertex;
        if (vertex != null) {
            return vertex;
        }
        ODocument doc = (ODocument)this.graph.getGraph().load(this.getId());
        doc.setTrackingChanges(false);
        return doc;
    }

    public void addOutgoing(ODocument newEdge, String edgeLabel) {
        this.addToList(newEdge, PREFIX_OUTGOING + OrientNameCleaner.escapeToField(edgeLabel));
        this.graph.markNodeAsDirty(this);
    }

    private void addToList(ODocument edgeDoc, String fldName) {
        OClass oClass;
        this.changedVertex = this.getDocument();
        Object out = this.changedVertex.field(fldName);
        if (out == null && !this.graph.getGraph().getTransaction().isActive() && !(oClass = this.changedVertex.getSchemaClass()).existsProperty(fldName)) {
            oClass.createProperty(fldName, OType.LINKBAG, null, true);
        }
        if (out == null) {
            out = new ORidBag();
            this.changedVertex.field(fldName, out);
        }
        this.changedVertex.setTrackingChanges(false);
        if (out instanceof Collection) {
            Collection col = (Collection)out;
            col.add(edgeDoc);
        } else if (out instanceof OCollection) {
            OCollection bag = (OCollection)out;
            bag.add((Object)edgeDoc);
        } else {
            System.out.println("BUG");
        }
        this.changedVertex.field(fldName, out);
        this.changedVertex.setTrackingChanges(true);
    }

    public void addIncoming(ODocument newEdge, String edgeLabel) {
        this.addToList(newEdge, OrientNameCleaner.escapeToField(PREFIX_INCOMING + edgeLabel));
    }

    public void removeOutgoing(ODocument orientEdge, String edgeLabel) {
        try {
            this.removeFromList(orientEdge, PREFIX_OUTGOING + edgeLabel);
            this.removeFromList(orientEdge, PREFIX_OUTGOING_OLD + edgeLabel);
        }
        catch (IllegalArgumentException ex) {
            String escapedEdgeLabel = OrientNameCleaner.escapeToField(edgeLabel);
            this.removeFromList(orientEdge, PREFIX_OUTGOING + escapedEdgeLabel);
            this.removeFromList(orientEdge, PREFIX_OUTGOING_OLD + escapedEdgeLabel);
        }
        this.graph.markNodeAsDirty(this);
    }

    private void removeFromList(ODocument orientEdge, String fldName) {
        this.changedVertex = this.getDocument();
        if (this.changedVertex != null) {
            Object out = this.changedVertex.field(fldName);
            this.changedVertex.setTrackingChanges(false);
            if (out instanceof Collection) {
                ((Collection)out).remove(orientEdge);
            } else if (out instanceof OCollection) {
                ((OCollection)out).remove((Object)orientEdge);
            }
            this.changedVertex.field(fldName, out);
            this.changedVertex.setTrackingChanges(true);
        }
    }

    public void removeIncoming(ODocument orientEdge, String edgeLabel) {
        try {
            this.removeFromList(orientEdge, PREFIX_INCOMING + edgeLabel);
            this.removeFromList(orientEdge, PREFIX_INCOMING_OLD + edgeLabel);
        }
        catch (IllegalArgumentException ex) {
            String escapedEdgeLabel = OrientNameCleaner.escapeToField(edgeLabel);
            this.removeFromList(orientEdge, PREFIX_INCOMING + escapedEdgeLabel);
            this.removeFromList(orientEdge, PREFIX_INCOMING_OLD + escapedEdgeLabel);
        }
        this.graph.markNodeAsDirty(this);
    }

    public void save() {
        if (this.changedVertex != null && this.changedVertex.isDirty()) {
            this.changedVertex.save();
            this.id = this.changedVertex.getIdentity();
            this.changedVertex = null;
            this.changedVertex = this.getDocument();
        }
        if (this.getId().isPersistent()) {
            this.changedVertex = null;
        }
    }

    public void addIndexKey(String idxName, String field, Object key) {
        ArrayList<Object> keys;
        HashMap<String, ArrayList<Object>> keysByField;
        this.changedVertex = this.getDocument();
        HashMap fieldsByIndex = (HashMap)this.changedVertex.field(ATTR_INDEX_KEYS);
        if (fieldsByIndex == null) {
            fieldsByIndex = new HashMap();
        }
        if ((keysByField = (HashMap<String, ArrayList<Object>>)fieldsByIndex.get(idxName)) == null) {
            keysByField = new HashMap<String, ArrayList<Object>>();
            fieldsByIndex.put(idxName, keysByField);
        }
        if ((keys = (ArrayList<Object>)keysByField.get(field)) == null) {
            keys = new ArrayList<Object>();
            keysByField.put(field, keys);
        }
        keys.add(key);
        this.changedVertex.field(ATTR_INDEX_KEYS, fieldsByIndex);
        this.graph.markNodeAsDirty(this);
    }

    public void removeIndexKey(String idxName, String field, Object key) {
        List keys;
        Map keysByField;
        this.changedVertex = this.getDocument();
        Map fieldsByIndex = (Map)this.changedVertex.field(ATTR_INDEX_KEYS);
        if (fieldsByIndex != null && (keysByField = (Map)fieldsByIndex.get(idxName)) != null && (keys = (List)keysByField.get(field)) != null && keys.remove(key)) {
            this.changedVertex.field(ATTR_INDEX_KEYS, (Object)fieldsByIndex);
            this.graph.markNodeAsDirty(this);
        }
    }

    public Collection<Object> removeIndexField(String idxName, String field) {
        List keys;
        Map keysByField;
        this.changedVertex = this.getDocument();
        Map fieldsByIndex = (Map)this.changedVertex.field(ATTR_INDEX_KEYS);
        if (fieldsByIndex != null && (keysByField = (Map)fieldsByIndex.get(idxName)) != null && (keys = (List)keysByField.remove(field)) != null) {
            this.changedVertex.field(ATTR_INDEX_KEYS, (Object)fieldsByIndex);
            this.graph.markNodeAsDirty(this);
            return keys;
        }
        return Collections.emptyList();
    }

    public List<Map.Entry<String, Map<String, List<Object>>>> removeIndexFields(String commonPrefix) {
        this.changedVertex = this.getDocument();
        boolean changed = false;
        ArrayList<Map.Entry<String, Map<String, List<Object>>>> removedEntries = new ArrayList<Map.Entry<String, Map<String, List<Object>>>>();
        Map fieldsByIndex = (Map)this.changedVertex.field(ATTR_INDEX_KEYS);
        if (fieldsByIndex != null) {
            Iterator itEntry = fieldsByIndex.entrySet().iterator();
            while (itEntry.hasNext()) {
                Map.Entry entry = itEntry.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(commonPrefix)) continue;
                itEntry.remove();
                removedEntries.add(entry);
                changed = true;
            }
        }
        if (changed) {
            this.changedVertex.field(ATTR_INDEX_KEYS, (Object)fieldsByIndex);
            this.graph.markNodeAsDirty(this);
        }
        return removedEntries;
    }

    public Map<String, Map<String, Object>> getIndexKeys() {
        this.changedVertex = this.getDocument();
        Map<String, Map<String, Object>> field = (Map<String, Map<String, Object>>)this.changedVertex.field(ATTR_INDEX_KEYS);
        if (field == null) {
            field = Collections.emptyMap();
        }
        return field;
    }

    protected static void setupDocumentClass(OClass oClass) {
        oClass.setOverSize(2.0f);
        switch (oClass.getName()) {
            case "V_eclass": {
                oClass.setOverSize(4.0f);
                oClass.createProperty("in__hawkOfType", OType.LINKBAG);
                oClass.createProperty("in__hawkOfKind", OType.LINKBAG);
                break;
            }
            case "V_eobject": {
                oClass.createProperty("out__hawkFile", OType.LINKBAG);
                oClass.createProperty("out__hawkOfType", OType.LINKLIST);
                oClass.createProperty("out__hawkOfKind", OType.LINKLIST);
                break;
            }
            case "V_file": {
                oClass.createProperty("in__hawkFile", OType.LINKBAG);
            }
        }
        System.out.println("set up properties for " + oClass.getName() + ": " + oClass.declaredProperties());
    }

    private static enum Direction {
        IN,
        OUT,
        BOTH;

    }
}

