/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.kafka.client.common.KafkaClientOptionsConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@DataObject(generateConverter=true)
public class KafkaClientOptions {
    public static final String DEFAULT_TRACE_PEER_ADDRESS = null;
    public static final TracingPolicy DEFAULT_TRACING_POLICY = TracingPolicy.PROPAGATE;
    private Map<String, Object> config;
    private String tracePeerAddress = DEFAULT_TRACE_PEER_ADDRESS;
    private TracingPolicy tracingPolicy = DEFAULT_TRACING_POLICY;

    public KafkaClientOptions() {
    }

    public KafkaClientOptions(JsonObject json) {
        this();
        KafkaClientOptionsConverter.fromJson(json, this);
    }

    public static KafkaClientOptions fromMap(Map<String, Object> config, boolean isProducer) {
        String tracePeerAddress = (String)config.getOrDefault(isProducer ? "bootstrap.servers" : "bootstrap.servers", "");
        return new KafkaClientOptions().setTracePeerAddress(tracePeerAddress);
    }

    public static KafkaClientOptions fromProperties(Properties config, boolean isProducer) {
        String tracePeerAddress = (String)config.getOrDefault((Object)(isProducer ? "bootstrap.servers" : "bootstrap.servers"), "");
        return new KafkaClientOptions().setTracePeerAddress(tracePeerAddress);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public KafkaClientOptions setConfig(Map<String, Object> config) {
        this.config = config;
        return this;
    }

    @GenIgnore
    public KafkaClientOptions setConfig(String key, Object value) {
        if (this.config == null) {
            this.config = new HashMap<String, Object>();
        }
        this.config.put(key, value);
        return this;
    }

    public TracingPolicy getTracingPolicy() {
        return this.tracingPolicy;
    }

    public KafkaClientOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        this.tracingPolicy = tracingPolicy;
        return this;
    }

    public String getTracePeerAddress() {
        return this.tracePeerAddress;
    }

    public KafkaClientOptions setTracePeerAddress(String tracePeerAddress) {
        this.tracePeerAddress = tracePeerAddress;
        return this;
    }

    public JsonObject toJson() {
        return new JsonObject();
    }
}

