/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.util.CommandConstants;
import org.eclipse.hono.util.ConnectionDuration;
import org.eclipse.hono.util.DataVolume;
import org.eclipse.hono.util.EventConstants;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.TelemetryConstants;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ResourceLimits {
    private static final String ERROR_MAX_TTL_LESS_THAN_UNLIMITED = "Maximum time-to-live property must be set to value >= -1";
    @JsonProperty(value="max-connections")
    private int maxConnections = -1;
    @JsonProperty(value="max-ttl")
    private long maxTtl = -1L;
    @JsonProperty(value="max-ttl-telemetry-qos0")
    private long maxTtlTelemetryQos0 = -1L;
    @JsonProperty(value="max-ttl-telemetry-qos1")
    private long maxTtlTelemetryQoS1 = -1L;
    @JsonProperty(value="max-ttl-command-response")
    private long maxTtlCommandResponse = -1L;
    @JsonProperty(value="data-volume")
    private DataVolume dataVolume;
    @JsonProperty(value="connection-duration")
    private ConnectionDuration connectionDuration;
    @JsonProperty(value="ext")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> extensions;

    public final ResourceLimits setMaxConnections(int maxConnections) {
        if (maxConnections < -1) {
            throw new IllegalArgumentException("Maximum connections property must be set to value >= -1");
        }
        this.maxConnections = maxConnections;
        return this;
    }

    public final int getMaxConnections() {
        return this.maxConnections;
    }

    public final long getMaxTtl(String endpointName, QoS qos) {
        if (EventConstants.isEventEndpoint(endpointName)) {
            return this.getMaxTtl();
        }
        if (TelemetryConstants.isTelemetryEndpoint(endpointName)) {
            if (qos == null) {
                throw new NullPointerException("QoS must not be null for telemetry endpoint");
            }
            switch (qos) {
                case AT_MOST_ONCE: {
                    return this.getMaxTtlTelemetryQoS0();
                }
            }
            return this.getMaxTtlTelemetryQoS1();
        }
        if (CommandConstants.isNorthboundCommandResponseEndpoint(endpointName)) {
            return this.getMaxTtlCommandResponse();
        }
        throw new IllegalArgumentException("unknown endpoint name");
    }

    public final ResourceLimits setMaxTtl(long maxTtl) {
        if (maxTtl < -1L) {
            throw new IllegalArgumentException(ERROR_MAX_TTL_LESS_THAN_UNLIMITED);
        }
        this.maxTtl = maxTtl;
        return this;
    }

    public final long getMaxTtl() {
        return this.maxTtl;
    }

    public final ResourceLimits setMaxTtlTelemetryQoS0(long maxTtl) {
        if (maxTtl < -1L) {
            throw new IllegalArgumentException(ERROR_MAX_TTL_LESS_THAN_UNLIMITED);
        }
        this.maxTtlTelemetryQos0 = maxTtl;
        return this;
    }

    public final long getMaxTtlTelemetryQoS0() {
        return this.maxTtlTelemetryQos0;
    }

    public final ResourceLimits setMaxTtlTelemetryQoS1(long maxTtl) {
        if (maxTtl < -1L) {
            throw new IllegalArgumentException(ERROR_MAX_TTL_LESS_THAN_UNLIMITED);
        }
        this.maxTtlTelemetryQoS1 = maxTtl;
        return this;
    }

    public final long getMaxTtlTelemetryQoS1() {
        return this.maxTtlTelemetryQoS1;
    }

    public final ResourceLimits setMaxTtlCommandResponse(long maxTtl) {
        if (maxTtl < -1L) {
            throw new IllegalArgumentException(ERROR_MAX_TTL_LESS_THAN_UNLIMITED);
        }
        this.maxTtlCommandResponse = maxTtl;
        return this;
    }

    public final long getMaxTtlCommandResponse() {
        return this.maxTtlCommandResponse;
    }

    public final DataVolume getDataVolume() {
        return this.dataVolume;
    }

    public final ResourceLimits setDataVolume(DataVolume dataVolume) {
        this.dataVolume = dataVolume;
        return this;
    }

    public final ConnectionDuration getConnectionDuration() {
        return this.connectionDuration;
    }

    public final ResourceLimits setConnectionDuration(ConnectionDuration connectionDuration) {
        this.connectionDuration = connectionDuration;
        return this;
    }

    public final ResourceLimits setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public final Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public final ResourceLimits putExtension(String key, Object value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, value);
        return this;
    }
}

