/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.impl.ArcContainerImpl;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.CurrentInjectionPointProvider;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.impl.LazyInstanceHandle;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.InjectionPoint;

public final class Instances {
    static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    static final Comparator<InjectableBean<?>> PRIORITY_COMPARATOR = new Comparator<InjectableBean<?>>(){

        @Override
        public int compare(InjectableBean<?> ib1, InjectableBean<?> ib2) {
            return Integer.compare(ib2.getPriority(), ib1.getPriority());
        }
    };

    private Instances() {
    }

    public static List<InjectableBean<?>> resolveBeans(Type requiredType, Set<Annotation> requiredQualifiers) {
        return Instances.resolveBeans(requiredType, requiredQualifiers.toArray(EMPTY_ANNOTATION_ARRAY));
    }

    public static List<InjectableBean<?>> resolveBeans(Type requiredType, Annotation ... requiredQualifiers) {
        Set<InjectableBean<?>> resolvedBeans = ArcContainerImpl.instance().getResolvedBeans(requiredType, requiredQualifiers);
        ArrayList nonSuppressed = new ArrayList(resolvedBeans.size());
        for (InjectableBean<?> injectableBean : resolvedBeans) {
            if (injectableBean.isSuppressed()) continue;
            nonSuppressed.add(injectableBean);
        }
        nonSuppressed.sort(PRIORITY_COMPARATOR);
        return List.copyOf(nonSuppressed);
    }

    private static List<InjectableBean<?>> resolveAllBeans(Type requiredType, Set<Annotation> requiredQualifiers) {
        if (requiredQualifiers == null || requiredQualifiers.isEmpty()) {
            return Instances.resolveBeans(requiredType, Any.Literal.INSTANCE);
        }
        return Instances.resolveBeans(requiredType, requiredQualifiers.toArray(EMPTY_ANNOTATION_ARRAY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> listOf(InjectableBean<?> targetBean, Type injectionPointType, Type requiredType, Set<Annotation> requiredQualifiers, CreationalContextImpl<?> creationalContext, Set<Annotation> annotations, Member javaMember, int position) {
        List<InjectableBean<?>> beans = Instances.resolveAllBeans(requiredType, requiredQualifiers);
        if (beans.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(beans.size());
        InjectionPoint prev = InjectionPointProvider.set(new CurrentInjectionPointProvider.InjectionPointImpl(injectionPointType, requiredType, requiredQualifiers, targetBean, annotations, javaMember, position));
        try {
            for (InjectableBean<?> bean : beans) {
                list.add(Instances.getBeanInstance(creationalContext, bean));
            }
        }
        finally {
            InjectionPointProvider.set(prev);
        }
        return List.copyOf(list);
    }

    public static <T> List<InstanceHandle<T>> listOfHandles(final InjectableBean<?> targetBean, final Type injectionPointType, final Type requiredType, final Set<Annotation> requiredQualifiers, CreationalContextImpl<?> creationalContext, final Set<Annotation> annotations, final Member javaMember, final int position) {
        Supplier<InjectionPoint> supplier = new Supplier<InjectionPoint>(){

            @Override
            public InjectionPoint get() {
                return new CurrentInjectionPointProvider.InjectionPointImpl(injectionPointType, requiredType, requiredQualifiers, targetBean, annotations, javaMember, position);
            }
        };
        return Instances.listOfHandles(supplier, requiredType, requiredQualifiers, creationalContext);
    }

    public static <T> List<InstanceHandle<T>> listOfHandles(Supplier<InjectionPoint> injectionPoint, Type requiredType, Set<Annotation> requiredQualifiers, CreationalContextImpl<?> creationalContext) {
        List<InjectableBean<?>> beans = Instances.resolveAllBeans(requiredType, requiredQualifiers);
        if (beans.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(beans.size());
        for (InjectableBean<?> bean : beans) {
            list.add(Instances.getHandle(creationalContext, bean, injectionPoint));
        }
        return List.copyOf(list);
    }

    private static <T> T getBeanInstance(CreationalContextImpl<T> parent, InjectableBean<T> bean) {
        CreationalContextImpl<T> ctx = parent.child(bean);
        T instance = bean.get(ctx);
        if (Dependent.class.equals(bean.getScope())) {
            CreationalContextImpl.addDependencyToParent(bean, instance, ctx);
        }
        return instance;
    }

    private static <T> InstanceHandle<T> getHandle(CreationalContextImpl<T> parent, final InjectableBean<T> bean, final Supplier<InjectionPoint> injectionPointSupplier) {
        final CreationalContextImpl<T> ctx = parent.child(bean);
        return new LazyInstanceHandle<T>(bean, ctx, parent, new Supplier<T>(){

            @Override
            public T get() {
                InjectionPoint prev = InjectionPointProvider.set((InjectionPoint)injectionPointSupplier.get());
                try {
                    Object t = bean.get(ctx);
                    return t;
                }
                finally {
                    InjectionPointProvider.set(prev);
                }
            }
        }, null);
    }
}

