/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluentImpl;

public class ResourceMetricSourceBuilder
extends ResourceMetricSourceFluentImpl<ResourceMetricSourceBuilder>
implements VisitableBuilder<ResourceMetricSource, ResourceMetricSourceBuilder> {
    ResourceMetricSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceMetricSourceBuilder() {
        this(false);
    }

    public ResourceMetricSourceBuilder(Boolean validationEnabled) {
        this(new ResourceMetricSource(), validationEnabled);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceMetricSource(), validationEnabled);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, ResourceMetricSource instance) {
        this(fluent, instance, false);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, ResourceMetricSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withName(instance.getName());
            fluent.withTargetAverageUtilization(instance.getTargetAverageUtilization());
            fluent.withTargetAverageValue(instance.getTargetAverageValue());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ResourceMetricSourceBuilder(ResourceMetricSource instance) {
        this(instance, (Boolean)false);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSource instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withName(instance.getName());
            this.withTargetAverageUtilization(instance.getTargetAverageUtilization());
            this.withTargetAverageValue(instance.getTargetAverageValue());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceMetricSource build() {
        ResourceMetricSource buildable = new ResourceMetricSource(this.fluent.getName(), this.fluent.getTargetAverageUtilization(), this.fluent.getTargetAverageValue());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

