/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class ProtonWritableBufferImpl
implements WritableBuffer {
    public static final int INITIAL_CAPACITY = 1024;
    public ByteBuf nettyBuffer;

    public ProtonWritableBufferImpl() {
        this(1024);
    }

    public ProtonWritableBufferImpl(int initialCapacity) {
        this.nettyBuffer = Unpooled.buffer(initialCapacity);
    }

    public ProtonWritableBufferImpl(ByteBuf buffer) {
        this.nettyBuffer = buffer;
    }

    public ByteBuf getBuffer() {
        return this.nettyBuffer;
    }

    @Override
    public void put(byte b) {
        this.nettyBuffer.writeByte(b);
    }

    @Override
    public void putFloat(float f) {
        this.nettyBuffer.writeFloat(f);
    }

    @Override
    public void putDouble(double d) {
        this.nettyBuffer.writeDouble(d);
    }

    @Override
    public void put(byte[] src, int offset, int length) {
        this.nettyBuffer.writeBytes(src, offset, length);
    }

    @Override
    public void put(ByteBuffer payload) {
        this.nettyBuffer.writeBytes(payload);
    }

    public void put(ByteBuf payload) {
        this.nettyBuffer.writeBytes(payload);
    }

    @Override
    public void putShort(short s) {
        this.nettyBuffer.writeShort(s);
    }

    @Override
    public void putInt(int i) {
        this.nettyBuffer.writeInt(i);
    }

    @Override
    public void putLong(long l) {
        this.nettyBuffer.writeLong(l);
    }

    @Override
    public boolean hasRemaining() {
        return this.nettyBuffer.writerIndex() < this.nettyBuffer.maxCapacity();
    }

    @Override
    public int remaining() {
        return this.nettyBuffer.maxCapacity() - this.nettyBuffer.writerIndex();
    }

    @Override
    public void ensureRemaining(int remaining) {
        this.nettyBuffer.ensureWritable(remaining);
    }

    @Override
    public int position() {
        return this.nettyBuffer.writerIndex();
    }

    @Override
    public void position(int position) {
        this.nettyBuffer.writerIndex(position);
    }

    @Override
    public int limit() {
        return this.nettyBuffer.capacity();
    }

    @Override
    public void put(ReadableBuffer buffer) {
        buffer.get(this);
    }

    @Override
    public void put(String value) {
        this.nettyBuffer.writeCharSequence(value, StandardCharsets.UTF_8);
    }
}

