/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.proton.ProtonTransportOptionsConverter;

@DataObject
@JsonGen(publicConverter=false)
public class ProtonTransportOptions {
    private int heartbeat;
    private int maxFrameSize;

    public ProtonTransportOptions() {
    }

    public ProtonTransportOptions(JsonObject json) {
        ProtonTransportOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ProtonTransportOptionsConverter.toJson(this, json);
        return json;
    }

    public ProtonTransportOptions setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
        return this;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public ProtonTransportOptions setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize < 0 ? -1 : maxFrameSize;
        return this;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.heartbeat;
        result = 31 * result + this.maxFrameSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProtonTransportOptions other = (ProtonTransportOptions)obj;
        if (this.heartbeat != other.heartbeat) {
            return false;
        }
        return this.maxFrameSize == other.maxFrameSize;
    }
}

