/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.NotMutable;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FormattableColumn
implements Serializable {
    private static final long serialVersionUID = -67186391702592665L;
    private final HorizontalAlignment alignment;
    private final int width;
    private final String[] labelLines;

    public FormattableColumn(int width, HorizontalAlignment alignment, String ... labelLines) {
        Validator.ensureTrue(width >= 1);
        Validator.ensureNotNull((Object)alignment, labelLines);
        this.width = width;
        this.alignment = alignment;
        this.labelLines = labelLines;
    }

    public int getWidth() {
        return this.width;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public String[] getLabelLines() {
        return this.labelLines;
    }

    public String getSingleLabelLine() {
        switch (this.labelLines.length) {
            case 0: {
                return "";
            }
            case 1: {
                return this.labelLines[0];
            }
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.labelLines[0]);
        for (int i = 1; i < this.labelLines.length; ++i) {
            buffer.append(' ');
            buffer.append(this.labelLines[i]);
        }
        return buffer.toString();
    }

    public void format(StringBuilder buffer, String text, OutputFormat format) {
        switch (format) {
            case TAB_DELIMITED_TEXT: {
                buffer.append(text);
                break;
            }
            case CSV: {
                boolean quotesNeeded = false;
                int length = text.length();
                int startPos = buffer.length();
                for (int i = 0; i < length; ++i) {
                    char c = text.charAt(i);
                    if (c == ',') {
                        buffer.append(',');
                        quotesNeeded = true;
                        continue;
                    }
                    if (c == '\"') {
                        buffer.append("\"\"");
                        quotesNeeded = true;
                        continue;
                    }
                    if (c < ' ' || c > '~') continue;
                    buffer.append(c);
                }
                if (!quotesNeeded) break;
                buffer.insert(startPos, '\"');
                buffer.append('\"');
                break;
            }
            case COLUMNS: {
                this.alignment.format(buffer, text, this.width);
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("FormattableColumn(width=");
        buffer.append(this.width);
        buffer.append(", alignment=");
        buffer.append((Object)this.alignment);
        buffer.append(", label=\"");
        buffer.append(this.getSingleLabelLine());
        buffer.append("\")");
    }
}

