/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.SSLParameters;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.MultiMapResult;
import jdk.incubator.http.ResponseProcessors;
import jdk.incubator.http.internal.common.Utils;

public abstract class HttpResponse<T> {
    protected HttpResponse() {
    }

    public abstract int statusCode();

    public abstract HttpRequest request();

    public abstract HttpRequest finalRequest();

    public abstract HttpHeaders headers();

    public abstract CompletableFuture<HttpHeaders> trailers();

    public abstract T body();

    public abstract SSLParameters sslParameters();

    public abstract URI uri();

    public abstract HttpClient.Version version();

    public static interface MultiProcessor<U, T> {
        public Optional<BodyHandler<T>> onRequest(HttpRequest var1);

        public void onResponse(HttpResponse<T> var1);

        public void onError(HttpRequest var1, Throwable var2);

        public CompletableFuture<U> completion(CompletableFuture<Void> var1, CompletableFuture<Void> var2);

        public static <V> MultiProcessor<MultiMapResult<V>, V> asMap(Function<HttpRequest, Optional<BodyHandler<V>>> function, boolean bl) {
            return new ResponseProcessors.MultiProcessorImpl<V>(function, bl);
        }

        public static <V> MultiProcessor<MultiMapResult<V>, V> asMap(Function<HttpRequest, Optional<BodyHandler<V>>> function) {
            return MultiProcessor.asMap(function, true);
        }
    }

    public static interface BodyProcessor<T>
    extends Flow.Subscriber<ByteBuffer> {
        public CompletionStage<T> getBody();

        public static BodyProcessor<String> asString(Charset charset) {
            return new ResponseProcessors.ByteArrayProcessor<String>(byArray -> new String((byte[])byArray, charset));
        }

        public static BodyProcessor<byte[]> asByteArray() {
            return new ResponseProcessors.ByteArrayProcessor<byte[]>(Function.identity());
        }

        public static BodyProcessor<Path> asFile(Path path, OpenOption ... openOptionArray) {
            return new ResponseProcessors.PathProcessor(path, openOptionArray);
        }

        public static BodyProcessor<Void> asByteArrayConsumer(Consumer<Optional<byte[]>> consumer) {
            return new ResponseProcessors.ConsumerProcessor(consumer);
        }

        public static BodyProcessor<Path> asFile(Path path) {
            return new ResponseProcessors.PathProcessor(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }

        public static <U> BodyProcessor<U> discard(U u) {
            return new ResponseProcessors.NullProcessor<U>(Optional.ofNullable(u));
        }
    }

    @FunctionalInterface
    public static interface BodyHandler<T> {
        public BodyProcessor<T> apply(int var1, HttpHeaders var2);

        public static <U> BodyHandler<U> discard(U u) {
            return (n, httpHeaders) -> BodyProcessor.discard(u);
        }

        public static BodyHandler<String> asString(Charset charset) {
            return (n, httpHeaders) -> {
                if (charset != null) {
                    return BodyProcessor.asString(charset);
                }
                return BodyProcessor.asString(Utils.charsetFrom(httpHeaders));
            };
        }

        public static BodyHandler<Path> asFile(Path path) {
            return (n, httpHeaders) -> BodyProcessor.asFile(path);
        }

        public static BodyHandler<Path> asFileDownload(Path path, OpenOption ... openOptionArray) {
            return (n, httpHeaders) -> {
                String string = httpHeaders.firstValue("Content-Disposition").orElseThrow(() -> Utils.unchecked(new IOException("No Content-Disposition")));
                if (!string.startsWith("attachment;")) {
                    throw Utils.unchecked(new IOException("Unknown Content-Disposition type"));
                }
                int n2 = string.indexOf("filename=");
                if (n2 == -1) {
                    throw Utils.unchecked(new IOException("Bad Content-Disposition type"));
                }
                int n3 = string.lastIndexOf(59);
                String string2 = n3 < n2 ? string.substring(n2 + 9) : string.substring(n2 + 9, n3);
                Path path2 = Paths.get(path.toString(), string2);
                return BodyProcessor.asFile(path2, openOptionArray);
            };
        }

        public static BodyHandler<Path> asFile(Path path, OpenOption ... openOptionArray) {
            return (n, httpHeaders) -> BodyProcessor.asFile(path, openOptionArray);
        }

        public static BodyHandler<Void> asByteArrayConsumer(Consumer<Optional<byte[]>> consumer) {
            return (n, httpHeaders) -> BodyProcessor.asByteArrayConsumer(consumer);
        }

        public static BodyHandler<byte[]> asByteArray() {
            return (n, httpHeaders) -> BodyProcessor.asByteArray();
        }

        public static BodyHandler<String> asString() {
            return (n, httpHeaders) -> BodyProcessor.asString(Utils.charsetFrom(httpHeaders));
        }
    }
}

