/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.util.Map;
import java.util.TreeMap;
import org.codelibs.nekohtml.parsers.SAXParser;
import org.codelibs.xerces.xerces.xni.Augmentations;
import org.codelibs.xerces.xerces.xni.QName;
import org.codelibs.xerces.xerces.xni.XMLAttributes;
import org.codelibs.xerces.xerces.xni.XMLString;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.DevHelpSAXParser;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.FuncFoundSaxException;

class HTMLSAXParserOld
extends SAXParser
implements DevHelpSAXParser {
    private boolean begin;
    private boolean refsect2;
    private boolean returnType;
    private boolean protoStart;
    private boolean parmStart;
    private boolean descStart;
    private boolean rowIgnore;
    private boolean valid = true;
    private Map<String, String> funcs;
    private String returnValue;
    private String funcName;
    private String rowTag;
    private StringBuilder prototype = new StringBuilder();
    private StringBuilder description = new StringBuilder();
    private int divCounter;
    private int rowItemCount;
    private TreeMap<String, FunctionInfo> infos = new TreeMap();

    public HTMLSAXParserOld(Map<String, String> funcs) {
        this.funcs = funcs;
    }

    public void startElement(QName name, XMLAttributes a, Augmentations aug) {
        String fname;
        String mapName;
        if ("A".equals(name.rawname) && (mapName = this.funcs.get(fname = a.getValue("name"))) != null) {
            this.funcName = mapName.trim();
            if (this.funcName.endsWith("()")) {
                this.funcName = this.funcName.replaceAll("\\(\\)", "").replaceAll("\\p{javaSpaceChar}", "");
            }
            this.begin = true;
            this.funcs.remove(fname);
            this.divCounter = this.refsect2 ? 1 : 0;
            this.refsect2 = false;
        }
        if (this.begin) {
            String type;
            if ("DIV".equals(name.rawname)) {
                ++this.divCounter;
            }
            if (!this.descStart) {
                if ("SPAN".equals(name.rawname)) {
                    type = a.getValue("class");
                    if (this.returnValue == null && type != null && type.equals("returnvalue")) {
                        this.returnType = true;
                    }
                } else if ("PRE".equals(name.rawname) && (type = a.getValue("class")) != null && type.equals("programlisting")) {
                    this.returnType = true;
                }
            }
            if (this.protoStart) {
                if ("P".equals(name.rawname)) {
                    this.protoStart = false;
                    this.descStart = true;
                    this.description.append("<p>");
                }
            } else if (this.descStart) {
                if ("P".equals(name.rawname)) {
                    this.description.append("<p>");
                } else if ("TABLE".equals(name.rawname)) {
                    this.description.append("<dl>");
                } else if ("TR".equals(name.rawname)) {
                    this.rowItemCount = 0;
                } else if ("TD".equals(name.rawname)) {
                    type = a.getValue("class");
                    if (type != null && type.equals("listing_lines")) {
                        this.rowIgnore = true;
                    } else {
                        this.rowIgnore = false;
                        this.rowTag = this.rowItemCount++ == 0 ? "<dt>" : "<dd>";
                        this.description.append(this.rowTag);
                    }
                } else if ("H4".equals(name.rawname)) {
                    this.description.append("<br><br>");
                }
            }
        } else if ("DIV".equals(name.rawname)) {
            String className = a.getValue("class");
            this.refsect2 = "refsect2".equals(className);
        }
    }

    public void endElement(QName name, Augmentations aug) {
        if (this.begin) {
            if ("DIV".equals(name.rawname)) {
                --this.divCounter;
                if (this.divCounter <= 0) {
                    this.begin = false;
                    this.descStart = false;
                    this.parmStart = false;
                    this.protoStart = false;
                    if (this.valid && this.returnValue != null && !this.returnValue.startsWith("#") && !this.returnValue.startsWith("typedef ")) {
                        FunctionInfo info = new FunctionInfo(this.funcName);
                        info.setReturnType(this.returnValue);
                        info.setPrototype(this.prototype.toString());
                        info.setDescription(this.description.toString());
                        this.infos.put(this.funcName, info);
                        this.description.setLength(0);
                        this.prototype.setLength(0);
                        if (this.funcs.isEmpty()) {
                            throw new FuncFoundSaxException();
                        }
                    }
                }
            }
            if (this.descStart) {
                if ("P".equals(name.rawname)) {
                    this.description.append("</p>");
                } else if ("TABLE".equals(name.rawname)) {
                    this.description.append("</dl>");
                } else if ("TR".equals(name.rawname)) {
                    this.rowItemCount = 0;
                } else if ("TD".equals(name.rawname)) {
                    if (!this.rowIgnore) {
                        if (this.rowTag != null && this.rowTag.equals("<dt>")) {
                            this.description.append("</dt>");
                        } else {
                            this.description.append("</dd>");
                        }
                    }
                    this.rowIgnore = false;
                } else if ("H4".equals(name.rawname)) {
                    this.description.append("</br></br>");
                }
            }
        }
    }

    public void characters(XMLString data, Augmentations aug) {
        if (this.begin) {
            if (this.returnType) {
                this.returnValue = "";
                String tmp = data.toString().trim();
                boolean completed = false;
                if (tmp.endsWith(");")) {
                    completed = true;
                    tmp = tmp.substring(0, tmp.length() - 2);
                }
                String[] tokens = tmp.split("\\s+");
                String separator = "";
                this.protoStart = true;
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    if (token.equals(this.funcName)) {
                        separator = "";
                        for (int j = i + 1; j < tokens.length; ++j) {
                            String jtoken = tokens[j];
                            if (j == i + 1 && jtoken.charAt(0) == '(') {
                                jtoken = jtoken.substring(1);
                                this.parmStart = true;
                                this.protoStart = false;
                            }
                            this.prototype.append(separator).append(jtoken);
                            separator = " ";
                        }
                        if (!this.parmStart || !completed) break;
                        this.parmStart = false;
                        this.descStart = true;
                        break;
                    }
                    this.returnValue = this.returnValue + separator + token;
                    separator = " ";
                }
                this.returnType = false;
            } else if (this.protoStart) {
                String temp = data.toString().trim();
                boolean completed = false;
                if (temp.endsWith(");")) {
                    completed = true;
                    temp = temp.substring(0, temp.length() - 2);
                }
                String separator = " ";
                while (temp.startsWith("*") || temp.startsWith("const")) {
                    if (temp.charAt(0) == '*') {
                        this.returnValue = this.returnValue + separator + "*";
                        temp = temp.substring(1).trim();
                        separator = "";
                        continue;
                    }
                    this.returnValue = this.returnValue + "const";
                    temp = temp.substring(5).trim();
                    separator = " ";
                }
                int index = temp.lastIndexOf(40);
                int index2 = temp.lastIndexOf(41);
                if (index2 < index) {
                    if (index + 1 < temp.length()) {
                        temp = temp.substring(index + 1).trim();
                        this.prototype.append(temp);
                    }
                    this.parmStart = true;
                    this.protoStart = false;
                }
                if (this.parmStart && completed) {
                    this.parmStart = false;
                    this.descStart = true;
                }
            } else if (this.parmStart) {
                Object parmData = data.toString().trim();
                int index = ((String)parmData).indexOf(41);
                if (index >= 0) {
                    this.parmStart = false;
                    this.descStart = true;
                    parmData = ((String)parmData).substring(0, index);
                }
                if (this.prototype.length() == 0 && !((String)parmData).equals(",") && !((String)parmData).isEmpty()) {
                    parmData = " " + (String)parmData;
                }
                this.prototype.append((String)parmData);
            } else if (this.descStart && !this.rowIgnore) {
                this.description.append(String.valueOf(data));
            }
        }
    }

    @Override
    public TreeMap<String, FunctionInfo> getFunctionInfos() {
        return this.infos;
    }

    public String toString() {
        return "funcName: <" + this.funcName + "> returnType: <" + this.returnValue + "> prototype: <" + String.valueOf(this.prototype) + "> description: " + String.valueOf(this.description);
    }
}

