/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.swt.widgets.Display;

public class STPReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    protected static final int STP_NO_TAG = 0;
    protected static final int STP_MULTILINE_COMMENT_TAG = 1;
    protected static final int STP_PROBE = 2;
    protected static final int STP_FUNCTION = 3;
    protected int nextCharPosition = 0;
    protected int currentTagStart = 0;
    protected int currentTagEnd = 0;
    protected final ArrayList<Position> documentPositionList = new ArrayList();
    protected int endOfDocumentPostion;
    private IDocument currentDocument;
    private STPEditor currentEditor;

    public void setEditor(STPEditor editor) {
        this.currentEditor = editor;
    }

    public void setDocument(IDocument document) {
        this.currentDocument = document;
    }

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void initialReconcile() {
        this.endOfDocumentPostion = this.currentDocument.getLength();
        try {
            this.calculatePositions();
        }
        catch (BadLocationException e) {
            return;
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    private void calculatePositions() throws BadLocationException {
        this.documentPositionList.clear();
        this.nextCharPosition = 0;
        this.buildPositions();
        Display.getDefault().asyncExec(() -> this.currentEditor.updateFoldingStructure(this.documentPositionList));
    }

    private int classifyComponent(int location) throws BadLocationException {
        int deltaLocation = location;
        char ch = this.currentDocument.getChar(deltaLocation);
        switch (ch) {
            case '/': {
                ch = this.currentDocument.getChar(++deltaLocation);
                if (ch != '*') break;
                this.currentTagStart = location;
                this.nextCharPosition = ++deltaLocation;
                return 1;
            }
            case 'p': {
                if (this.isProbe()) {
                    this.currentTagStart = location;
                    return 2;
                }
            }
            case 'f': {
                if (!this.isFunction()) break;
                this.currentTagStart = location;
                return 3;
            }
        }
        return 0;
    }

    private void buildPositions() throws BadLocationException {
        block4: while (this.nextCharPosition < this.endOfDocumentPostion) {
            switch (this.classifyComponent(this.nextCharPosition)) {
                case 1: {
                    this.currentTagEnd = this.findEndOfComment();
                    this.writePosition(this.currentTagStart, this.currentTagEnd);
                    this.nextCharPosition = this.currentTagStart + this.currentTagEnd;
                    continue block4;
                }
                case 2: 
                case 3: {
                    this.currentTagEnd = this.findEndOfProbeOrFunction();
                    this.writePosition(this.currentTagStart, this.currentTagEnd);
                    this.nextCharPosition = this.currentTagStart + this.currentTagEnd;
                    continue block4;
                }
            }
            ++this.nextCharPosition;
        }
    }

    private void writePosition(int startOffset, int length) {
        if (length > 0) {
            this.documentPositionList.add(new Position(startOffset, length));
        }
    }

    private boolean isProbe() throws BadLocationException {
        return this.matchKeyWord("probe");
    }

    private boolean isFunction() throws BadLocationException {
        return this.matchKeyWord("function");
    }

    private boolean matchKeyWord(String word) throws BadLocationException {
        char ch;
        StringBuilder keyWord = new StringBuilder();
        for (int location = this.nextCharPosition; location < this.endOfDocumentPostion && (ch = this.currentDocument.getChar(location)) != ' ' && Character.isLetter(ch); ++location) {
            keyWord.append(ch);
        }
        return keyWord.toString().compareTo(word) == 0;
    }

    private int findEndOfProbeOrFunction() throws BadLocationException {
        int bracketCount = 0;
        boolean firstBracket = false;
        while (this.nextCharPosition < this.endOfDocumentPostion) {
            char ch = this.currentDocument.getChar(this.nextCharPosition);
            if (ch == '{') {
                firstBracket = true;
                ++bracketCount;
            }
            if (ch == '}') {
                --bracketCount;
            }
            if (bracketCount == 0 && firstBracket) {
                return this.nextCharPosition - this.currentTagStart + 2;
            }
            ++this.nextCharPosition;
        }
        return -1;
    }

    private int findEndOfComment() throws BadLocationException {
        while (this.nextCharPosition < this.endOfDocumentPostion) {
            char ch = this.currentDocument.getChar(this.nextCharPosition);
            if (ch == '*') {
                ++this.nextCharPosition;
                ch = this.currentDocument.getChar(this.nextCharPosition);
                if (ch == '/') {
                    return this.nextCharPosition - this.currentTagStart + 2;
                }
            }
            ++this.nextCharPosition;
        }
        return -1;
    }
}

