/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.io.File;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;

public class BuildDockerImageUtils {
    public static IPath getPath(String pathLocation, boolean workspaceRelativeLocation) {
        if (workspaceRelativeLocation) {
            IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(pathLocation));
            if (member != null) {
                return member.getLocation();
            }
        } else if (new File(pathLocation).exists()) {
            return new Path(pathLocation);
        }
        return null;
    }

    public static String getRepository(String imageName) {
        Matcher imageNameMatcher = DockerImage.imageNamePattern.matcher(imageName);
        if (imageNameMatcher.matches()) {
            return imageNameMatcher.group("repository");
        }
        return null;
    }

    public static String getName(String imageName) {
        Matcher imageNameMatcher = DockerImage.imageNamePattern.matcher(imageName);
        if (imageNameMatcher.matches()) {
            return imageNameMatcher.group("name");
        }
        return null;
    }

    public static String getTag(String imageName) {
        Matcher imageNameMatcher = DockerImage.imageNamePattern.matcher(imageName);
        if (imageNameMatcher.matches()) {
            return imageNameMatcher.group("tag");
        }
        return null;
    }
}

