/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.teditor.validation;

import activity.Action;
import activity.Activity;
import activity.ActivityPackage;
import activity.ActivitySet;
import activity.Claim;
import activity.Event;
import activity.LocationPrerequisite;
import activity.Move;
import activity.PeripheralAction;
import activity.RaiseEvent;
import activity.Release;
import activity.RequireEvent;
import activity.ResourceAction;
import activity.SchedulingType;
import activity.SimpleAction;
import activity.SyncBar;
import activity.impl.ActivityQueries;
import activity.util.ActivityUtil;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import machine.Distance;
import machine.HasResourcePeripheral;
import machine.IResource;
import machine.Import;
import machine.MachinePackage;
import machine.PathTargetReference;
import machine.Peripheral;
import machine.Profile;
import machine.Resource;
import machine.ResourceItem;
import machine.ResourceType;
import machine.SymbolicPosition;
import machine.impl.MachineQueries;
import machine.util.ResourcePeripheralKey;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.lsat.activity.teditor.validation.AbstractActivityValidator;
import org.eclipse.lsat.common.graph.directed.editable.EdgPackage;
import org.eclipse.lsat.common.graph.directed.editable.EdgQueries;
import org.eclipse.lsat.common.graph.directed.editable.EditableDirectedGraph;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.util.BranchIterable;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ActivityValidator
extends AbstractActivityValidator {
    public static final String ALAP_SCENARIO_1 = "invalidAlapScenario1";
    public static final String ALAP_SCENARIO_2 = "invalidAlapScenario2";
    public static final String ALAP_SCENARIO_3 = "invalidAlapScenario3";
    public static final String ALAP_SCENARIO_4 = "invalidAlapScenario4";
    public static final String INVALID_CLAIM = "invalidClaim";
    public static final String INVALID_PASSIVE_CLAIM = "invalidPassiveClaim";
    public static final String SUGGEST_PASSIVE_CLAIM = "suggestPassiveClaim";
    public static final String INVALID_RELEASE = "invalidRelease";
    public static final String PASSIVE_CLAIM_INCOMING_EDGES = "passiveClaimIncomingEdges";
    public static final String PASSIVE_RELEASE_OUTGOING_EDGES = "passiveReleaseOutgoingEdges";
    public static final String INVALID_SYNC_BAR = "invalidSyncBar";
    public static final String REMOVE_SYNC_BAR = "removeSyncBar";
    public static final String NO_INCOMING_EDGES = "noIncomingEdges";
    public static final String NO_OUTGOING_EDGES = "noOutgoingEdges";
    public static final String DEAD_ACTION = "deadAction";
    public static final String DEAD_EVENT = "deadEvent";
    public static final String MORE_THAN_ONE_INCOMING_EDGE = "moreThanOneIncomingEdge";
    public static final String MORE_THAN_ONE_OUTGOING_EDGE = "moreThanOneOutgoingEdge";
    public static final String ONE_CLAIM_PER_RESOURCE_PER_ACT = "oneClaimPerResourcePerActivity";
    public static final String ONE_EVENT_WITH_SAME_NAME_PER_ACT = "oneEventWithSameNamePerActivity";
    public static final String ONE_RELEASE_PER_RESOURCE_PER_ACT = "oneReleasePerResourcePerActivity";
    public static final String NO_CLAIM_DEFINED_FOR_RESOURCE = "noClaimDefinedForResource";
    public static final String RESOURCE_NOT_PROPERLY_CLAIMED = "resourceNotProperlyClaimed";
    public static final String NO_RELEASE_DEFINED_FOR_RESOURCE = "noReleaseDefinedForResource";
    public static final String RESOURCE_NOT_PROPERLY_RELEASED = "resourceNotProperlyReleased";
    public static final String CYCLE_DETECTED = "cycleDetected";
    public static final String ACTION_IN_PARALLEL_FOR_SAME_PERIPHERAL = "actionInParallelForSamePeripheral";
    public static final String NO_LOC_PREREQUISTIE_FOR_PERIPHERAL_FOR_MOVE = "noLocPrereqForPeripheralForMove";
    public static final String DUPLICATE_ACTIVITY_NAME = "duplicateActivityName";
    public static final String MORE_THAN_ONE_LOCATION_PREREQ_FOR_PERIPHERAL = "moreThanOneLocationPrereqForPeripheral";
    public static final String SAME_SOURCE_TARGET_FOR_PERIPHERAL = "sameSourceTargetForPeripheral";
    public static final String NO_PATH_FOUND_FOR_PROFILE = "noPathFoundForProfile";
    public static final String SETTLING_ALREADY_DEFINED_FOR_PATH = "settlingAlreadyDefinedForPath";
    public static final String SETTLING_ALREADY_DEFINED_FOR_MOVE = "settlingAlreadyDefinedForMove";
    public static final String NO_CONCAT_FOUND_FOR_MOVE = "noConcatFoundForMove";
    public static final String INVALID_IMPORT = "invalidImport";

    @Check
    public void checkImportIsValid(Import imp) {
        try {
            boolean isUnderstood;
            boolean isImportUriValid = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
            if (!isImportUriValid) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The import ");
                String _importURI = imp.getImportURI();
                _builder.append(_importURI);
                _builder.append(" cannot be resolved. Make sure that the name is spelled correctly.");
                this.error(_builder.toString(), (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            if (!(isUnderstood = imp.getImportURI().matches(".*\\.(machine|activity)"))) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Importing ");
                String _importURI_1 = imp.getImportURI();
                _builder_1.append(_importURI_1);
                _builder_1.append(" is not allowed. Only 'machine' files are allowed");
                this.error(_builder_1.toString(), (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("The import ");
                String _importURI_2 = imp.getImportURI();
                _builder_2.append(_importURI_2);
                _builder_2.append(" is not a valid URI.");
                this.error(_builder_2.toString(), (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public boolean concatenatesASAP(Action action) {
        boolean willDoASAP;
        boolean _switchResult = false;
        boolean _matched = false;
        if (action instanceof PeripheralAction) {
            _matched = true;
            SchedulingType _schedulingType = ((PeripheralAction)action).getSchedulingType();
            _switchResult = Objects.equal((Object)_schedulingType, (Object)SchedulingType.ASAP);
        }
        if (!_matched && action instanceof Release) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return (willDoASAP = _switchResult) && IterableExtensions.size((Iterable)EdgQueries.nearestPredecessors((Node)action, Action.class)) <= 1;
    }

    public boolean concatenatesALAP(Action action) {
        boolean willDoALAP;
        boolean _switchResult = false;
        boolean _matched = false;
        if (action instanceof PeripheralAction) {
            _matched = true;
            SchedulingType _schedulingType = ((PeripheralAction)action).getSchedulingType();
            _switchResult = Objects.equal((Object)_schedulingType, (Object)SchedulingType.ALAP);
        }
        if (!_matched && action instanceof Claim) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return (willDoALAP = _switchResult) && IterableExtensions.size((Iterable)EdgQueries.nearestSuccessors((Node)action, Action.class)) <= 1;
    }

    @Check
    public void checkActionIsALAPWithSuccessorIsASAP(PeripheralAction action) {
        if (Objects.equal((Object)action.getSchedulingType(), (Object)SchedulingType.ALAP) && IterableExtensions.exists((Iterable)EdgQueries.nearestSuccessors((Node)action, Action.class), it -> this.concatenatesASAP((Action)it))) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The ALAP keyword does not have any affect for action ");
            String _name = action.getName();
            _builder.append(_name);
            _builder.append(".");
            this.warning(_builder.toString(), (EStructuralFeature)ActivityPackage.Literals.PERIPHERAL_ACTION__SCHEDULING_TYPE, ALAP_SCENARIO_1, new String[0]);
        }
    }

    @Check
    public void checkConcatenatedMove(Move move) {
        boolean requiresALAP;
        Move predecessorMove;
        boolean isContinuing;
        Move successorMove = move.getSuccessorMove();
        boolean _isStopAtTarget = move.isStopAtTarget();
        boolean bl = isContinuing = !_isStopAtTarget;
        if (isContinuing) {
            boolean _not;
            Set successorPeripheralActions = IterableExtensions.toSet((Iterable)EdgQueries.nearestSuccessors((Node)move, PeripheralAction.class));
            if (successorMove == null) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = move.getName();
                _builder.append(_name);
                _builder.append(" should be concatenated with another move. ");
                this.error(_builder.toString(), (EObject)move, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, NO_CONCAT_FOUND_FOR_MOVE, new String[0]);
                return;
            }
            boolean _contains = successorPeripheralActions.contains(successorMove);
            boolean bl2 = _not = !_contains;
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Failed to concatenate ");
                String _name_1 = move.getName();
                _builder_1.append(_name_1);
                _builder_1.append(" and ");
                String _name_2 = successorMove.getName();
                _builder_1.append(_name_2);
                _builder_1.append(", only sync bars, claims, releases or events are allowed in between.");
                this.error(_builder_1.toString(), (EObject)move, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, NO_CONCAT_FOUND_FOR_MOVE, new String[0]);
                return;
            }
        }
        boolean isContinuated = (predecessorMove = move.getPredecessorMove()) != null && !predecessorMove.isStopAtTarget();
        Functions.Function1 _function = it -> EdgQueries.nearestSuccessors((Node)it, Action.class);
        Functions.Function1 _function_1 = it -> Objects.equal((Object)it, (Object)move);
        BranchIterable actionsUntilPredecessorMove = Queries.until((BranchIterable)Queries.closure(Collections.singleton(predecessorMove), (boolean)true, (Functions.Function1)_function), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> EdgQueries.nearestPredecessors((Node)it, Action.class);
        Functions.Function1 _function_3 = it -> Objects.equal((Object)it, (Object)move);
        BranchIterable actionsUntilSuccessorMove = Queries.until((BranchIterable)Queries.closure(Collections.singleton(successorMove), (boolean)true, (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        boolean requiresASAP = isContinuated && IterableExtensions.exists((Iterable)actionsUntilPredecessorMove, it -> {
            boolean _concatenatesALAP = this.concatenatesALAP((Action)it);
            return !_concatenatesALAP;
        });
        boolean bl3 = requiresALAP = isContinuing && IterableExtensions.exists((Iterable)actionsUntilSuccessorMove, it -> {
            boolean _concatenatesASAP = this.concatenatesASAP((Action)it);
            return !_concatenatesASAP;
        }) && !IterableExtensions.exists((Iterable)EdgQueries.nearestSuccessors((Node)move, Action.class), it -> this.concatenatesASAP((Action)it));
        if (requiresASAP && requiresALAP) {
            Set predecessors = IterableExtensions.toSet((Iterable)EdgQueries.allPredecessors((Node)successorMove));
            predecessors.remove(move);
            CollectionExtensions.removeAll((Collection)predecessors, (Iterable)EdgQueries.allPredecessors((Node)move));
            Iterable _reject = IterableExtensions.reject((Iterable)IterableExtensions.reject((Iterable)predecessors, Release.class), SyncBar.class);
            for (Node pred : _reject) {
                Activity activity = (Activity)EcoreUtil2.getContainerOfType((EObject)pred, Activity.class);
                int predIndex = activity.getNodes().indexOf((Object)pred);
                StringConcatenation _builder_2 = new StringConcatenation();
                String _name_3 = pred.getName();
                _builder_2.append(_name_3);
                _builder_2.append(" might interrupt concatenated move [");
                String _name_4 = move.getName();
                _builder_2.append(_name_4);
                _builder_2.append("->");
                String _name_5 = successorMove.getName();
                _builder_2.append(_name_5);
                _builder_2.append("]");
                this.warning(_builder_2.toString(), (EObject)activity, (EStructuralFeature)EdgPackage.Literals.EDITABLE_DIRECTED_GRAPH__NODES, predIndex, ALAP_SCENARIO_4, new String[0]);
            }
        } else {
            if (requiresASAP && Objects.equal((Object)move.getSchedulingType(), (Object)SchedulingType.ALAP)) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Move ");
                String _name_3 = move.getName();
                _builder_2.append(_name_3);
                _builder_2.append(" must be set to ASAP to guarantee concatenation with predecessor move ");
                String _name_4 = predecessorMove.getName();
                _builder_2.append(_name_4);
                _builder_2.append(".");
                this.error(_builder_2.toString(), (EStructuralFeature)ActivityPackage.Literals.PERIPHERAL_ACTION__SCHEDULING_TYPE, ALAP_SCENARIO_3, new String[0]);
                return;
            }
            if (requiresALAP && Objects.equal((Object)move.getSchedulingType(), (Object)SchedulingType.ASAP)) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("Move ");
                String _name_5 = move.getName();
                _builder_3.append(_name_5);
                _builder_3.append(" must be set to ALAP to guarantee concatenation with successor move ");
                String _name_6 = successorMove.getName();
                _builder_3.append(_name_6);
                _builder_3.append(".");
                this.error(_builder_3.toString(), (EStructuralFeature)ActivityPackage.Literals.PERIPHERAL_ACTION__SCHEDULING_TYPE, ALAP_SCENARIO_2, new String[0]);
                return;
            }
        }
    }

    @Check
    public void checkIfUsedInActivityFlow(Claim claim) {
        boolean _isEmpty = claim.getOutgoingEdges().isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Claim ");
            String _name = claim.getName();
            _builder.append(_name);
            _builder.append(" has no outgoing edges.");
            this.error(_builder.toString(), (EObject)claim, (EStructuralFeature)EdgPackage.Literals.NODE__OUTGOING_EDGES, INVALID_CLAIM, new String[0]);
        }
    }

    @Check
    public void checkPassiveClaim(Claim claim) {
        boolean _tripleNotEquals;
        ResourceType _resourceType = claim.getResource().getResource().getResourceType();
        boolean bl = _tripleNotEquals = _resourceType != ResourceType.REGULAR;
        if (_tripleNotEquals) {
            return;
        }
        EditableDirectedGraph _graph = claim.getGraph();
        Activity activity = (Activity)_graph;
        Functions.Function1 _function = it -> {
            IResource _resource_1;
            IResource _resource = it.getResource();
            return _resource == (_resource_1 = claim.getResource());
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)activity.getNodes(), PeripheralAction.class), (Functions.Function1)_function));
        boolean hasActions = !_isEmpty;
        boolean isCollisionArea = claim.getResource().getResource().getPeripherals().isEmpty();
        boolean _isPassive = claim.isPassive();
        if (_isPassive) {
            boolean _not;
            if (hasActions) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Claim ");
                String _name = claim.getName();
                _builder.append(_name);
                _builder.append(" cannot be passive. There are actions for resource ");
                String _fqn = claim.getResource().fqn();
                _builder.append(_fqn);
                _builder.append(".");
                this.error(_builder.toString(), (EObject)claim, (EStructuralFeature)ActivityPackage.Literals.CLAIM__PASSIVE, INVALID_PASSIVE_CLAIM, new String[0]);
                return;
            }
            boolean _isEmpty_1 = claim.getIncomingEdges().isEmpty();
            boolean bl2 = _not = !_isEmpty_1;
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Passive claim ");
                String _name_1 = claim.getName();
                _builder_1.append(_name_1);
                _builder_1.append(" should not have incoming edges as they may possibly block other activities.");
                this.warning(_builder_1.toString(), (EObject)claim, (EStructuralFeature)EdgPackage.Literals.NODE__INCOMING_EDGES, PASSIVE_CLAIM_INCOMING_EDGES, new String[0]);
            }
            Functions.Function1 _function_1 = it -> it.getOutgoingEdges().isEmpty();
            Iterable _reject = IterableExtensions.reject((Iterable)ActivityUtil.getReleases((Activity)activity, (IResource)claim.getResource()), (Functions.Function1)_function_1);
            for (Release release : _reject) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Passive release ");
                String _name_2 = release.getName();
                _builder_2.append(_name_2);
                _builder_2.append(" should not have outgoing edges as they may possibly block other activities.");
                this.warning(_builder_2.toString(), (EObject)release, (EStructuralFeature)EdgPackage.Literals.NODE__OUTGOING_EDGES, PASSIVE_RELEASE_OUTGOING_EDGES, new String[0]);
            }
        } else if (!isCollisionArea && !hasActions) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Claim ");
            String _name_3 = claim.getName();
            _builder_3.append(_name_3);
            _builder_3.append(" can be made passive. There are no actions for resource ");
            String _fqn_1 = claim.getResource().fqn();
            _builder_3.append(_fqn_1);
            _builder_3.append(".");
            this.info(_builder_3.toString(), (EObject)claim, (EStructuralFeature)ActivityPackage.Literals.CLAIM__PASSIVE, SUGGEST_PASSIVE_CLAIM, new String[0]);
        }
    }

    @Check
    public void checkIfUsedInActivityFlow(Release release) {
        boolean _isEmpty = release.getIncomingEdges().isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Release ");
            String _name = release.getName();
            _builder.append(_name);
            _builder.append(" has no incoming edges.");
            this.error(_builder.toString(), (EObject)release, (EStructuralFeature)EdgPackage.Literals.NODE__INCOMING_EDGES, INVALID_RELEASE, new String[0]);
        }
    }

    @Check
    public void checkHasEdges(SyncBar syncBar) {
        if (syncBar.getOutgoingEdges().size() > 0 && syncBar.getIncomingEdges().isEmpty()) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("SyncBar ");
            String _name = syncBar.getName();
            _builder.append(_name);
            _builder.append(" has no incoming edges.");
            this.error(_builder.toString(), (EObject)syncBar.getOutgoingEdges().get(0), (EStructuralFeature)EdgPackage.Literals.EDGE__SOURCE_NODE, INVALID_SYNC_BAR, new String[0]);
        }
        if (syncBar.getIncomingEdges().size() == 1 && syncBar.getOutgoingEdges().size() == 1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("SyncBar ");
            String _name_1 = syncBar.getName();
            _builder_1.append(_name_1);
            _builder_1.append(" with only 1 incoming and 1 outgoing edge can be removed.");
            this.warning(_builder_1.toString(), (EObject)syncBar.getOutgoingEdges().get(0), (EStructuralFeature)EdgPackage.Literals.EDGE__SOURCE_NODE, REMOVE_SYNC_BAR, new String[0]);
        }
    }

    @Check
    public void checkIfHasPredecessorAction(RaiseEvent event) {
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)EdgQueries.nearestPredecessors((Node)event, Action.class));
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Event '");
            String _eventName = event.getEventName();
            _builder.append(_eventName);
            _builder.append("' should be preceded with an action.");
            this.error(_builder.toString(), (EObject)event, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, DEAD_EVENT, new String[0]);
        }
    }

    @Check
    public void checkIfHasSuccessorAction(RequireEvent event) {
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)EdgQueries.nearestSuccessors((Node)event, Action.class));
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Event ");
            String _eventName = event.getEventName();
            _builder.append(_eventName);
            _builder.append(" should be succeeded by an action.");
            this.error(_builder.toString(), (EObject)event, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, DEAD_EVENT, new String[0]);
        }
    }

    @Check
    public void checkEventNameUnique(Activity activity) {
        Functions.Function1 _function = it -> it.getEventName();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 2;
        };
        Consumer<Event> _function_2 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("One require and/or raise event with name '");
            String _eventName = it.getEventName();
            _builder.append(_eventName);
            _builder.append("' per activity are allowed.");
            this.error(_builder.toString(), (EObject)it, (EStructuralFeature)ActivityPackage.Literals.EVENT__EVENT_NAME, ONE_EVENT_WITH_SAME_NAME_PER_ACT, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)Iterables.filter((Iterable)activity.getNodes(), Event.class), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkRequireRaise(Activity activity) {
        Functions.Function1 _function = it -> it.getEventName();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size == 2;
        };
        Functions.Function1 _function_2 = it -> !(it.get(0) instanceof RequireEvent) || !(it.get(1) instanceof RaiseEvent);
        Consumer<List> _function_3 = seq -> {
            Consumer<Event> _function_4 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Expecting 'require' followed by 'raise' for event '");
                String _eventName = it.getEventName();
                _builder.append(_eventName);
                _builder.append("', not '");
                String _type = this.type((Event)seq.get(0));
                _builder.append(_type);
                _builder.append("' followed by '");
                String _type_1 = this.type((Event)seq.get(1));
                _builder.append(_type_1);
                _builder.append("' ");
                this.error(_builder.toString(), (EObject)it, (EStructuralFeature)ActivityPackage.Literals.EVENT__EVENT_NAME, ONE_EVENT_WITH_SAME_NAME_PER_ACT, new String[0]);
            };
            seq.forEach(_function_4);
        };
        IterableExtensions.filter((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)Iterables.filter((Iterable)activity.getNodes(), Event.class), (Functions.Function1)_function).values(), (Functions.Function1)_function_1), (Functions.Function1)_function_2).forEach(_function_3);
    }

    public String type(Event event) {
        String _xifexpression = null;
        _xifexpression = event instanceof RequireEvent ? "require" : "raise";
        return _xifexpression;
    }

    @Check
    public void checkIfUsedInActivityFlow(PeripheralAction action) {
        if (action.getIncomingEdges().isEmpty() && action.getOutgoingEdges().isEmpty()) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = action.getName();
            _builder.append(_name);
            _builder.append(" is a dead action. It has no incoming and no outgoing edges.");
            this.error(_builder.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, DEAD_ACTION, new String[0]);
        } else {
            boolean _isEmpty = action.getIncomingEdges().isEmpty();
            if (_isEmpty) {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _name_1 = action.getName();
                _builder_1.append(_name_1);
                _builder_1.append(" is a dead action. It has no incoming edges.");
                this.error(_builder_1.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__INCOMING_EDGES, NO_INCOMING_EDGES, new String[0]);
            } else {
                boolean _isEmpty_1 = action.getOutgoingEdges().isEmpty();
                if (_isEmpty_1) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    String _name_2 = action.getName();
                    _builder_2.append(_name_2);
                    _builder_2.append(" is a dead action. It has no outgoing edges.");
                    this.error(_builder_2.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__OUTGOING_EDGES, NO_OUTGOING_EDGES, new String[0]);
                }
            }
        }
    }

    @Check
    public void checkActionHasOneIncomingAndOneOutgoingEdge(Node node) {
        boolean _greaterThan;
        if (node instanceof SyncBar) {
            return;
        }
        int _size = node.getIncomingEdges().size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = node.getName();
            _builder.append(_name);
            _builder.append(" can only have one incoming dependency. Use sync bars instead.");
            this.warning(_builder.toString(), (EObject)node, (EStructuralFeature)EdgPackage.Literals.NODE__INCOMING_EDGES, MORE_THAN_ONE_INCOMING_EDGE, new String[0]);
        } else {
            boolean _greaterThan_1;
            int _size_1 = node.getOutgoingEdges().size();
            boolean bl2 = _greaterThan_1 = _size_1 > 1;
            if (_greaterThan_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _name_1 = node.getName();
                _builder_1.append(_name_1);
                _builder_1.append(" can only have one outgoing dependency. Use sync bars instead.");
                this.warning(_builder_1.toString(), (EObject)node, (EStructuralFeature)EdgPackage.Literals.NODE__OUTGOING_EDGES, MORE_THAN_ONE_OUTGOING_EDGE, new String[0]);
            }
        }
    }

    @Check
    public void checkOneClaimPerResourcePerActivity(Activity activity) {
        Functions.Function1 _function = it -> it.getResource();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<Claim> _function_2 = duplicateClaim -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Only one claim per resource ");
            String _name = duplicateClaim.getResource().getName();
            _builder.append(_name);
            _builder.append(" per activity is allowed.");
            this.error(_builder.toString(), (EObject)duplicateClaim, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, ONE_CLAIM_PER_RESOURCE_PER_ACT, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)Iterables.filter((Iterable)activity.getNodes(), Claim.class), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkOneReleasePerResourcePerActivity(Activity activity) {
        Functions.Function1 _function = it -> it.getResource();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<Release> _function_2 = duplicateRelease -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Only one release per resource ");
            String _name = duplicateRelease.getResource().getName();
            _builder.append(_name);
            _builder.append(" per activity is allowed.");
            this.error(_builder.toString(), (EObject)duplicateRelease, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, ONE_RELEASE_PER_RESOURCE_PER_ACT, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)Iterables.filter((Iterable)activity.getNodes(), Release.class), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkActionHasAValidClaimAndResource(PeripheralAction action) {
        Functions.Function1 _function = it -> it.getResource();
        Claim claim = (Claim)IterableExtensions.toMap((Iterable)Queries.objectsOfKind((Iterable)action.getGraph().getNodes(), Claim.class), (Functions.Function1)_function).get(action.getResource());
        if (claim == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No claim defined for resource ");
            String _name = action.getResource().getName();
            _builder.append(_name);
            _builder.append(". It is required before ");
            String _name_1 = action.getName();
            _builder.append(_name_1);
            _builder.append(" can be used.");
            this.error(_builder.toString(), (EObject)claim, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, NO_CLAIM_DEFINED_FOR_RESOURCE, new String[0]);
        } else {
            boolean _not;
            boolean _contains = IterableExtensions.contains((Iterable)EdgQueries.allPredecessors((Node)action), (Object)claim);
            boolean bl = _not = !_contains;
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Resource ");
                String _name_2 = action.getResource().getName();
                _builder_1.append(_name_2);
                _builder_1.append(" is not properly claimed (by ");
                String _name_3 = claim.getName();
                _builder_1.append(_name_3);
                _builder_1.append(") before ");
                String _name_4 = action.getName();
                _builder_1.append(_name_4);
                _builder_1.append(" is used.");
                this.warning(_builder_1.toString(), (EObject)claim, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, RESOURCE_NOT_PROPERLY_CLAIMED, new String[0]);
            }
        }
    }

    @Check
    public void checkActionHasAValidReleaseAndResource(PeripheralAction action) {
        Functions.Function1 _function = it -> it.getResource();
        Release release = (Release)IterableExtensions.toMap((Iterable)Queries.objectsOfKind((Iterable)action.getGraph().getNodes(), Release.class), (Functions.Function1)_function).get(action.getResource());
        if (release == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No release defined for resource ");
            String _name = action.getResource().getName();
            _builder.append(_name);
            _builder.append(". It is required before ");
            String _name_1 = action.getName();
            _builder.append(_name_1);
            _builder.append(" can be used.");
            this.error(_builder.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, NO_RELEASE_DEFINED_FOR_RESOURCE, new String[0]);
        } else {
            boolean _not;
            boolean _contains = IterableExtensions.contains((Iterable)EdgQueries.allSuccessors((Node)action), (Object)release);
            boolean bl = _not = !_contains;
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Resource ");
                String _name_2 = action.getResource().getName();
                _builder_1.append(_name_2);
                _builder_1.append(" is not properly released (by ");
                String _name_3 = release.getName();
                _builder_1.append(_name_3);
                _builder_1.append(") before ");
                String _name_4 = action.getName();
                _builder_1.append(_name_4);
                _builder_1.append(" is used.");
                this.warning(_builder_1.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, RESOURCE_NOT_PROPERLY_RELEASED, new String[0]);
            }
        }
    }

    @Check
    public void checkForCycles(PeripheralAction action) {
        boolean _not;
        Set cycle = IterableExtensions.toSet((Iterable)EdgQueries.allSuccessors((Node)action));
        cycle.retainAll(IterableExtensions.toSet((Iterable)EdgQueries.allPredecessors((Node)action)));
        boolean _isEmpty = cycle.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Actions ");
            Functions.Function1 _function = it -> it.getName();
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)cycle, (Functions.Function1)_function), (CharSequence)",");
            _builder.append(_join);
            _builder.append(" have a cyclic dependency.");
            this.error(_builder.toString(), (EObject)action, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, CYCLE_DETECTED, new String[0]);
        }
    }

    @Check
    public void checkForPotentiallyDuplicateActivityNames(ActivitySet activitySet) {
        Functions.Function1 _function = it -> this.expandedNames((Activity)it);
        Functions.Function1 _function_1 = it -> (String)it.getKey();
        Functions.Function1 _function_2 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<Map.Entry> _function_3 = da -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Activity '");
            String _name = ((Activity)da.getValue()).getName();
            _builder.append(_name);
            _builder.append("' conflicts with other activities. Please remove all conflicting instances.");
            this.error(_builder.toString(), (EObject)da.getValue(), (EStructuralFeature)EdgPackage.Literals.EDITABLE_DIRECTED_GRAPH__NAME, DUPLICATE_ACTIVITY_NAME, new String[0]);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)Queries.collect((Iterable)activitySet.getActivities(), (Functions.Function1)_function), (Functions.Function1)_function_1).values(), (Functions.Function1)_function_2)).forEach(_function_3);
    }

    private Set<Map.Entry<String, Activity>> expandedNames(Activity activity) {
        HashMap result = CollectionLiterals.newHashMap();
        result.put(activity.getName(), activity);
        Functions.Function1 _function = it -> it.getResource();
        Functions.Function1 _function_1 = it -> it.getItems().isEmpty();
        Functions.Function1 _function_2 = it -> IterableExtensions.toSet((Iterable)it.getItems());
        Functions.Function1 _function_3 = it -> ActivityUtil.expandName((Activity)activity, (Collection)it);
        Consumer<String> _function_4 = it -> result.put(it, activity);
        IterableExtensions.map(this.cartesianProduct(IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Queries.unique((Iterable)IterableExtensions.reject((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)activity.getNodes(), ResourceAction.class), (Functions.Function1)_function), Resource.class), (Functions.Function1)_function_1)), (Functions.Function1)_function_2))), (Functions.Function1)_function_3).forEach(_function_4);
        return result.entrySet();
    }

    private Set<List<ResourceItem>> cartesianProduct(List<Set<ResourceItem>> r) {
        return Sets.cartesianProduct(r);
    }

    @Check
    public void checkActionInParallelForSamePeripheral(PeripheralAction pAction) {
        EList allNodesInTheGraph = pAction.getGraph().getNodes();
        int indexOfpAction = allNodesInTheGraph.indexOf((Object)pAction);
        QueryableIterable _actionsFor = ActivityQueries.getActionsFor((IResource)pAction.getResource(), (Peripheral)pAction.getPeripheral(), PeripheralAction.class, (Iterable)allNodesInTheGraph.subList(indexOfpAction + 1, allNodesInTheGraph.size()));
        for (PeripheralAction otherAction : _actionsFor) {
            boolean _not;
            boolean bl = _not = !IterableExtensions.contains((Iterable)EdgQueries.allSuccessors((Node)pAction), (Object)otherAction) && !IterableExtensions.contains((Iterable)EdgQueries.allPredecessors((Node)pAction), (Object)otherAction);
            if (!_not) continue;
            StringConcatenation _builder = new StringConcatenation();
            String _name = pAction.getName();
            _builder.append(_name);
            _builder.append(" cannot be done in parallel with ");
            String _name_1 = otherAction.getName();
            _builder.append(_name_1);
            _builder.append(", as they share the same peripheral.");
            this.error(_builder.toString(), (EObject)pAction, (EStructuralFeature)EdgPackage.Literals.NODE__NAME, ACTION_IN_PARALLEL_FOR_SAME_PERIPHERAL, new String[0]);
        }
    }

    @Check
    public HashMap<ResourcePeripheralKey, SymbolicPosition> indexPrerequisites(Activity activity) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)activity.getPrerequisites());
        if (_isNullOrEmpty) {
            return new HashMap<ResourcePeripheralKey, SymbolicPosition>();
        }
        int _size = activity.getPrerequisites().size();
        HashMap<ResourcePeripheralKey, SymbolicPosition> result = new HashMap<ResourcePeripheralKey, SymbolicPosition>(_size);
        EList _prerequisites = activity.getPrerequisites();
        for (LocationPrerequisite prerequisite : _prerequisites) {
            ResourcePeripheralKey key = ResourcePeripheralKey.createKey((HasResourcePeripheral)prerequisite);
            boolean _containsKey = result.containsKey(key);
            if (_containsKey) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Only one location prerequisite for peripheral ");
                String _fqn = key.fqn();
                _builder.append(_fqn);
                _builder.append(" is allowed.");
                this.error(_builder.toString(), (EObject)prerequisite, (EStructuralFeature)ActivityPackage.Literals.LOCATION_PREREQUISITE__PERIPHERAL, MORE_THAN_ONE_LOCATION_PREREQ_FOR_PERIPHERAL, new String[0]);
            }
            result.put(key, prerequisite.getPosition());
        }
        return result;
    }

    @Check
    public void checkMoveHasLocationPrerequisiteForPeripheral(Move move) {
        boolean _isPassing;
        PathTargetReference pathTargetRef;
        SymbolicPosition targetPosition;
        boolean _not;
        boolean _isPositionMove = move.isPositionMove();
        boolean bl = _not = !_isPositionMove;
        if (_not) {
            return;
        }
        Activity moveActivity = (Activity)EcoreUtil2.getContainerOfType((EObject)move, Activity.class);
        HashMap<ResourcePeripheralKey, SymbolicPosition> prerequisites = this.indexPrerequisites(moveActivity);
        Move predecessorMove = move.getPredecessorMove();
        ResourcePeripheralKey key = ResourcePeripheralKey.createKey((HasResourcePeripheral)move);
        if (predecessorMove == null && !prerequisites.containsKey(key)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("This movement requires a location prerequisite for peripheral ");
            String _fqn = ActivityValidator.fqn(move.getPeripheral());
            _builder.append(_fqn);
            _builder.append(".");
            this.error(_builder.toString(), (EStructuralFeature)ActivityPackage.Literals.PERIPHERAL_ACTION__PERIPHERAL, NO_LOC_PREREQUISTIE_FOR_PERIPHERAL_FOR_MOVE, new String[0]);
            return;
        }
        SymbolicPosition _xifexpression = null;
        _xifexpression = predecessorMove == null ? prerequisites.get(key) : predecessorMove.getTargetPosition();
        SymbolicPosition sourcePosition = _xifexpression;
        boolean _equals = Objects.equal((Object)sourcePosition, (Object)(targetPosition = move.getTargetPosition()));
        if (_equals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Peripheral ");
            String _fqn_1 = move.fqn();
            _builder_1.append(_fqn_1);
            _builder_1.append(" already at ");
            String _name = sourcePosition.getName();
            _builder_1.append(_name);
            _builder_1.append(".");
            this.warning(_builder_1.toString(), (EObject)move, (EStructuralFeature)ActivityPackage.Literals.PERIPHERAL_ACTION__PERIPHERAL, SAME_SOURCE_TARGET_FOR_PERIPHERAL, new String[0]);
        }
        if ((pathTargetRef = MachineQueries.findPath((SymbolicPosition)sourcePosition, (SymbolicPosition)targetPosition, (Profile)move.getProfile())) == null) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Don't know how to move peripheral ");
            String _fqn_2 = ActivityValidator.fqn(move.getPeripheral());
            _builder_2.append(_fqn_2);
            _builder_2.append(" from ");
            String _name_1 = sourcePosition.getName();
            _builder_2.append(_name_1);
            _builder_2.append(" to ");
            String _name_2 = targetPosition.getName();
            _builder_2.append(_name_2);
            _builder_2.append(" using speed profile ");
            String _name_3 = move.getProfile().getName();
            _builder_2.append(_name_3);
            _builder_2.append(".");
            this.error(_builder_2.toString(), (EObject)move, (EStructuralFeature)ActivityPackage.Literals.MOVE__PROFILE, NO_PATH_FOUND_FOR_PROFILE, new String[0]);
        }
        if ((_isPassing = move.isPassing()) && pathTargetRef != null && !pathTargetRef.getSettling().isEmpty()) {
            StringConcatenation _builder_3 = new StringConcatenation();
            String _name_4 = move.getName();
            _builder_3.append(_name_4);
            _builder_3.append(" cannot pass symbolic position ");
            String _name_5 = targetPosition.getName();
            _builder_3.append(_name_5);
            _builder_3.append(", as settling is defined for its path.");
            this.error(_builder_3.toString(), (EObject)move, (EStructuralFeature)ActivityPackage.Literals.MOVE__STOP_AT_TARGET, SETTLING_ALREADY_DEFINED_FOR_PATH, new String[0]);
        }
    }

    @Check
    public void checkSettling(Move move) {
        boolean _isContinuing = move.isContinuing();
        if (_isContinuing) {
            boolean _isEmpty;
            Distance _distance = move.getDistance();
            EList _settling = null;
            if (_distance != null) {
                _settling = _distance.getSettling();
            }
            EList settling = _settling;
            boolean _xifexpression = false;
            _xifexpression = settling == null ? false : !(_isEmpty = settling.isEmpty());
            boolean isSettling = _xifexpression;
            if (isSettling) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = move.getName();
                _builder.append(_name);
                _builder.append(" cannot pass ");
                String _name_1 = move.getDistance().getName();
                _builder.append(_name_1);
                _builder.append(", as settling has been defined for axes : ");
                String _join = IterableExtensions.join((Iterable)settling, (CharSequence)",");
                _builder.append(_join);
                this.error(_builder.toString(), (EObject)move, (EStructuralFeature)ActivityPackage.Literals.MOVE__STOP_AT_TARGET, SETTLING_ALREADY_DEFINED_FOR_MOVE, new String[0]);
            }
        }
    }

    private static String fqn(Peripheral peripheral) {
        boolean _tripleEquals;
        String _xifexpression = null;
        Resource _resource = peripheral.getResource();
        boolean bl = _tripleEquals = _resource == null;
        if (_tripleEquals) {
            _xifexpression = "<<unknown>>";
        } else {
            String _name = peripheral.getResource().getName();
            String _plus = String.valueOf(_name) + ".";
            String _name_1 = peripheral.getName();
            _xifexpression = String.valueOf(_plus) + _name_1;
        }
        return _xifexpression;
    }

    public static String names(Iterable<? extends Node> nodes) {
        boolean _not;
        Iterator<? extends Node> iNodes = nodes.iterator();
        boolean _hasNext = iNodes.hasNext();
        boolean bl = _not = !_hasNext;
        if (_not) {
            return "";
        }
        Node _next = iNodes.next();
        String _name = null;
        if (_next != null) {
            _name = _next.getName();
        }
        StringBuilder result = new StringBuilder(_name);
        while (iNodes.hasNext()) {
            Node _next_1 = iNodes.next();
            String _name_1 = null;
            if (_next_1 != null) {
                _name_1 = _next_1.getName();
            }
            String nextName = _name_1;
            String _xifexpression = null;
            boolean _hasNext_1 = iNodes.hasNext();
            _xifexpression = _hasNext_1 ? ", " : " and ";
            result.append(_xifexpression).append(nextName);
        }
        return result.toString();
    }

    public static String id(Node node) {
        return ActivityValidator.id(node, false);
    }

    public static String id(Node node, boolean capitalize) {
        String _name;
        StringConcatenation _builder;
        if (node == null) {
            return null;
        }
        String _switchResult = null;
        Node it = node;
        boolean _matched = false;
        if (it instanceof Claim) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("claim ");
            _name = ((Claim)it).getName();
            _builder.append(_name);
            _switchResult = _builder.toString();
        }
        if (!_matched && it instanceof Release) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("release ");
            _name = ((Release)it).getName();
            _builder.append(_name);
            _switchResult = _builder.toString();
        }
        if (!_matched && it instanceof SimpleAction) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("action ");
            _name = ((SimpleAction)it).getName();
            _builder.append(_name);
            _switchResult = _builder.toString();
        }
        if (!_matched && it instanceof Move) {
            boolean _not;
            _matched = true;
            _builder = new StringConcatenation();
            boolean _isStopAtTarget = ((Move)it).isStopAtTarget();
            boolean bl = _not = !_isStopAtTarget;
            if (_not) {
                boolean _isPositionMove = ((Move)it).isPositionMove();
                if (_isPositionMove) {
                    _builder.append("passing ");
                } else {
                    _builder.append("continuing ");
                }
            }
            _builder.append("move ");
            _name = ((Move)it).getName();
            _builder.append(_name);
            _switchResult = _builder.toString();
        }
        if (!_matched && it instanceof SyncBar) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("sync-bar ");
            _name = ((SyncBar)it).getName();
            _builder.append(_name);
            _switchResult = _builder.toString();
        }
        String id = _switchResult;
        String _xifexpression = null;
        _xifexpression = capitalize ? StringExtensions.toFirstUpper(id) : id;
        return _xifexpression;
    }
}

