/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.contributions.ui.project;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import machine.Machine;
import machine.MachineFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.lsat.contributions.ui.Activator;
import org.eclipse.lsat.contributions.ui.project.LogisticsNatureHandler;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.session.UserSession;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.xtext.resource.XtextResourceSet;

public class WizardProject
extends Wizard
implements INewWizard {
    public static final String ID = "org.eclipse.lsat.contributions.ui.WizardProject";
    private WizardNewProjectCreationPage newProjectPage;

    public WizardProject() {
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        boolean finished = true;
        try {
            final String projectName = this.newProjectPage.getProjectName();
            final IPath locationPath = this.newProjectPage.getLocationPath();
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IProject project = ModelingProjectManager.INSTANCE.createNewModelingProject(projectName, locationPath, true, monitor);
                        LogisticsNatureHandler.addNatures(project, "org.eclipse.lsat.LogisticsProjectNature", "org.eclipse.xtext.ui.shared.xtextNature");
                        String machineType = projectName.replaceAll("\\W", "_");
                        Machine machine = MachineFactory.eINSTANCE.createMachine();
                        machine.setType(machineType);
                        IFile machineFile = project.getFile(String.valueOf(projectName) + ".machine");
                        URI machineURI = URI.createPlatformResourceURI((String)machineFile.getFullPath().toString(), (boolean)true);
                        XtextResourceSet resourceSet = new XtextResourceSet();
                        Resource machineResource = resourceSet.createResource(machineURI);
                        machineResource.getContents().add((Object)machine);
                        machineResource.save(Collections.emptyMap());
                        project.refreshLocal(1, monitor);
                        IFile representationsFile = project.getFile("representations.aird");
                        URI representationsURI = URI.createPlatformResourceURI((String)representationsFile.getFullPath().toString(), (boolean)true);
                        Session session = SessionManager.INSTANCE.getSession(representationsURI, monitor);
                        UserSession userSession = UserSession.from((Session)session);
                        userSession.selectViewpoint("SymbolicPosition");
                        userSession.save(monitor);
                        userSession.close(monitor);
                        project.close(monitor);
                        project.open(monitor);
                    }
                    catch (IOException | CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.lsat.contributions.ui", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            finished = false;
        }
        catch (InterruptedException e) {
            Status status = new Status(4, "org.eclipse.lsat.contributions.ui", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            finished = false;
        }
        return finished;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New Logistics Project");
    }

    public void addPages() {
        this.newProjectPage = new WizardNewProjectCreationPage("Create a Logistics Project");
        this.newProjectPage.setInitialProjectName("");
        this.newProjectPage.setTitle("Create a Logistics Project");
        this.newProjectPage.setDescription("Enter a project name");
        this.addPage((IWizardPage)this.newProjectPage);
        super.addPages();
    }
}

