/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform;

import java.util.Collections;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.common.util.ModelConsolidator;
import org.eclipse.mdht.uml.transform.AbstractTransformer;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.internal.Logger;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class FlattenTransformer
extends AbstractTransformer {
    protected ModelConsolidator consolidator = null;
    private Package flattenedPackage = null;
    private Package flattenedVocabPackage = null;

    public FlattenTransformer() {
        this(new TransformerOptions());
    }

    public FlattenTransformer(TransformerOptions options) {
        this.transformerOptions = options;
    }

    protected ModelConsolidator createModelConsolidator() {
        this.consolidator = new ModelConsolidator();
        return this.consolidator;
    }

    public Package getFlattenedPackage() {
        return this.flattenedPackage;
    }

    public Package getFlattenedVocabPackage() {
        return this.flattenedVocabPackage;
    }

    @Override
    public void transformModelElement(Element element) {
        if (this.consolidator == null) {
            this.initialize(element.getNearestPackage());
        }
        try {
            TreeIterator iterator = EcoreUtil.getAllContents(Collections.singletonList(element));
            while (iterator != null && iterator.hasNext()) {
                EObject child = (EObject)iterator.next();
                if (!(child instanceof Class)) continue;
                this.consolidator.consolidateClass((Class)child);
            }
        }
        catch (IndexOutOfBoundsException e) {
            Logger.logException(e);
        }
    }

    public void initialize(Package sourcePackage) {
        this.flattenedPackage = this.initializeConsolidationPackageFrom((Element)sourcePackage);
        if (this.transformerOptions.getVocabModelPath() != null) {
            this.flattenedVocabPackage = this.initializeVocabPackageFrom((Element)this.flattenedPackage);
        }
        this.consolidator = this.createModelConsolidator();
        this.consolidator.initialize(sourcePackage, this.flattenedPackage);
        this.consolidator.setIncludeBaseModel(this.transformerOptions.isIncludeBaseModel());
    }

    @Override
    public void saveResources() {
        this.consolidator.removeAllConsolidationAnnotations();
        this.consolidator.renameReferencesInOCL();
    }

    private Package initializeConsolidationPackageFrom(Element element) {
        return this.initializeModelPackageFrom(element, this.transformerOptions.getOutputModelPath(), "flattened", "consol", "Consol");
    }

    private Package initializeVocabPackageFrom(Element element) {
        Package vocabPkg = this.initializeModelPackageFrom(element, this.transformerOptions.getVocabModelPath(), "flattened_vocab", "vocab", "Vocab");
        return vocabPkg;
    }
}

