/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.cda.consol.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.Entry;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.util.CDADiagnostic;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.cda.util.ValidationResult;
import org.openhealthtools.mdht.uml.cda.consol.ConsolPackage;

public class Test2023SVAPCCD {
    public static void main(String[] args) {
        Test2023SVAPCCD.validateDS("2023SVAPCCD");
        System.out.println("=========================");
    }

    public static void validateDS(String fileName) {
        StringBuffer sb = new StringBuffer();
        String path = "samples/";
        ConsolPackage.eINSTANCE.eClass();
        ValidationResult result = new ValidationResult();
        try {
            ClinicalDocument cd = CDAUtil.load((InputStream)new FileInputStream(String.valueOf(path) + fileName + ".xml"), (CDAUtil.ValidationHandler)result);
            for (Diagnostic dq : result.getErrorDiagnostics()) {
                CDADiagnostic cdaDiagnosticq = new CDADiagnostic(dq);
                sb.append("ERROR|" + cdaDiagnosticq.getMessage() + "|" + cdaDiagnosticq.getPath() + "|" + cdaDiagnosticq.getCode() + "|" + cdaDiagnosticq.getSource());
                sb.append("\n");
            }
            for (Section section : cd.getAllSections()) {
                System.out.println(section.getClass().getCanonicalName());
                for (Entry entry : section.getEntries()) {
                    System.out.println(entry.getClass().getCanonicalName());
                    if (entry.getOrganizer() != null) {
                        System.out.println(entry.getOrganizer().getClass().getCanonicalName());
                    }
                    if (entry.getObservation() == null) continue;
                    System.out.println(entry.getObservation().getClass().getCanonicalName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(sb);
    }
}

