/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.mdht.uml.cda.Act;
import org.eclipse.mdht.uml.cda.AssignedEntity;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.CDAPackage;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.ClinicalStatement;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.EntryRelationship;
import org.eclipse.mdht.uml.cda.Observation;
import org.eclipse.mdht.uml.cda.ObservationMedia;
import org.eclipse.mdht.uml.cda.Organizer;
import org.eclipse.mdht.uml.cda.ParticipantRole;
import org.eclipse.mdht.uml.cda.Procedure;
import org.eclipse.mdht.uml.cda.RegionOfInterest;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.SubstanceAdministration;
import org.eclipse.mdht.uml.cda.Supply;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.CD;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.rim.operations.ActOperations;
import org.eclipse.mdht.uml.hl7.vocab.x_ActRelationshipEntryRelationship;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.OCLExpression;

public class ClinicalStatementOperations
extends ActOperations {
    protected static final ThreadLocal<OCL> EOCL_ENV = new ThreadLocal<OCL>(){

        @Override
        public OCL initialValue() {
            return OCL.newInstance();
        }
    };
    protected static final String HAS_ACT_TEMPLATE__STRING__EOCL_EXP = "self.getActs()->exists(act : cda::Act | act.hasTemplateId(templateId))";
    protected static ThreadLocal<OCLExpression<EClassifier>> HAS_ACT_TEMPLATE__STRING__EOCL_QRY = new ThreadLocal();
    protected static final String HAS_ENCOUNTER_TEMPLATE__STRING__EOCL_EXP = "self.getEncounters()->exists(enc : cda::Encounter | enc.hasTemplateId(templateId))";
    protected static ThreadLocal<OCLExpression<EClassifier>> HAS_ENCOUNTER_TEMPLATE__STRING__EOCL_QRY = new ThreadLocal();
    protected static final String HAS_OBSERVATION_MEDIA_TEMPLATE__STRING__EOCL_EXP = "self.getObservationMedia()->exists(media : cda::ObservationMedia | media.hasTemplateId(templateId))";
    protected static ThreadLocal<OCLExpression<EClassifier>> HAS_OBSERVATION_MEDIA_TEMPLATE__STRING__EOCL_QRY = new ThreadLocal();
    protected static final String HAS_OBSERVATION_TEMPLATE__STRING__EOCL_EXP = "self.getObservations()->exists(obs : cda::Observation | obs.hasTemplateId(templateId))";
    protected static ThreadLocal<OCLExpression<EClassifier>> HAS_OBSERVATION_TEMPLATE__STRING__EOCL_QRY = new ThreadLocal();
    protected static final String HAS_ORGANIZER_TEMPLATE__STRING__EOCL_EXP = "self.getOrganizers()->exists(org : cda::Organizer | org.hasTemplateId(templateId))";
    protected static ThreadLocal<OCLExpression<EClassifier>> HAS_ORGANIZER_TEMPLATE__STRING__EOCL_QRY = new ThreadLocal();
    protected static final String HAS_PROCEDURE_TEMPLATE__STRING__EOCL_EXP = "self.getProcedures()->exists(proc : cda::Procedure | proc.hasTemplateId(templateId))";
    protected static ThreadLocal<OCLExpression<EClassifier>> HAS_PROCEDURE_TEMPLATE__STRING__EOCL_QRY = new ThreadLocal();
    protected static final String HAS_REGION_OF_INTEREST_TEMPLATE__STRING__EOCL_EXP = "self.getRegionsOfInterest()->exists(reg : cda::RegionOfInterest | reg.hasTemplateId(templateId))";
    protected static ThreadLocal<OCLExpression<EClassifier>> HAS_REGION_OF_INTEREST_TEMPLATE__STRING__EOCL_QRY = new ThreadLocal();
    protected static final String HAS_SUBSTANCE_ADMINISTRATION_TEMPLATE__STRING__EOCL_EXP = "self.getSubstanceAdministrations()->exists(sub : cda::SubstanceAdministration | sub.hasTemplateId(templateId))";
    protected static ThreadLocal<OCLExpression<EClassifier>> HAS_SUBSTANCE_ADMINISTRATION_TEMPLATE__STRING__EOCL_QRY = new ThreadLocal();
    protected static final String HAS_SUPPLY_TEMPLATE__STRING__EOCL_EXP = "self.getSupplies()->exists(sup : cda::Supply | sup.hasTemplateId(templateId))";
    protected static ThreadLocal<OCLExpression<EClassifier>> HAS_SUPPLY_TEMPLATE__STRING__EOCL_QRY = new ThreadLocal();
    protected static final String GET_PARTICIPANT_ROLES__EOCL_EXP = "self.participant.participantRole->excluding(null)";
    protected static ThreadLocal<OCLExpression<EClassifier>> GET_PARTICIPANT_ROLES__EOCL_QRY = new ThreadLocal();
    protected static final String GET_ASSIGNED_ENTITIES__EOCL_EXP = "self.performer.assignedEntity->excluding(null)";
    protected static ThreadLocal<OCLExpression<EClassifier>> GET_ASSIGNED_ENTITIES__EOCL_QRY = new ThreadLocal();

    protected ClinicalStatementOperations() {
    }

    private static List<EntryRelationship> getEntryRelationships(ClinicalStatement clinicalStatement) {
        return (List)clinicalStatement.eGet(clinicalStatement.eClass().getEStructuralFeature("entryRelationship"));
    }

    public static void addAct(ClinicalStatement clinicalStatement, Act act) {
        EntryRelationship entryRelationship = CDAFactory.eINSTANCE.createEntryRelationship();
        entryRelationship.setAct(act);
        ClinicalStatementOperations.getEntryRelationships(clinicalStatement).add(entryRelationship);
    }

    public static void addEncounter(ClinicalStatement clinicalStatement, Encounter encounter) {
        EntryRelationship entryRelationship = CDAFactory.eINSTANCE.createEntryRelationship();
        entryRelationship.setEncounter(encounter);
        ClinicalStatementOperations.getEntryRelationships(clinicalStatement).add(entryRelationship);
    }

    public static void addObservation(ClinicalStatement clinicalStatement, Observation observation) {
        EntryRelationship entryRelationship = CDAFactory.eINSTANCE.createEntryRelationship();
        entryRelationship.setObservation(observation);
        ClinicalStatementOperations.getEntryRelationships(clinicalStatement).add(entryRelationship);
    }

    public static void addObservationMedia(ClinicalStatement clinicalStatement, ObservationMedia observationMedia) {
        EntryRelationship entryRelationship = CDAFactory.eINSTANCE.createEntryRelationship();
        entryRelationship.setObservationMedia(observationMedia);
        ClinicalStatementOperations.getEntryRelationships(clinicalStatement).add(entryRelationship);
    }

    public static void addOrganizer(ClinicalStatement clinicalStatement, Organizer organizer) {
        EntryRelationship entryRelationship = CDAFactory.eINSTANCE.createEntryRelationship();
        entryRelationship.setOrganizer(organizer);
        ClinicalStatementOperations.getEntryRelationships(clinicalStatement).add(entryRelationship);
    }

    public static void addProcedure(ClinicalStatement clinicalStatement, Procedure procedure) {
        EntryRelationship entryRelationship = CDAFactory.eINSTANCE.createEntryRelationship();
        entryRelationship.setProcedure(procedure);
        ClinicalStatementOperations.getEntryRelationships(clinicalStatement).add(entryRelationship);
    }

    public static void addRegionOfInterest(ClinicalStatement clinicalStatement, RegionOfInterest regionOfInterest) {
        EntryRelationship entryRelationship = CDAFactory.eINSTANCE.createEntryRelationship();
        entryRelationship.setRegionOfInterest(regionOfInterest);
        ClinicalStatementOperations.getEntryRelationships(clinicalStatement).add(entryRelationship);
    }

    public static void addSubstanceAdministration(ClinicalStatement clinicalStatement, SubstanceAdministration substanceAdministration) {
        EntryRelationship entryRelationship = CDAFactory.eINSTANCE.createEntryRelationship();
        entryRelationship.setSubstanceAdministration(substanceAdministration);
        ClinicalStatementOperations.getEntryRelationships(clinicalStatement).add(entryRelationship);
    }

    public static void addSupply(ClinicalStatement clinicalStatement, Supply supply) {
        EntryRelationship entryRelationship = CDAFactory.eINSTANCE.createEntryRelationship();
        entryRelationship.setSupply(supply);
        ClinicalStatementOperations.getEntryRelationships(clinicalStatement).add(entryRelationship);
    }

    public static EList<Act> getActs(ClinicalStatement clinicalStatement) {
        ArrayList<Act> acts = new ArrayList<Act>();
        for (EntryRelationship entryRelationship : ClinicalStatementOperations.getEntryRelationships(clinicalStatement)) {
            if (entryRelationship.getAct() == null) continue;
            acts.add(entryRelationship.getAct());
        }
        return new BasicEList.UnmodifiableEList(acts.size(), acts.toArray());
    }

    public static ClinicalDocument getClinicalDocument(ClinicalStatement clinicalStatement) {
        return CDAUtil.getClinicalDocument((EObject)clinicalStatement);
    }

    public static EList<Encounter> getEncounters(ClinicalStatement clinicalStatement) {
        ArrayList<Encounter> encounters = new ArrayList<Encounter>();
        for (EntryRelationship entryRelationship : ClinicalStatementOperations.getEntryRelationships(clinicalStatement)) {
            if (entryRelationship.getEncounter() == null) continue;
            encounters.add(entryRelationship.getEncounter());
        }
        return new BasicEList.UnmodifiableEList(encounters.size(), encounters.toArray());
    }

    public static EList<ClinicalStatement> getEntryRelationshipTargets(ClinicalStatement clinicalStatement, x_ActRelationshipEntryRelationship typeCode, Object targetClass) {
        if (targetClass != null && !(targetClass instanceof EClass)) {
            throw new IllegalArgumentException("targetClass must be an EClass");
        }
        return CDAUtil.getEntryRelationshipTargets(clinicalStatement, typeCode, (EClass)targetClass);
    }

    public static EList<ClinicalStatement> getEntryRelationshipTargets(ClinicalStatement clinicalStatement, Object targetClass) {
        return ClinicalStatementOperations.getEntryRelationshipTargets(clinicalStatement, null, targetClass);
    }

    public static EList<Observation> getObservations(ClinicalStatement clinicalStatement) {
        ArrayList<Observation> observations = new ArrayList<Observation>();
        for (EntryRelationship entryRelationship : ClinicalStatementOperations.getEntryRelationships(clinicalStatement)) {
            if (entryRelationship.getObservation() == null) continue;
            observations.add(entryRelationship.getObservation());
        }
        return new BasicEList.UnmodifiableEList(observations.size(), observations.toArray());
    }

    public static EList<ObservationMedia> getObservationMedia(ClinicalStatement clinicalStatement) {
        ArrayList<ObservationMedia> observationMedia = new ArrayList<ObservationMedia>();
        for (EntryRelationship entryRelationship : ClinicalStatementOperations.getEntryRelationships(clinicalStatement)) {
            if (entryRelationship.getObservationMedia() == null) continue;
            observationMedia.add(entryRelationship.getObservationMedia());
        }
        return new BasicEList.UnmodifiableEList(observationMedia.size(), observationMedia.toArray());
    }

    public static EList<Organizer> getOrganizers(ClinicalStatement clinicalStatement) {
        ArrayList<Organizer> organizers = new ArrayList<Organizer>();
        for (EntryRelationship entryRelationship : ClinicalStatementOperations.getEntryRelationships(clinicalStatement)) {
            if (entryRelationship.getOrganizer() == null) continue;
            organizers.add(entryRelationship.getOrganizer());
        }
        return new BasicEList.UnmodifiableEList(organizers.size(), organizers.toArray());
    }

    public static EList<Procedure> getProcedures(ClinicalStatement clinicalStatement) {
        ArrayList<Procedure> procedures = new ArrayList<Procedure>();
        for (EntryRelationship entryRelationship : ClinicalStatementOperations.getEntryRelationships(clinicalStatement)) {
            if (entryRelationship.getProcedure() == null) continue;
            procedures.add(entryRelationship.getProcedure());
        }
        return new BasicEList.UnmodifiableEList(procedures.size(), procedures.toArray());
    }

    public static EList<RegionOfInterest> getRegionsOfInterest(ClinicalStatement clinicalStatement) {
        ArrayList<RegionOfInterest> regionsOfInterest = new ArrayList<RegionOfInterest>();
        for (EntryRelationship entryRelationship : ClinicalStatementOperations.getEntryRelationships(clinicalStatement)) {
            if (entryRelationship.getRegionOfInterest() == null) continue;
            regionsOfInterest.add(entryRelationship.getRegionOfInterest());
        }
        return new BasicEList.UnmodifiableEList(regionsOfInterest.size(), regionsOfInterest.toArray());
    }

    public static Section getSection(ClinicalStatement clinicalStatement) {
        return CDAUtil.getSection((EObject)clinicalStatement);
    }

    public static EList<SubstanceAdministration> getSubstanceAdministrations(ClinicalStatement clinicalStatement) {
        ArrayList<SubstanceAdministration> substanceAdministrations = new ArrayList<SubstanceAdministration>();
        for (EntryRelationship entryRelationship : ClinicalStatementOperations.getEntryRelationships(clinicalStatement)) {
            if (entryRelationship.getSubstanceAdministration() == null) continue;
            substanceAdministrations.add(entryRelationship.getSubstanceAdministration());
        }
        return new BasicEList.UnmodifiableEList(substanceAdministrations.size(), substanceAdministrations.toArray());
    }

    public static EList<Supply> getSupplies(ClinicalStatement clinicalStatement) {
        ArrayList<Supply> supplies = new ArrayList<Supply>();
        for (EntryRelationship entryRelationship : ClinicalStatementOperations.getEntryRelationships(clinicalStatement)) {
            if (entryRelationship.getSupply() == null) continue;
            supplies.add(entryRelationship.getSupply());
        }
        return new BasicEList.UnmodifiableEList(supplies.size(), supplies.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasActTemplate(ClinicalStatement clinicalStatement, String templateId) {
        if (HAS_ACT_TEMPLATE__STRING__EOCL_QRY.get() == null) {
            ThreadLocal<OCL> threadLocal = EOCL_ENV;
            synchronized (threadLocal) {
                OCL.Helper helper = EOCL_ENV.get().createOCLHelper();
                helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_STATEMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_STATEMENT.getEAllOperations().get(38)));
                try {
                    HAS_ACT_TEMPLATE__STRING__EOCL_QRY.set((OCLExpression<EClassifier>)helper.createQuery(HAS_ACT_TEMPLATE__STRING__EOCL_EXP));
                }
                catch (ParserException pe) {
                    throw new UnsupportedOperationException(pe.getLocalizedMessage());
                }
            }
        }
        OCL.Query query = EOCL_ENV.get().createQuery(HAS_ACT_TEMPLATE__STRING__EOCL_QRY.get());
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("templateId", (Object)templateId);
        return (Boolean)query.evaluate((Object)clinicalStatement);
    }

    public static boolean hasCode(ClinicalStatement clinicalStatement, String code, String codeSystem, String codeSystemName) {
        CD cd = (CD)clinicalStatement.eGet(clinicalStatement.eClass().getEStructuralFeature("code"));
        if (cd == null || code == null || codeSystem == null || codeSystemName == null) {
            return false;
        }
        return code.equals(cd.getCode()) && codeSystem.equals(cd.getCodeSystem()) && codeSystemName.equals(cd.getCodeSystemName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasEncounterTemplate(ClinicalStatement clinicalStatement, String templateId) {
        if (HAS_ENCOUNTER_TEMPLATE__STRING__EOCL_QRY.get() == null) {
            ThreadLocal<OCL> threadLocal = EOCL_ENV;
            synchronized (threadLocal) {
                OCL.Helper helper = EOCL_ENV.get().createOCLHelper();
                helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_STATEMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_STATEMENT.getEAllOperations().get(40)));
                try {
                    HAS_ENCOUNTER_TEMPLATE__STRING__EOCL_QRY.set((OCLExpression<EClassifier>)helper.createQuery(HAS_ENCOUNTER_TEMPLATE__STRING__EOCL_EXP));
                }
                catch (ParserException pe) {
                    throw new UnsupportedOperationException(pe.getLocalizedMessage());
                }
            }
        }
        OCL.Query query = EOCL_ENV.get().createQuery(HAS_ENCOUNTER_TEMPLATE__STRING__EOCL_QRY.get());
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("templateId", (Object)templateId);
        return (Boolean)query.evaluate((Object)clinicalStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasObservationMediaTemplate(ClinicalStatement clinicalStatement, String templateId) {
        if (HAS_OBSERVATION_MEDIA_TEMPLATE__STRING__EOCL_QRY.get() == null) {
            ThreadLocal<OCL> threadLocal = EOCL_ENV;
            synchronized (threadLocal) {
                OCL.Helper helper = EOCL_ENV.get().createOCLHelper();
                helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_STATEMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_STATEMENT.getEAllOperations().get(41)));
                try {
                    HAS_OBSERVATION_MEDIA_TEMPLATE__STRING__EOCL_QRY.set((OCLExpression<EClassifier>)helper.createQuery(HAS_OBSERVATION_MEDIA_TEMPLATE__STRING__EOCL_EXP));
                }
                catch (ParserException pe) {
                    throw new UnsupportedOperationException(pe.getLocalizedMessage());
                }
            }
        }
        OCL.Query query = EOCL_ENV.get().createQuery(HAS_OBSERVATION_MEDIA_TEMPLATE__STRING__EOCL_QRY.get());
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("templateId", (Object)templateId);
        return (Boolean)query.evaluate((Object)clinicalStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasObservationTemplate(ClinicalStatement clinicalStatement, String templateId) {
        if (HAS_OBSERVATION_TEMPLATE__STRING__EOCL_QRY.get() == null) {
            ThreadLocal<OCL> threadLocal = EOCL_ENV;
            synchronized (threadLocal) {
                OCL.Helper helper = EOCL_ENV.get().createOCLHelper();
                helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_STATEMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_STATEMENT.getEAllOperations().get(42)));
                try {
                    HAS_OBSERVATION_TEMPLATE__STRING__EOCL_QRY.set((OCLExpression<EClassifier>)helper.createQuery(HAS_OBSERVATION_TEMPLATE__STRING__EOCL_EXP));
                }
                catch (ParserException pe) {
                    throw new UnsupportedOperationException(pe.getLocalizedMessage());
                }
            }
        }
        OCL.Query query = EOCL_ENV.get().createQuery(HAS_OBSERVATION_TEMPLATE__STRING__EOCL_QRY.get());
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("templateId", (Object)templateId);
        return (Boolean)query.evaluate((Object)clinicalStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasOrganizerTemplate(ClinicalStatement clinicalStatement, String templateId) {
        if (HAS_ORGANIZER_TEMPLATE__STRING__EOCL_QRY.get() == null) {
            ThreadLocal<OCL> threadLocal = EOCL_ENV;
            synchronized (threadLocal) {
                OCL.Helper helper = EOCL_ENV.get().createOCLHelper();
                helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_STATEMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_STATEMENT.getEAllOperations().get(43)));
                try {
                    HAS_ORGANIZER_TEMPLATE__STRING__EOCL_QRY.set((OCLExpression<EClassifier>)helper.createQuery(HAS_ORGANIZER_TEMPLATE__STRING__EOCL_EXP));
                }
                catch (ParserException pe) {
                    throw new UnsupportedOperationException(pe.getLocalizedMessage());
                }
            }
        }
        OCL.Query query = EOCL_ENV.get().createQuery(HAS_ORGANIZER_TEMPLATE__STRING__EOCL_QRY.get());
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("templateId", (Object)templateId);
        return (Boolean)query.evaluate((Object)clinicalStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasProcedureTemplate(ClinicalStatement clinicalStatement, String templateId) {
        if (HAS_PROCEDURE_TEMPLATE__STRING__EOCL_QRY.get() == null) {
            ThreadLocal<OCL> threadLocal = EOCL_ENV;
            synchronized (threadLocal) {
                OCL.Helper helper = EOCL_ENV.get().createOCLHelper();
                helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_STATEMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_STATEMENT.getEAllOperations().get(44)));
                try {
                    HAS_PROCEDURE_TEMPLATE__STRING__EOCL_QRY.set((OCLExpression<EClassifier>)helper.createQuery(HAS_PROCEDURE_TEMPLATE__STRING__EOCL_EXP));
                }
                catch (ParserException pe) {
                    throw new UnsupportedOperationException(pe.getLocalizedMessage());
                }
            }
        }
        OCL.Query query = EOCL_ENV.get().createQuery(HAS_PROCEDURE_TEMPLATE__STRING__EOCL_QRY.get());
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("templateId", (Object)templateId);
        return (Boolean)query.evaluate((Object)clinicalStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasRegionOfInterestTemplate(ClinicalStatement clinicalStatement, String templateId) {
        if (HAS_REGION_OF_INTEREST_TEMPLATE__STRING__EOCL_QRY.get() == null) {
            ThreadLocal<OCL> threadLocal = EOCL_ENV;
            synchronized (threadLocal) {
                OCL.Helper helper = EOCL_ENV.get().createOCLHelper();
                helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_STATEMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_STATEMENT.getEAllOperations().get(45)));
                try {
                    HAS_REGION_OF_INTEREST_TEMPLATE__STRING__EOCL_QRY.set((OCLExpression<EClassifier>)helper.createQuery(HAS_REGION_OF_INTEREST_TEMPLATE__STRING__EOCL_EXP));
                }
                catch (ParserException pe) {
                    throw new UnsupportedOperationException(pe.getLocalizedMessage());
                }
            }
        }
        OCL.Query query = EOCL_ENV.get().createQuery(HAS_REGION_OF_INTEREST_TEMPLATE__STRING__EOCL_QRY.get());
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("templateId", (Object)templateId);
        return (Boolean)query.evaluate((Object)clinicalStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasSubstanceAdministrationTemplate(ClinicalStatement clinicalStatement, String templateId) {
        if (HAS_SUBSTANCE_ADMINISTRATION_TEMPLATE__STRING__EOCL_QRY.get() == null) {
            ThreadLocal<OCL> threadLocal = EOCL_ENV;
            synchronized (threadLocal) {
                OCL.Helper helper = EOCL_ENV.get().createOCLHelper();
                helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_STATEMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_STATEMENT.getEAllOperations().get(46)));
                try {
                    HAS_SUBSTANCE_ADMINISTRATION_TEMPLATE__STRING__EOCL_QRY.set((OCLExpression<EClassifier>)helper.createQuery(HAS_SUBSTANCE_ADMINISTRATION_TEMPLATE__STRING__EOCL_EXP));
                }
                catch (ParserException pe) {
                    throw new UnsupportedOperationException(pe.getLocalizedMessage());
                }
            }
        }
        OCL.Query query = EOCL_ENV.get().createQuery(HAS_SUBSTANCE_ADMINISTRATION_TEMPLATE__STRING__EOCL_QRY.get());
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("templateId", (Object)templateId);
        return (Boolean)query.evaluate((Object)clinicalStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasSupplyTemplate(ClinicalStatement clinicalStatement, String templateId) {
        if (HAS_SUPPLY_TEMPLATE__STRING__EOCL_QRY.get() == null) {
            ThreadLocal<OCL> threadLocal = EOCL_ENV;
            synchronized (threadLocal) {
                OCL.Helper helper = EOCL_ENV.get().createOCLHelper();
                helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_STATEMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_STATEMENT.getEAllOperations().get(47)));
                try {
                    HAS_SUPPLY_TEMPLATE__STRING__EOCL_QRY.set((OCLExpression<EClassifier>)helper.createQuery(HAS_SUPPLY_TEMPLATE__STRING__EOCL_EXP));
                }
                catch (ParserException pe) {
                    throw new UnsupportedOperationException(pe.getLocalizedMessage());
                }
            }
        }
        OCL.Query query = EOCL_ENV.get().createQuery(HAS_SUPPLY_TEMPLATE__STRING__EOCL_QRY.get());
        EvaluationEnvironment environment = query.getEvaluationEnvironment();
        environment.add("templateId", (Object)templateId);
        return (Boolean)query.evaluate((Object)clinicalStatement);
    }

    public static boolean hasTemplateId(ClinicalStatement clinicalStatement, String templateId) {
        for (II ii : (List)clinicalStatement.eGet(clinicalStatement.eClass().getEStructuralFeature("templateId"))) {
            if (!templateId.equals(ii.getRoot())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EList<ParticipantRole> getParticipantRoles(ClinicalStatement clinicalStatement) {
        if (GET_PARTICIPANT_ROLES__EOCL_QRY.get() == null) {
            ThreadLocal<OCL> threadLocal = EOCL_ENV;
            synchronized (threadLocal) {
                OCL.Helper helper = EOCL_ENV.get().createOCLHelper();
                helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_STATEMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_STATEMENT.getEAllOperations().get(49)));
                try {
                    GET_PARTICIPANT_ROLES__EOCL_QRY.set((OCLExpression<EClassifier>)helper.createQuery(GET_PARTICIPANT_ROLES__EOCL_EXP));
                }
                catch (ParserException pe) {
                    throw new UnsupportedOperationException(pe.getLocalizedMessage());
                }
            }
        }
        OCL.Query query = EOCL_ENV.get().createQuery(GET_PARTICIPANT_ROLES__EOCL_QRY.get());
        Collection result = (Collection)query.evaluate((Object)clinicalStatement);
        return new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EList<AssignedEntity> getAssignedEntities(ClinicalStatement clinicalStatement) {
        if (GET_ASSIGNED_ENTITIES__EOCL_QRY.get() == null) {
            ThreadLocal<OCL> threadLocal = EOCL_ENV;
            synchronized (threadLocal) {
                OCL.Helper helper = EOCL_ENV.get().createOCLHelper();
                helper.setOperationContext((Object)CDAPackage.Literals.CLINICAL_STATEMENT, (Object)((EOperation)CDAPackage.Literals.CLINICAL_STATEMENT.getEAllOperations().get(50)));
                try {
                    GET_ASSIGNED_ENTITIES__EOCL_QRY.set((OCLExpression<EClassifier>)helper.createQuery(GET_ASSIGNED_ENTITIES__EOCL_EXP));
                }
                catch (ParserException pe) {
                    throw new UnsupportedOperationException(pe.getLocalizedMessage());
                }
            }
        }
        OCL.Query query = EOCL_ENV.get().createQuery(GET_ASSIGNED_ENTITIES__EOCL_QRY.get());
        Collection result = (Collection)query.evaluate((Object)clinicalStatement);
        return new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }
}

