/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mdht.uml.cda.core.util.CDAModelConsolidator;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.transform.EcoreTransformUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.TransformAbstract;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public abstract class TransformFacade
extends TransformAbstract {
    protected CDAModelConsolidator consolidator;

    public TransformFacade(TransformerOptions options, CDAModelConsolidator consolidator, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
        this.consolidator = consolidator;
    }

    private Package initializeDomainPackageFrom(Element element) {
        Package modelPkg = element.getNearestPackage();
        Package domainPkg = null;
        if (this.transformerOptions.getDomainModelPath() == null) {
            domainPkg = modelPkg.getNestedPackage("domain");
            if (domainPkg == null) {
                domainPkg = modelPkg.createNestedPackage("domain");
            }
        } else {
            URI domainModelURI = URI.createFileURI((String)this.transformerOptions.getDomainModelPath());
            Resource domainResource = element.eResource().getResourceSet().createResource(domainModelURI);
            if (domainResource.getContents().isEmpty() || !(domainResource.getContents().get(0) instanceof Package)) {
                domainPkg = UMLFactory.eINSTANCE.createPackage();
                domainResource.getContents().add((Object)domainPkg);
                Stereotype ePackage = EcoreTransformUtil.getEcoreStereotype((EObject)modelPkg, (String)"EPackage");
                UMLUtil.safeApplyStereotype((Element)domainPkg, (Stereotype)ePackage);
                domainPkg.setValue(ePackage, "nsPrefix", (Object)"domain");
                domainPkg.setValue(ePackage, "prefix", (Object)"Domain");
                String domainPackageName = this.transformerOptions.getDomainPackageName();
                String domainBasePackage = this.transformerOptions.getDomainBasePackage();
                String domainNsURI = this.transformerOptions.getDomainNsURI();
                String modelPackageName = null;
                String modelNsURI = null;
                String modelBasePackage = null;
                Stereotype modelCodeGen = CDAProfileUtil.getAppliedCDAStereotype((Element)modelPkg, (String)"CodegenSupport");
                if (modelCodeGen != null) {
                    modelPackageName = (String)modelPkg.getValue(modelCodeGen, "packageName");
                    modelNsURI = (String)modelPkg.getValue(modelCodeGen, "nsURI");
                    modelBasePackage = (String)modelPkg.getValue(modelCodeGen, "basePackage");
                }
                if (domainPackageName != null) {
                    domainPkg.setName(domainPackageName);
                    domainPkg.setValue(ePackage, "packageName", (Object)domainPackageName);
                } else {
                    domainPkg.setName("domain");
                    domainPkg.setValue(ePackage, "packageName", (Object)"domain");
                }
                if (domainBasePackage != null) {
                    domainPkg.setValue(ePackage, "basePackage", (Object)domainBasePackage);
                } else if (modelBasePackage != null && modelPackageName != null) {
                    domainPkg.setValue(ePackage, "basePackage", (Object)(String.valueOf(modelBasePackage) + "." + modelPackageName));
                }
                if (domainNsURI != null) {
                    domainPkg.setValue(ePackage, "nsURI", (Object)domainNsURI);
                } else if (modelNsURI != null) {
                    domainPkg.setValue(ePackage, "nsURI", (Object)(String.valueOf(modelNsURI) + "/domain"));
                }
            } else {
                domainPkg = (Package)domainResource.getContents().get(0);
            }
        }
        return domainPkg;
    }

    protected Package getDomainInterfacePackage(Element element) {
        Package domainPkg = this.transformerOptions.getDomainInterfacePackage();
        if (domainPkg == null) {
            domainPkg = this.initializeDomainPackageFrom(element);
            this.transformerOptions.setDomainInterfacePackage(domainPkg);
        }
        return domainPkg;
    }

    protected Classifier getDomainInterface(Type modelType) {
        String classifierName = TransformFacade.normalizeCodeName((String)modelType.getName());
        if (this.transformerOptions.isUseBusinessNames()) {
            classifierName = TransformFacade.normalizeCodeName((String)modelType.getLabel(false));
        }
        Package domainPkg = this.getDomainInterfacePackage((Element)modelType);
        Object domainInterface = this.transformerOptions.isGenerateDomainInterface() ? (Interface)domainPkg.getOwnedType(classifierName, false, UMLPackage.eINSTANCE.getInterface(), true) : (Class)domainPkg.getOwnedType(classifierName, false, UMLPackage.eINSTANCE.getClass_(), true);
        if (this.consolidator != null && modelType instanceof Classifier && !this.consolidator.getProcessedClassifiers().contains(modelType)) {
            this.consolidator.addImportedClassifier((Classifier)modelType);
        }
        return domainInterface;
    }
}

