/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.uml.cda.core.profile.LogicalConstraint;
import org.eclipse.mdht.uml.cda.core.profile.util.CDASwitch;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.transform.internal.Logger;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.transform.EcoreTransformUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.IEcoreProfileReflection;
import org.eclipse.mdht.uml.transform.ecore.TransformConstraint;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class TransformLogicalConstraint
extends TransformConstraint {
    TransformSwitch transformSwitch = null;

    private Stereotype getAssociationStereotype(Association association, Class sourceClass, Class targetClass) {
        Stereotype result = null;
        if (CDAModelUtil.isSection((Type)sourceClass) && (CDAModelUtil.isClinicalStatement((Type)targetClass) || CDAModelUtil.isEntry((Type)targetClass))) {
            result = CDAProfileUtil.getAppliedCDAStereotype((Element)association, (String)"Entry");
        } else if (CDAModelUtil.isClinicalStatement((Type)sourceClass) && CDAModelUtil.isClinicalStatement((Type)targetClass) && !CDAModelUtil.isOrganizer((Type)sourceClass)) {
            result = CDAProfileUtil.getAppliedCDAStereotype((Element)association, (String)"EntryRelationship");
        }
        return result;
    }

    protected boolean appendAssociationStereotypeConditions(StringBuilder constraintBody, Association association, String associationEnd, Class sourceClass, Class targetClass) {
        boolean result = false;
        Stereotype stereotype = this.getAssociationStereotype(association, sourceClass, targetClass);
        if (stereotype != null) {
            Object value = association.getValue(stereotype, "typeCode");
            String typeCode = null;
            if (value instanceof EnumerationLiteral) {
                typeCode = ((EnumerationLiteral)value).getName();
            } else if (value instanceof Enumerator) {
                typeCode = ((Enumerator)value).getName();
            }
            if (typeCode != null) {
                String enumerationQName = CDAModelUtil.isSection((Type)sourceClass) ? "vocab::x_ActRelationshipEntry" : "vocab::x_ActRelationshipEntryRelationship";
                constraintBody.append(" and " + associationEnd + ".typeCode = " + enumerationQName + "::" + typeCode);
            }
            result = true;
        }
        return result;
    }

    public String getConstraintTargetQualifiedName(Class constraintTarget) {
        String retVal = constraintTarget.getQualifiedName().replace(constraintTarget.getName(), UML2Util.getValidJavaIdentifier((String)constraintTarget.getName()));
        String[] arrStr = retVal.split("::");
        if (arrStr.length > 2) {
            retVal = ((Class)this.getBaseClass((Classifier)constraintTarget)).getQualifiedName();
        }
        return retVal;
    }

    protected boolean isImplicitAssociation(Property sourceProperty, Class sourceClass, Class targetClass) {
        return CDAModelUtil.isEntry((Type)targetClass);
    }

    protected boolean handleSpecialAssociation(StringBuilder constraintBody, StringBuilder operationBody, Property sourceProperty, Class sourceClass, Class targetClass, String constraintTargetQName) {
        boolean result = false;
        if ((CDAModelUtil.isClinicalDocument((Type)sourceClass) || CDAModelUtil.isSection((Type)sourceClass)) && CDAModelUtil.isSection((Type)targetClass)) {
            constraintBody.append("self.getAllSections()->");
            constraintBody.append(sourceProperty.getUpper() == 1 ? "one(" : "exists(");
            constraintBody.append("section : cda::Section | not section.oclIsUndefined() and section.oclIsKindOf(" + constraintTargetQName + "))");
            operationBody.append(constraintBody.toString().replace("one", "select").replace("exists", "select"));
            result = true;
        }
        return result;
    }

    protected boolean getAssociationEndAndIteratorDeclaration(Property sourceProperty, Class sourceClass, Class baseSourceClass, Class targetClass, Class baseTargetClass, String[] associationEndOut, String[] variableDeclarationOut) {
        boolean result = false;
        if (CDAModelUtil.isSection((Type)sourceClass) && (CDAModelUtil.isClinicalStatement((Type)targetClass) || CDAModelUtil.isEntry((Type)targetClass))) {
            associationEndOut[0] = "entry";
            variableDeclarationOut[0] = "entry : cda::Entry";
        } else if (CDAModelUtil.isOrganizer((Type)sourceClass) && CDAModelUtil.isClinicalStatement((Type)targetClass)) {
            associationEndOut[0] = "component";
            variableDeclarationOut[0] = "component : cda::Component4";
        } else if (CDAModelUtil.isClinicalStatement((Type)sourceClass) && CDAModelUtil.isClinicalStatement((Type)targetClass)) {
            associationEndOut[0] = "entryRelationship";
            variableDeclarationOut[0] = "entryRelationship : cda::EntryRelationship";
        } else if (CDAModelUtil.isClinicalStatement((Type)sourceClass) && "ParticipantRole".equals(baseTargetClass.getName())) {
            associationEndOut[0] = "participant";
            variableDeclarationOut[0] = "participant : cda::Participant2";
        } else if (CDAModelUtil.isClinicalStatement((Type)sourceClass) && "AssignedEntity".equals(baseTargetClass.getName())) {
            associationEndOut[0] = "performer";
            variableDeclarationOut[0] = "performer : cda::Performer2";
        } else {
            Property property = baseSourceClass.getOwnedAttribute(null, (Type)targetClass, true, null, false);
            if (property == null) {
                for (Classifier c : targetClass.allParents()) {
                    property = baseSourceClass.getOwnedAttribute(null, (Type)c, true, null, false);
                    if (property != null || this.isBaseModel((Element)targetClass, (Element)c)) break;
                }
            }
            if (property == null) {
                property = baseSourceClass.getOwnedAttribute(sourceProperty.getName(), null, true, null, false);
            }
            if (property != null) {
                associationEndOut[0] = property.getName();
                variableDeclarationOut[0] = String.valueOf(property.getName()) + " : cda::" + property.getType().getName();
                result = true;
            }
        }
        return result;
    }

    public String generateAssociationOCL(Association association) {
        IEcoreProfileReflection.ValidationSeverityKind severity;
        if (this.isRemoved((Element)association)) {
            return null;
        }
        boolean firstOrderAssociation = false;
        Class sourceClass = null;
        Class targetClass = null;
        Property sourceProperty = null;
        for (Property property : association.getMemberEnds()) {
            if (!property.isNavigable()) continue;
            sourceClass = property.getClass_();
            if (!(property.getType() instanceof Class)) break;
            targetClass = (Class)property.getType();
            sourceProperty = property;
            break;
        }
        if (sourceClass == null || targetClass == null || sourceProperty == null) {
            return null;
        }
        Class baseSourceClass = (Class)this.getBaseClass((Classifier)sourceClass);
        Class baseTargetClass = (Class)this.getBaseClass((Classifier)targetClass);
        if (baseSourceClass == null || baseTargetClass == null) {
            String message = "Unsupported association: " + sourceClass.getQualifiedName() + " -> " + sourceProperty.getType().getQualifiedName();
            Logger.log(4, message);
            return null;
        }
        Class constraintTarget = targetClass;
        ArrayList parents = new ArrayList(targetClass.getGenerals());
        while (!parents.isEmpty() && !this.getEcoreProfile().isPrimaryEClass(constraintTarget)) {
            if (!(parents.get(0) instanceof Class)) continue;
            constraintTarget = (Class)parents.remove(0);
        }
        if (!this.getEcoreProfile().isPrimaryEClass(constraintTarget) && CDAModelUtil.isInlineClass((Class)constraintTarget)) {
            for (Classifier next : constraintTarget.allParents()) {
                if (!(next instanceof Class) || CDAModelUtil.isInlineClass((Class)((Class)next))) continue;
                constraintTarget = (Class)next;
                break;
            }
        }
        String baseTargetName = baseTargetClass.getName();
        String baseTargetLowerName = String.valueOf(baseTargetName.substring(0, 1).toLowerCase()) + baseTargetName.substring(1);
        String baseTargetQName = baseTargetClass.getQualifiedName();
        StringBuilder constraintBody = new StringBuilder();
        StringBuilder operationBody = new StringBuilder();
        String constraintTargetQName = this.getConstraintTargetQualifiedName(constraintTarget);
        if (!this.handleSpecialAssociation(constraintBody, operationBody, sourceProperty, sourceClass, targetClass, constraintTargetQName)) {
            String range;
            String comparator;
            boolean exists;
            String[] associationEndOut = new String[1];
            String[] variableDeclarationOut = new String[1];
            if (this.getAssociationEndAndIteratorDeclaration(sourceProperty, sourceClass, baseSourceClass, targetClass, baseTargetClass, associationEndOut, variableDeclarationOut)) {
                firstOrderAssociation = true;
            }
            String associationEnd = associationEndOut[0];
            String variableDeclaration = variableDeclarationOut[0];
            if (associationEnd == null || variableDeclaration == null) {
                String message = "Unsupported association: " + sourceClass.getQualifiedName() + " -> " + targetClass.getQualifiedName();
                Logger.log(4, message);
                return null;
            }
            String selector = !CDAModelUtil.isInlineClass((Class)targetClass) ? null : this.getInlineFilter(targetClass);
            int upper = sourceProperty.upperBound();
            boolean isEmpty = upper == 0;
            int lower = isEmpty ? 0 : Math.max(1, sourceProperty.getLower());
            boolean one = (selector == null || selector.length() == 0) && upper == 1;
            boolean notEmpty = lower == 1 && upper == -1;
            boolean bl = exists = notEmpty && (selector == null || selector.length() == 0);
            if (one || exists || isEmpty || notEmpty) {
                comparator = null;
                range = null;
            } else if (upper == lower) {
                comparator = " = " + lower;
                range = null;
            } else if (upper > lower) {
                range = String.format("%s..%s", lower, upper);
                comparator = null;
            } else {
                comparator = " >= " + lower;
                range = null;
            }
            if (range != null) {
                constraintBody.append(range).append("->includes(");
            }
            constraintBody.append("self." + associationEnd + "->");
            constraintBody.append(one ? "one(" : (exists ? "exists(" : "select("));
            constraintBody.append(variableDeclaration);
            constraintBody.append(" | ");
            String reference = associationEnd;
            if (!firstOrderAssociation && !this.isImplicitAssociation(sourceProperty, sourceClass, targetClass)) {
                reference = String.valueOf(reference) + "." + baseTargetLowerName;
            }
            constraintBody.append("not " + reference + ".oclIsUndefined() and ");
            constraintBody.append(String.valueOf(reference) + ".oclIsKindOf(" + constraintTargetQName + ")");
            this.appendAssociationStereotypeConditions(constraintBody, association, associationEnd, sourceClass, targetClass);
            constraintBody.append(")");
            if (selector != null && selector.length() > 0) {
                constraintBody.append(selector);
            }
            if (isEmpty) {
                constraintBody.append("->isEmpty()");
            } else if (!one && !exists) {
                if (notEmpty) {
                    constraintBody.append("->notEmpty()");
                } else {
                    constraintBody.append("->size()");
                    if (range != null) {
                        constraintBody.append(")");
                    } else {
                        constraintBody.append(comparator);
                    }
                }
            }
            operationBody.append("self.get" + TransformLogicalConstraint.pluralize((String)baseTargetName) + "()->select(");
            operationBody.append(String.valueOf(baseTargetLowerName) + " : " + baseTargetQName + " | ");
            operationBody.append("not " + baseTargetLowerName + ".oclIsUndefined() and ");
            operationBody.append(String.valueOf(baseTargetLowerName) + ".oclIsKindOf(" + constraintTargetQName + "))");
        }
        if ((severity = this.getEcoreProfile().getValidationSeverity((Element)association, IEcoreProfileReflection.ValidationStereotypeKind.ANY)) != null) {
            String constraintName = this.createConstraintName((NamedElement)sourceProperty);
            Constraint constraint = sourceClass.createOwnedRule(constraintName, UMLPackage.eINSTANCE.getConstraint());
            constraint.getConstrainedElements().add((Object)sourceClass);
            OpaqueExpression expression = (OpaqueExpression)constraint.createSpecification(null, null, UMLPackage.eINSTANCE.getOpaqueExpression());
            expression.getLanguages().add((Object)"OCL");
            expression.getBodies().add((Object)constraintBody.toString());
            String validationMessage = this.getEcoreProfile().getValidationMessage((Element)association, IEcoreProfileReflection.ValidationStereotypeKind.ANY);
            if (severity == IEcoreProfileReflection.ValidationSeverityKind.INFO) {
                this.addValidationInfo(sourceClass, constraintName, validationMessage);
            } else if (severity == IEcoreProfileReflection.ValidationSeverityKind.WARNING) {
                this.addValidationWarning(sourceClass, constraintName, validationMessage);
            } else {
                this.addValidationError(sourceClass, constraintName, validationMessage);
            }
        }
        if (!(targetClass.getOwner() instanceof Class || firstOrderAssociation || this.transformerOptions.isGenerateDomainInterface())) {
            if (sourceProperty.getUpper() == 1) {
                operationBody.append("->asSequence()->any(true)");
            }
            operationBody.append(".oclAsType(" + constraintTargetQName + ")");
            String operationName = "get";
            if (!UMLUtil.getRedefinedProperties((Property)sourceProperty).isEmpty()) {
                operationName = String.valueOf(operationName) + this.getEcoreProfile().getModelPrefix((NamedElement)sourceProperty);
            }
            operationName = String.valueOf(operationName) + (sourceProperty.getUpper() == 1 ? TransformLogicalConstraint.capitalize((String)sourceProperty.getName()) : TransformLogicalConstraint.capitalize((String)TransformLogicalConstraint.pluralize((String)sourceProperty.getName())));
            Operation operation = sourceClass.createOwnedOperation(operationName, null, null, (Type)constraintTarget);
            operation.setIsQuery(true);
            operation.setUpper(sourceProperty.getUpper());
            Constraint bodyConstraint = operation.createBodyCondition("body");
            bodyConstraint.getConstrainedElements().add((Object)operation);
            OpaqueExpression bodyExpression = (OpaqueExpression)bodyConstraint.createSpecification(null, null, UMLPackage.eINSTANCE.getOpaqueExpression());
            bodyExpression.getLanguages().add((Object)"OCL");
            bodyExpression.getBodies().add((Object)operationBody.toString());
        }
        return constraintBody.toString();
    }

    private String getInlineFilter(Class targetClass) {
        return null;
    }

    private boolean isTypeString(Type type) {
        Stereotype eDataType = EcoreTransformUtil.getEcoreStereotype((EObject)type, (String)"EDataType");
        String instanceClassName = null;
        if (type.isStereotypeApplied(eDataType)) {
            instanceClassName = (String)type.getValue(eDataType, "instanceClassName");
        }
        return UMLUtil.isTypeString((Type)type) || "java.lang.String".equals(instanceClassName);
    }

    private Classifier getNormalizedType(Property property) {
        Classifier baseDatatype;
        Classifier result;
        Classifier classifier = result = property.getType() instanceof Classifier ? (Classifier)property.getType() : null;
        if (result != null && (baseDatatype = this.getBaseDatatype(result, (Element)property)) != null) {
            result = baseDatatype;
        }
        return result;
    }

    private boolean isEDType(Property property) {
        Classifier type = (Classifier)property.getType();
        if (type == null) {
            Property cdaProperty = this.getBaseProperty(property);
            if (cdaProperty != null) {
                type = (Classifier)cdaProperty.getType();
            } else {
                return false;
            }
        }
        ArrayList<Classifier> allTypes = new ArrayList<Classifier>((Collection<Classifier>)type.allParents());
        allTypes.add(0, type);
        for (Classifier classifier : allTypes) {
            if (!"datatypes::ED".equals(classifier.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private StringBuffer generateOCL(Property property) {
        IEcoreProfileReflection.ValidationSeverityKind severity;
        String value;
        Stereotype textValue;
        Class class_;
        Stereotype nullFlavor;
        String templateTypeQName;
        String message;
        StringBuffer body = new StringBuffer();
        Property cdaProperty = null;
        Property inheritedProperty = null;
        if (CDAModelUtil.isCDAModel((Element)property)) {
            cdaProperty = property;
            inheritedProperty = property;
        } else {
            cdaProperty = this.getBaseProperty(property);
            inheritedProperty = this.getInheritedProperty(property);
        }
        if (cdaProperty == null) {
            String message2 = "Cannot find CDA property for: " + property.getQualifiedName();
            Logger.log(4, message2);
            return body.append("aaaa");
        }
        if (inheritedProperty == null) {
            String message3 = "Cannot find inherited property for: " + property.getQualifiedName();
            Logger.log(4, message3);
            return body.append("bbbb");
        }
        if (inheritedProperty.getType() == null) {
            message = "Redefined property has no type: " + inheritedProperty.getQualifiedName();
            Logger.log(4, message);
        }
        if (property.getType() == null) {
            message = "Property has no type: " + property.getQualifiedName();
            Logger.log(2, message);
            return body.append("cccc");
        }
        Classifier inheritedPropertyType = this.getNormalizedType(inheritedProperty);
        Classifier propertyType = this.getNormalizedType(property);
        String selfName = "self." + cdaProperty.getName();
        String inheritedTypeQName = inheritedPropertyType.getQualifiedName();
        String string = templateTypeQName = propertyType == null ? inheritedTypeQName : propertyType.getQualifiedName();
        if (!inheritedPropertyType.conformsTo(cdaProperty.getType())) {
            templateTypeQName = inheritedTypeQName = cdaProperty.getType().getQualifiedName();
        } else if (propertyType != null && !propertyType.conformsTo((Type)inheritedPropertyType)) {
            if (!(propertyType instanceof Enumeration)) {
                String message4 = "Property type does not conform to redefined property type: " + property.getQualifiedName();
                Logger.log(4, message4);
            }
            templateTypeQName = inheritedTypeQName;
        }
        if (property.getUpper() != 0) {
            if (cdaProperty.getUpper() == 1) {
                if (propertyType instanceof Enumeration) {
                    body.append("isDefined('" + cdaProperty.getName() + "')");
                } else {
                    body.append("not " + selfName + ".oclIsUndefined()");
                }
            } else if (cdaProperty.getUpper() > 0 || cdaProperty.getUpper() == -1) {
                if (property.getUpper() == 1) {
                    body.append(String.valueOf(selfName) + "->size() = 1");
                } else {
                    body.append("not " + selfName + "->isEmpty()");
                }
            }
        }
        if (!templateTypeQName.equals(inheritedTypeQName)) {
            if (body.length() > 0) {
                body.append(" and ");
            }
            if (cdaProperty.getUpper() == 1) {
                body.append(String.valueOf(selfName) + ".oclIsTypeOf(" + templateTypeQName + ")");
            } else {
                body.append(String.valueOf(selfName) + "->forAll(element | element.oclIsTypeOf(" + templateTypeQName + "))");
            }
        }
        if ((propertyType instanceof Enumeration || propertyType instanceof PrimitiveType) && property.getDefault() != null && property.isReadOnly()) {
            if (body.length() > 0) {
                body.append(" and ");
            }
            if (propertyType instanceof Enumeration) {
                body.append(String.valueOf(selfName) + "=" + templateTypeQName + "::" + property.getDefault());
            } else if (this.isTypeString((Type)propertyType)) {
                body.append(String.valueOf(selfName) + "='" + property.getDefault() + "'");
            } else {
                body.append(String.valueOf(selfName) + "=" + property.getDefault());
            }
        }
        if ((nullFlavor = this.getEcoreProfile().getAppliedValidationStereotype((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.NULL_FLAVOR)) != null) {
            Object value2 = property.getValue(nullFlavor, "nullFlavor");
            String nullFlavorValue = null;
            if (value2 instanceof EnumerationLiteral) {
                nullFlavorValue = ((EnumerationLiteral)value2).getName();
            } else if (value2 instanceof Enumerator) {
                nullFlavorValue = ((Enumerator)value2).getName();
            }
            if (nullFlavorValue != null && (class_ = property.getClass_()) != null) {
                if (body.length() > 0) {
                    body.append(" and ");
                }
                body.append("self." + property.getName() + ".nullFlavor = vocab::NullFlavor::" + nullFlavorValue);
            }
        }
        if ((textValue = this.getEcoreProfile().getAppliedValidationStereotype((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.TEXT_VALUE)) != null && this.isEDType(property) && (value = (String)property.getValue(textValue, "value")) != null && (class_ = property.getClass_()) != null) {
            if (body.length() > 0) {
                body.append(" and ");
            }
            body.append("self." + property.getName() + ".getText() = " + "'" + value + "'");
        }
        if ((severity = this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.PROPERTY)) != null && body.length() != 0) {
            if (cdaProperty.getUpper() == 1) {
                if (propertyType instanceof Enumeration) {
                    body.append("isDefined('" + cdaProperty.getName() + "')");
                } else {
                    body.append("not " + selfName + ".oclIsUndefined()");
                }
            } else {
                body.append("not " + selfName + "->isEmpty()");
            }
        }
        return body;
    }

    public TransformLogicalConstraint(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
    }

    public Object caseConstraint(Constraint constraint) {
        TransformSwitch transformSwitch = new TransformSwitch(constraint);
        for (EObject eObject : constraint.getStereotypeApplications()) {
            String ocl = (String)transformSwitch.doSwitch(eObject);
            if (ocl == null) continue;
            OpaqueExpression opaqueExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
            opaqueExpression.getLanguages().add((Object)"OCL");
            opaqueExpression.getBodies().add((Object)ocl);
            constraint.setSpecification((ValueSpecification)opaqueExpression);
        }
        return super.caseConstraint(constraint);
    }

    private class TransformSwitch
    extends CDASwitch<String> {
        Constraint constraint;

        public TransformSwitch(Constraint constraint) {
            this.constraint = constraint;
        }

        public String caseLogicalConstraint(LogicalConstraint logicalConstraint) {
            StringBuilder body = new StringBuilder();
            switch (logicalConstraint.getOperation()) {
                case AND: {
                    for (Element element : this.constraint.getConstrainedElements()) {
                        Property p;
                        if (!(element instanceof Property)) continue;
                        if (body.length() > 0) {
                            body.append(" and ");
                        }
                        if ((p = (Property)element).getAssociation() != null) {
                            body.append(" (").append(TransformLogicalConstraint.this.generateAssociationOCL(p.getAssociation())).append(") ");
                            continue;
                        }
                        body.append(" (").append(TransformLogicalConstraint.this.generateOCL(p)).append(") ");
                    }
                    break;
                }
                case OR: {
                    for (Element element : this.constraint.getConstrainedElements()) {
                        if (!(element instanceof Property)) continue;
                        if (body.length() > 0) {
                            body.append(" or ");
                        }
                        body.append(" (").append(TransformLogicalConstraint.this.generateOCL((Property)element)).append(") ");
                    }
                    break;
                }
                case XOR: {
                    if (this.constraint.getConstrainedElements().size() > 1) {
                        for (Element element : this.constraint.getConstrainedElements()) {
                            if (!(element instanceof Property)) continue;
                            if (body.length() > 0) {
                                body.append(" xor ");
                            }
                            body.append(" (").append(TransformLogicalConstraint.this.generateOCL((Property)element)).append(") ");
                        }
                        break;
                    }
                    body.append("true");
                    break;
                }
                case IFTHEN: {
                    if (this.constraint.getConstrainedElements().size() == 2) {
                        Property property1 = (Property)this.constraint.getConstrainedElements().get(0);
                        Property property2 = (Property)this.constraint.getConstrainedElements().get(0);
                        body.append(TransformLogicalConstraint.this.generateOCL(property1)).append(") ").append(" implies ").append(TransformLogicalConstraint.this.generateOCL(property2)).append(") ");
                        break;
                    }
                    body.append("true");
                    break;
                }
                case NOTBOTH: {
                    for (Element element : this.constraint.getConstrainedElements()) {
                        if (!(element instanceof Property)) continue;
                        if (body.length() > 0) {
                            body.append(" and ");
                        }
                        body.append(" (").append(TransformLogicalConstraint.this.generateOCL((Property)element)).append(") ");
                    }
                    body.insert(0, "not (").append(")");
                    break;
                }
            }
            return body.toString();
        }
    }
}

