/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.validation.ocl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.mdht.uml.validation.ocl.EcoreProfileEnvironmentFactory;
import org.eclipse.mdht.uml.validation.ocl.EcoreProfileReflection;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.uml.UMLEnvironment;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.osgi.framework.Bundle;

public class EcoreProfileEnvironment
extends UMLEnvironment {
    private static final String QUERY = "QUERY";
    private static final String EDATATYPE = "Ecore::EDataType";
    private EcoreProfileReflection reflection;

    public EcoreProfileEnvironment(Environment<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint, Class, EObject> parent) {
        super(parent);
    }

    public EcoreProfileEnvironment(EcoreProfileEnvironmentFactory factory, EPackage.Registry registry, ResourceSet rset) {
        super(registry, rset);
        this.setFactory((EnvironmentFactory)factory);
    }

    public EcoreProfileEnvironment(EcoreProfileEnvironmentFactory factory, EPackage.Registry registry, ResourceSet rset, Resource resource) {
        super(registry, rset, resource);
        this.setFactory((EnvironmentFactory)factory);
    }

    public static boolean isQueryConstraint(Constraint constraint) {
        boolean result = false;
        for (Comment next : constraint.getOwnedComments()) {
            if (next.getBody() == null || !QUERY.equalsIgnoreCase(next.getBody().trim())) continue;
            result = true;
            break;
        }
        return result;
    }

    public UMLReflection<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        if (this.reflection == null) {
            this.reflection = new EcoreProfileReflection(this);
        }
        return this.reflection;
    }

    public Classifier lookupAssociationClassReference(Classifier owner, String name) {
        return null;
    }

    public Classifier lookupClassifier(List<String> names) {
        Classifier result = super.lookupClassifier(names);
        if (result instanceof Association) {
            result = null;
        }
        return result;
    }

    public Property lookupProperty(Classifier owner, String name) {
        Classifier ecoreContext;
        Property result = (Property)super.lookupProperty((Object)owner, name);
        if (result == null && (owner == null || owner == this.getContextClassifier()) && (owner = (Classifier)this.getContextClassifier()) != (ecoreContext = this.getNestingRoot(owner))) {
            result = this.lookupProperty(ecoreContext, name);
        }
        return result;
    }

    public Operation lookupOperation(Classifier owner, String name, List<? extends TypedElement<Classifier>> args) {
        Classifier oclClass;
        java.lang.Class<?> javaClass;
        Classifier ecoreContext;
        Operation result = (Operation)super.lookupOperation((Object)owner, name, args);
        if (result == null && (owner == null || owner == this.getContextClassifier()) && (owner = (Classifier)this.getContextClassifier()) != (ecoreContext = this.getNestingRoot(owner))) {
            result = this.lookupOperation(ecoreContext, name, args);
        }
        if (result == null && (javaClass = this.getJavaClass(owner)) != null && (oclClass = this.getOCLClass(javaClass)) != null) {
            result = (Operation)super.lookupOperation((Object)oclClass, name, args);
        }
        return result;
    }

    private java.lang.Class<?> getJavaClass(Classifier classifier) {
        java.lang.Class<?> result = null;
        String javaClassName = (String)UMLUtil.getTaggedValue((Element)classifier, (String)EDATATYPE, (String)"instanceClassName");
        String string = javaClassName = javaClassName == null ? javaClassName : javaClassName.trim();
        if (javaClassName != null && javaClassName.length() > 0) {
            result = this.getJavaClass(classifier.eResource(), javaClassName);
        }
        return result;
    }

    private java.lang.Class<?> getJavaClass(Resource context, String name) {
        java.lang.Class result = null;
        try {
            result = java.lang.Class.forName(name);
        }
        catch (Exception e) {
            try {
                String pluginID;
                Bundle bundle;
                URIConverter conv = context.getResourceSet() == null ? URIConverter.INSTANCE : context.getResourceSet().getURIConverter();
                URI normalizedURI = conv.normalize(context.getURI());
                if (normalizedURI.isPlatformPlugin() && (bundle = Platform.getBundle((String)(pluginID = normalizedURI.segment(1)))) != null) {
                    result = bundle.loadClass(name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Classifier getOCLClass(java.lang.Class<?> javaClass) {
        Classifier result = null;
        OCLStandardLibrary stdlib = this.getOCLStandardLibrary();
        if (javaClass == String.class) {
            result = (Classifier)stdlib.getString();
        } else if (javaClass == Object.class) {
            result = (Classifier)stdlib.getOclAny();
        } else if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            result = (Classifier)stdlib.getBoolean();
        } else if (javaClass == Integer.class || javaClass == Integer.TYPE || javaClass == Short.class || javaClass == Short.TYPE || javaClass == Long.class || javaClass == Long.TYPE || javaClass == Byte.class || javaClass == Byte.TYPE || javaClass == BigInteger.class) {
            result = (Classifier)stdlib.getInteger();
        } else if (javaClass == Double.class || javaClass == Double.TYPE || javaClass == Float.class || javaClass == Float.TYPE || javaClass == BigDecimal.class) {
            result = (Classifier)stdlib.getReal();
        } else if (javaClass == Void.class || javaClass == Void.TYPE) {
            result = (Classifier)stdlib.getOclVoid();
        }
        return result;
    }

    private Classifier getNestingRoot(Classifier classifier) {
        Classifier result = classifier;
        while (result.getOwner() instanceof Classifier) {
            result = (Classifier)result.getOwner();
        }
        return result;
    }
}

