/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.core.profile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BindingKind implements Enumerator
{
    STATIC(0, "Static", "Static"),
    DYNAMIC(1, "Dynamic", "Dynamic");

    public static final int STATIC_VALUE = 0;
    public static final int DYNAMIC_VALUE = 1;
    private static final BindingKind[] VALUES_ARRAY;
    public static final List<BindingKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BindingKind[]{STATIC, DYNAMIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BindingKind get(int value) {
        switch (value) {
            case 0: {
                return STATIC;
            }
            case 1: {
                return DYNAMIC;
            }
        }
        return null;
    }

    public static BindingKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private BindingKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

