/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.ui.properties;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.common.ui.search.IElementFilter;
import org.eclipse.mdht.uml.common.ui.util.UMLUIUtil;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemVersion;
import org.eclipse.mdht.uml.term.core.profile.TermPackage;
import org.eclipse.mdht.uml.term.core.profile.ValueSetCode;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.mdht.uml.ui.properties.sections.ResettableModelerPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Stereotype;

public class ValueSetCodeSection
extends ResettableModelerPropertySection {
    private EnumerationLiteral umlEnumerationLiteral;
    private Text conceptCodeText;
    private boolean conceptCodeModified = false;
    private Text conceptNameText;
    private boolean conceptNameModified = false;
    private Text usageNoteText;
    private boolean usageNoteModified = false;
    private CLabel codeSystemRefLabel;
    private Button codeSystemRefButton;
    private Button codeSystemRefDeleteButton;
    private Button addNewCodeButton;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (ValueSetCodeSection.this.conceptNameText == event.getSource()) {
                ValueSetCodeSection.this.conceptNameModified = true;
            }
            if (ValueSetCodeSection.this.conceptCodeText == event.getSource()) {
                ValueSetCodeSection.this.conceptCodeModified = true;
            }
            if (ValueSetCodeSection.this.usageNoteText == event.getSource()) {
                ValueSetCodeSection.this.usageNoteModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                ValueSetCodeSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            ValueSetCodeSection.this.modifyFields();
        }
    };

    private void modifyFields() {
        if (!(this.conceptNameModified || this.conceptCodeModified || this.usageNoteModified)) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumerationLiteral);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ValueSetCode valueSetCode = TermProfileUtil.getValueSetCode((EnumerationLiteral)ValueSetCodeSection.this.umlEnumerationLiteral);
                    if (valueSetCode == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (ValueSetCodeSection.this.conceptNameModified) {
                        ValueSetCodeSection.this.conceptNameModified = false;
                        this.setLabel("Set Concept Name");
                        String value = ValueSetCodeSection.this.conceptNameText.getText().trim();
                        valueSetCode.setConceptName(value.length() > 0 ? value : null);
                    } else if (ValueSetCodeSection.this.conceptCodeModified) {
                        ValueSetCodeSection.this.conceptCodeModified = false;
                        this.setLabel("Set Concept Code");
                        String value = ValueSetCodeSection.this.conceptCodeText.getText().trim();
                        valueSetCode.getBase_EnumerationLiteral().setName(value.length() > 0 ? value : null);
                    } else if (ValueSetCodeSection.this.usageNoteModified) {
                        ValueSetCodeSection.this.usageNoteModified = false;
                        this.setLabel("Set Usage Note");
                        String value = ValueSetCodeSection.this.usageNoteText.getText().trim();
                        valueSetCode.setUsageNote(value.length() > 0 ? value : null);
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    ValueSetCodeSection.this.updateViews();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected void resetFields() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumerationLiteral);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Restore Default Values"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ValueSetCode valueSetCode = TermProfileUtil.getValueSetCode((EnumerationLiteral)ValueSetCodeSection.this.umlEnumerationLiteral);
                    if (valueSetCode == null) {
                        return Status.CANCEL_STATUS;
                    }
                    valueSetCode.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_CODE__CONCEPT_NAME);
                    valueSetCode.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_CODE__CODE_SYSTEM);
                    valueSetCode.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_CODE__USAGE_NOTE);
                    ValueSetCodeSection.this.updateViews();
                    ValueSetCodeSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void addCodeSystemReference() {
        IElementFilter filter = new IElementFilter(){

            public boolean accept(Element element) {
                return element instanceof Enumeration && TermProfileUtil.getCodeSystemVersion((Enumeration)((Enumeration)element)) != null;
            }
        };
        Enumeration codeSystemEnum = (Enumeration)DialogLaunchUtil.chooseElement((IElementFilter)filter, (ResourceSet)UMLUIUtil.loadModelsfromWorkspace(), (Shell)this.getPart().getSite().getShell(), null, (String)"Select a Code System");
        if (codeSystemEnum == null) {
            return;
        }
        Stereotype codeSystemStereotype = TermProfileUtil.getAppliedStereotype((Element)codeSystemEnum, (String)"CodeSystemVersion");
        if (codeSystemStereotype == null) {
            MessageDialog.openError((Shell)this.getPart().getSite().getShell(), (String)"Invalid Enumeration", (String)"The selected Enumertion must be a <<CodeSystemVersion>>");
            return;
        }
        final CodeSystemVersion codeSystem = (CodeSystemVersion)codeSystemEnum.getStereotypeApplication(codeSystemStereotype);
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumerationLiteral);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ValueSetCode valueSetCode = TermProfileUtil.getValueSetCode((EnumerationLiteral)ValueSetCodeSection.this.umlEnumerationLiteral);
                    if (valueSetCode == null) {
                        return Status.CANCEL_STATUS;
                    }
                    this.setLabel("Set CodeSystem reference");
                    valueSetCode.setCodeSystem(codeSystem);
                    ValueSetCodeSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void deleteCodeSystemReference() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumerationLiteral);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ValueSetCode valueSetCode = TermProfileUtil.getValueSetCode((EnumerationLiteral)ValueSetCodeSection.this.umlEnumerationLiteral);
                    if (valueSetCode == null) {
                        return Status.CANCEL_STATUS;
                    }
                    this.setLabel("Remove CodeSystem reference");
                    valueSetCode.setCodeSystem(null);
                    ValueSetCodeSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void addNewCode() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumerationLiteral);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ValueSetCode valueSetCode = TermProfileUtil.getValueSetCode((EnumerationLiteral)ValueSetCodeSection.this.umlEnumerationLiteral);
                    if (valueSetCode == null) {
                        return Status.CANCEL_STATUS;
                    }
                    this.setLabel("Add new code");
                    EnumerationLiteral newCode = ValueSetCodeSection.this.umlEnumerationLiteral.getEnumeration().createOwnedLiteral("NewCode");
                    TermProfileUtil.applyStereotype((Element)newCode, (String)"ValueSetCode");
                    ValueSetCodeSection.this.setInput(ValueSetCodeSection.this.getPart(), (ISelection)new StructuredSelection((Object)newCode));
                    ValueSetCodeSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 10;
        gc.dispose();
        shell.dispose();
        Group composite = this.getWidgetFactory().createGroup(parent, "Value Set Code");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 4;
        layout.spacing = 7;
        composite.setLayout((Layout)layout);
        int numberOfRows = 4;
        FormData data = null;
        this.codeSystemRefLabel = this.getWidgetFactory().createCLabel((Composite)composite, "");
        this.codeSystemRefButton = this.getWidgetFactory().createButton((Composite)composite, "Select Code System...", 8);
        this.codeSystemRefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ValueSetCodeSection.this.addCodeSystemReference();
            }
        });
        this.codeSystemRefDeleteButton = this.getWidgetFactory().createButton((Composite)composite, "X", 8);
        this.codeSystemRefDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ValueSetCodeSection.this.deleteCodeSystemReference();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.height = buttonHeight;
        data.top = new FormAttachment(0, numberOfRows);
        this.codeSystemRefButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.codeSystemRefButton, 0);
        data.height = buttonHeight;
        data.top = new FormAttachment((Control)this.codeSystemRefButton, 0, 0x1000000);
        this.codeSystemRefDeleteButton.setLayoutData((Object)data);
        this.createRestoreDefaultsButton((Composite)composite);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.codeSystemRefLabel, 0, 0x1000000);
        this.restoreDefaultsButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.codeSystemRefDeleteButton, 0);
        data.right = new FormAttachment((Control)this.restoreDefaultsButton, 5);
        data.top = new FormAttachment((Control)this.codeSystemRefButton, 0, 0x1000000);
        this.codeSystemRefLabel.setLayoutData((Object)data);
        this.conceptCodeText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel conceptCodeLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Concept Code:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.conceptCodeText, 0, 0x1000000);
        conceptCodeLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)conceptCodeLabel, 0);
        data.right = new FormAttachment(40, 0);
        data.top = new FormAttachment(1, numberOfRows, 4);
        this.conceptCodeText.setLayoutData((Object)data);
        this.conceptNameText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel conceptNameLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Concept Name:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.conceptCodeText, 5);
        data.top = new FormAttachment((Control)this.conceptCodeText, 0, 0x1000000);
        conceptNameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)conceptNameLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(1, numberOfRows, 4);
        this.conceptNameText.setLayoutData((Object)data);
        this.usageNoteText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel usageNoteLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Usage Note:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.usageNoteText, 0, 0x1000000);
        usageNoteLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)usageNoteLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(2, numberOfRows, 4);
        this.usageNoteText.setLayoutData((Object)data);
        this.addNewCodeButton = this.getWidgetFactory().createButton((Composite)composite, "Add New Code", 8);
        this.addNewCodeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ValueSetCodeSection.this.addNewCode();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.height = buttonHeight;
        data.top = new FormAttachment(3, numberOfRows, 4);
        this.addNewCodeButton.setLayoutData((Object)data);
    }

    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.umlEnumerationLiteral != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.umlEnumerationLiteral)) != null && editingDomain.isReadOnly(this.umlEnumerationLiteral.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof EnumerationLiteral));
        this.umlEnumerationLiteral = (EnumerationLiteral)element;
    }

    public void dispose() {
        super.dispose();
    }

    public void refresh() {
        ValueSetVersion valueSetVersion;
        ValueSetCode valueSetCode = TermProfileUtil.getValueSetCode((EnumerationLiteral)this.umlEnumerationLiteral);
        boolean isDefaultCodeSystem = false;
        CodeSystemVersion codeSystemVersion = null;
        if (valueSetCode != null && (codeSystemVersion = valueSetCode.getCodeSystem()) == null && (valueSetVersion = TermProfileUtil.getValueSetVersion((Enumeration)this.umlEnumerationLiteral.getEnumeration())) != null) {
            codeSystemVersion = valueSetVersion.getCodeSystem();
            isDefaultCodeSystem = true;
        }
        if (codeSystemVersion != null) {
            this.codeSystemRefLabel.setText(String.valueOf(isDefaultCodeSystem ? "(default) " : "") + codeSystemVersion.getEnumerationQualifiedName());
            this.codeSystemRefLabel.layout();
        } else {
            this.codeSystemRefLabel.setText("");
        }
        this.conceptNameText.removeModifyListener(this.modifyListener);
        this.conceptNameText.removeKeyListener(this.keyListener);
        this.conceptNameText.removeFocusListener(this.focusListener);
        if (valueSetCode != null) {
            String conceptName = valueSetCode.getConceptName();
            this.conceptNameText.setText(conceptName != null ? conceptName : "");
        } else {
            this.conceptNameText.setText("");
        }
        this.conceptNameText.addModifyListener(this.modifyListener);
        this.conceptNameText.addKeyListener(this.keyListener);
        this.conceptNameText.addFocusListener(this.focusListener);
        this.conceptCodeText.removeModifyListener(this.modifyListener);
        this.conceptCodeText.removeKeyListener(this.keyListener);
        this.conceptCodeText.removeFocusListener(this.focusListener);
        if (valueSetCode != null) {
            String conceptCode = valueSetCode.getBase_EnumerationLiteral().getName();
            this.conceptCodeText.setText(conceptCode != null ? conceptCode : "");
        } else {
            this.conceptCodeText.setText("");
        }
        this.conceptCodeText.addModifyListener(this.modifyListener);
        this.conceptCodeText.addKeyListener(this.keyListener);
        this.conceptCodeText.addFocusListener(this.focusListener);
        this.usageNoteText.removeModifyListener(this.modifyListener);
        this.usageNoteText.removeKeyListener(this.keyListener);
        this.usageNoteText.removeFocusListener(this.focusListener);
        if (valueSetCode != null) {
            String usageNote = valueSetCode.getUsageNote();
            this.usageNoteText.setText(usageNote != null ? usageNote : "");
        } else {
            this.usageNoteText.setText("");
        }
        this.usageNoteText.addModifyListener(this.modifyListener);
        this.usageNoteText.addKeyListener(this.keyListener);
        this.usageNoteText.addFocusListener(this.focusListener);
        if (this.isReadOnly()) {
            this.codeSystemRefLabel.setEnabled(false);
            this.conceptNameText.setEnabled(false);
            this.conceptCodeText.setEnabled(false);
            this.usageNoteText.setEnabled(false);
            this.restoreDefaultsButton.setEnabled(false);
        } else {
            this.codeSystemRefLabel.setEnabled(true);
            this.conceptNameText.setEnabled(true);
            this.conceptCodeText.setEnabled(true);
            this.usageNoteText.setEnabled(true);
            this.restoreDefaultsButton.setEnabled(valueSetCode != null);
        }
    }

    public void update(Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!ValueSetCodeSection.this.isDisposed() && ValueSetCodeSection.this.umlEnumerationLiteral.eResource() != null) {
                        ValueSetCodeSection.this.refresh();
                    }
                }
            });
        }
    }

    protected void updateViews() {
        NotificationImpl notification = new NotificationImpl(1, null, this.umlEnumerationLiteral.getName()){

            public Object getNotifier() {
                return ValueSetCodeSection.this.umlEnumerationLiteral;
            }

            public int getFeatureID(Class expectedClass) {
                return 5;
            }
        };
        this.umlEnumerationLiteral.eNotify((Notification)notification);
    }
}

