/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import java.math.BigInteger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.mdht.uml.cda.tests.DiagnosticOutputHelper;
import org.eclipse.mdht.uml.cda.tests.SystemOutValidationHandler;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.INT;

public class BigIntegerTest {
    private static boolean diagnosticsHaveErrors(Diagnostic oDiagnostic) {
        return oDiagnostic.getSeverity() != 0;
    }

    private static boolean processDiagnostics(Diagnostic oDiagnostic) {
        boolean bResult = true;
        if (BigIntegerTest.diagnosticsHaveErrors(oDiagnostic)) {
            SystemOutValidationHandler oValHandler = new SystemOutValidationHandler();
            DiagnosticOutputHelper.processDiagnostic(oDiagnostic, oValHandler);
            bResult = false;
        }
        return bResult;
    }

    public static boolean testINTValue() {
        boolean bResult = true;
        INT oINT = DatatypesFactory.eINSTANCE.createINT();
        oINT.setValue(new BigInteger("123456"));
        if (!oINT.getValue().equals(new BigInteger("123456"))) {
            System.out.println("Failed to set/retrieve INT::value using BigInteger initializer.");
            bResult = false;
        }
        oINT = DatatypesFactory.eINSTANCE.createINT();
        oINT.setValue(new Integer("4567"));
        if (!oINT.getValue().equals(new BigInteger("4567"))) {
            System.out.println("Failed to set/retrieve INT::value using Double initializer.");
            bResult = false;
        }
        return bResult;
    }

    public static void main(String[] args) throws Exception {
        boolean bFailure = false;
        if (!BigIntegerTest.testINTValue()) {
            bFailure = true;
            System.out.println("testINTValue failed!");
        }
        if (bFailure) {
            System.out.println("One or more tests Failed!!!");
        } else {
            System.out.println("All tests completed successfully...");
        }
    }
}

