/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import traceability.Trace;
import traceability.TraceabilityPackage;
import traceability.presentation.ReuseURIEditorInput;
import traceability.presentation.TraceabilityEditor;
import traceability.presentation.table.GroupItem;

public class TraceUtils {
    public static void doubleClick(DoubleClickEvent event, TraceabilityEditor traceabilityEditor) {
        ISelection sel;
        ArrayList<EObject> fromOther = new ArrayList<EObject>();
        ArrayList<EObject> fromSelf = new ArrayList<EObject>();
        ISelection iSelection = sel = event.getViewer() == traceabilityEditor.getViewer() ? traceabilityEditor.getSelection() : event.getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection currentSelection = (IStructuredSelection)sel;
            for (Object o : currentSelection.toList()) {
                EObject eObject;
                Object o2 = Platform.getAdapterManager().getAdapter(o, EObject.class);
                if (o2 != null) {
                    o = o2;
                }
                if (!(o instanceof EObject) || (eObject = (EObject)o).eClass().getEPackage() == TraceabilityPackage.eINSTANCE) continue;
                if (eObject.eResource().getResourceSet() != traceabilityEditor.getEditingDomain().getResourceSet()) {
                    fromOther.add(eObject);
                    continue;
                }
                fromSelf.add(eObject);
            }
        }
        if (!fromOther.isEmpty()) {
            TraceUtils.doubleClickFromOther((EObject)fromOther.get(0), traceabilityEditor);
        } else if (!fromSelf.isEmpty()) {
            TraceUtils.doubleClickFromSelf(fromSelf);
        }
    }

    public static void doubleClickFromSelf(List<EObject> fromSelf) {
        try {
            IEditorPart editor;
            Resource nresource;
            PlatformUI.getWorkbench().getEditorRegistry().setDefaultEditor("file.xml", "ReusableModels.presentation.ReusableModelsEditorID");
            EObject eo = fromSelf.get(0);
            Resource resource = eo.eResource();
            URI uri = resource.getURI();
            URI nuri = resource.getResourceSet().getURIConverter().normalize(uri);
            if (!uri.equals(nuri) && (nresource = new ResourceSetImpl().getResource(nuri, true)).getContents().size() > 0) {
                eo = (EObject)nresource.getContents().get(0);
            }
            boolean opened = EditUIUtil.openEditor((EObject)eo);
            boolean reuse = false;
            if (!opened) {
                URIEditorInput i = ReuseURIEditorInput.create(eo.eResource());
                opened = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)i, (String)"ReusableModels.presentation.ReusableModelsEditorID") != null;
                reuse = true;
            }
            if (opened && (editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null && editor instanceof IEditingDomainProvider) {
                ArrayList<EObject> allFound;
                IEditingDomainProvider editingDomainProvider = (IEditingDomainProvider)editor;
                ArrayList<EObject> arrayList = allFound = reuse ? fromSelf : new ArrayList<EObject>();
                if (allFound.isEmpty()) {
                    block2: for (EObject eObject : fromSelf) {
                        String fragment = eObject.eResource().getURIFragment(eObject);
                        for (Resource res : editingDomainProvider.getEditingDomain().getResourceSet().getResources()) {
                            EObject found = res.getEObject(fragment);
                            if (found == null) continue;
                            allFound.add(found);
                            continue block2;
                        }
                    }
                }
                if (!allFound.isEmpty()) {
                    if (editingDomainProvider instanceof ISetSelectionTarget) {
                        ISetSelectionTarget iSetSelectionTarget = (ISetSelectionTarget)editingDomainProvider;
                        iSetSelectionTarget.selectReveal((ISelection)new StructuredSelection(allFound.toArray()));
                    } else if (editingDomainProvider instanceof ISelectionProvider) {
                        ISelectionProvider iSelectionProvider = (ISelectionProvider)editingDomainProvider;
                        iSelectionProvider.setSelection((ISelection)new StructuredSelection(allFound.toArray()));
                    }
                }
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public static void selectionChanged(IWorkbenchPart part, ISelection selection, TraceabilityEditor traceabilityEditor) {
        IViewerProvider iViewerProvider;
        Viewer view;
        if (part == traceabilityEditor) {
            return;
        }
        Object o = part.getAdapter(IViewerProvider.class);
        if (o instanceof IViewerProvider && (view = (iViewerProvider = (IViewerProvider)o).getViewer()) instanceof StructuredViewer) {
            StructuredViewer structuredViewer = (StructuredViewer)view;
            structuredViewer.addDoubleClickListener((IDoubleClickListener)traceabilityEditor);
        }
    }

    public static void doubleClickFromOther(EObject eObject, TraceabilityEditor traceabilityEditor) {
        for (Resource res : traceabilityEditor.getEditingDomain().getResourceSet().getResources()) {
            if (!"traces".equals(res.getURI().fileExtension())) continue;
            TreeIterator it = res.getAllContents();
            while (it.hasNext()) {
                EObject eObject2 = (EObject)it.next();
                if (!(eObject2 instanceof Trace)) continue;
                Trace trace = (Trace)eObject2;
                EObject eObject4 = null;
                for (EObject source : trace.getSource()) {
                    if (!TraceUtils.isSame(source, eObject)) continue;
                    eObject4 = source;
                }
                for (EObject target : trace.getTarget()) {
                    if (!TraceUtils.isSame(target, eObject)) continue;
                    eObject4 = target;
                }
                if (eObject4 == null || eObject4 == eObject) continue;
                EObject toSelect = eObject4;
                if (traceabilityEditor.getViewer() instanceof AbstractTreeViewer) {
                    AbstractTreeViewer treeViewer = (AbstractTreeViewer)traceabilityEditor.getViewer();
                    treeViewer.expandToLevel((Object)trace, 1);
                    traceabilityEditor.setSelectionToViewer(Arrays.asList(trace));
                }
                traceabilityEditor.setSelectionToViewer(Arrays.asList(toSelect));
                traceabilityEditor.getSite().getPage().activate((IWorkbenchPart)traceabilityEditor);
                return;
            }
            break block0;
        }
    }

    private static boolean isSame(EObject eObject1, EObject eObject2) {
        return eObject1 != null && eObject2 != null && EcoreUtil.getURI((EObject)eObject2).equals(EcoreUtil.getURI((EObject)eObject1));
    }

    public static GroupItem lookupOrCreate(Object element, Map<Object, GroupItem> existingGroups) {
        if (existingGroups.containsKey(element)) {
            return existingGroups.get(element);
        }
        GroupItem result = new GroupItem(element);
        existingGroups.put(element, result);
        return result;
    }

    public static String withoutTags(String text) {
        int i2;
        int i;
        while ((i = text.indexOf("<")) != -1 && (i2 = text.indexOf(">")) > i) {
            text = String.valueOf(text.substring(0, i)) + text.substring(i2 + 1);
        }
        return text;
    }
}

