/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParticipationTargetLocation implements Enumerator
{
    DST(0, "DST", "DST"),
    ELOC(1, "ELOC", "ELOC"),
    LOC(2, "LOC", "LOC"),
    ORG(3, "ORG", "ORG"),
    RML(4, "RML", "RML"),
    VIA(5, "VIA", "VIA");

    public static final int DST_VALUE = 0;
    public static final int ELOC_VALUE = 1;
    public static final int LOC_VALUE = 2;
    public static final int ORG_VALUE = 3;
    public static final int RML_VALUE = 4;
    public static final int VIA_VALUE = 5;
    private static final ParticipationTargetLocation[] VALUES_ARRAY;
    public static final List<ParticipationTargetLocation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParticipationTargetLocation[]{DST, ELOC, LOC, ORG, RML, VIA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParticipationTargetLocation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParticipationTargetLocation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParticipationTargetLocation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParticipationTargetLocation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParticipationTargetLocation get(int value) {
        switch (value) {
            case 0: {
                return DST;
            }
            case 1: {
                return ELOC;
            }
            case 2: {
                return LOC;
            }
            case 3: {
                return ORG;
            }
            case 4: {
                return RML;
            }
            case 5: {
                return VIA;
            }
        }
        return null;
    }

    private ParticipationTargetLocation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

