/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.common.ui.dialogs.SubclassHandler;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.ui.actions.UML2AbstractAction;
import org.eclipse.mdht.uml.ui.internal.Logger;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class AddNestedSubclassAction
extends UML2AbstractAction {
    public void run(IAction action) {
        try {
            final Element selectedElement = this.getSelectedElement();
            AbstractEMFOperation operation = new AbstractEMFOperation(this.editingDomain, "Create Nested Subclass"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Property property = null;
                    if (selectedElement instanceof Association) {
                        Association association = (Association)selectedElement;
                        property = UMLUtil.getNavigableEnd((Association)association);
                    } else if (selectedElement instanceof Property) {
                        property = (Property)selectedElement;
                    }
                    if (property == null || !(property.getType() instanceof Class)) {
                        return Status.CANCEL_STATUS;
                    }
                    Class baseClass = (Class)property.getType();
                    String className = null;
                    InputDialog inputDialog = new InputDialog(AddNestedSubclassAction.this.activePart.getSite().getShell(), "Nested Class", "Enter class name", baseClass.getName(), null);
                    if (inputDialog.open() == 0) {
                        className = inputDialog.getValue();
                    }
                    if (className == null || className.length() == 0) {
                        return Status.CANCEL_STATUS;
                    }
                    Class newClass = UMLFactory.eINSTANCE.createClass();
                    property.getClass_().getNestedClassifiers().add((Object)newClass);
                    newClass.setName(className);
                    property.setType((Type)newClass);
                    newClass.createGeneralization((Classifier)baseClass);
                    SubclassHandler subclassHandler = new SubclassHandler(AddNestedSubclassAction.this.activePart.getSite().getShell(), newClass);
                    subclassHandler.openSubclassDialog();
                    if (AddNestedSubclassAction.this.activePart instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)AddNestedSubclassAction.this.activePart).selectReveal((ISelection)new StructuredSelection((Object)newClass));
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)this.editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                Logger.logException(ee);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        Element element = this.getSelectedElement();
        if (element instanceof Property || element instanceof Association) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }
}

