/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.CompletableFutureHelper;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.fallback.AsyncFallbackClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AsyncFallbackTest
extends Arquillian {
    @Inject
    private AsyncFallbackClient client;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftAsyncFallback.jar")).addClasses(new Class[]{AsyncFallbackClient.class, CompletableFutureHelper.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftAsyncFallback.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testAsyncFallbackSuccess() throws ExecutionException, InterruptedException {
        MatcherAssert.assertThat((String)"Future-returning method that returns successfully should not fallback", (Object)this.client.service1().get(), (Matcher)Matchers.equalTo((Object)"Success"));
    }

    @Test
    public void testAsyncFallbackMethodThrows() throws IOException, ExecutionException, InterruptedException {
        MatcherAssert.assertThat((String)"Future-returning method that throws an exception should fallback", (Object)this.client.service2().get(), (Matcher)Matchers.equalTo((Object)"Fallback"));
    }

    @Test
    public void testAsyncFallbackFutureCompletesExceptionally() throws InterruptedException {
        try {
            this.client.service3().get();
            Assert.fail((String)"ExecutionException not thrown");
        }
        catch (ExecutionException expected) {
            MatcherAssert.assertThat((String)"Future-returning method that returns failing future should not fallback", (Object)expected.getCause(), (Matcher)Matchers.instanceOf(IOException.class));
        }
    }

    @Test
    public void testAsyncCSFallbackSuccess() throws ExecutionException, InterruptedException {
        MatcherAssert.assertThat((String)"CompletionStage-returning method that returns successfully should not fallback", (Object)CompletableFutureHelper.toCompletableFuture(this.client.serviceCS1()).get(), (Matcher)Matchers.equalTo((Object)"Success"));
    }

    @Test
    public void testAsyncCSFallbackMethodThrows() throws IOException, ExecutionException, InterruptedException {
        MatcherAssert.assertThat((String)"CompletionStage-returning method that throws an exception should fallback", (Object)CompletableFutureHelper.toCompletableFuture(this.client.serviceCS2()).get(), (Matcher)Matchers.equalTo((Object)"Fallback"));
    }

    @Test
    public void testAsyncCSFallbackFutureCompletesExceptionally() throws InterruptedException, ExecutionException {
        MatcherAssert.assertThat((String)"CompletionStage-returning method that returns failing CompletionStage should fallback", (Object)CompletableFutureHelper.toCompletableFuture(this.client.serviceCS3()).get(), (Matcher)Matchers.equalTo((Object)"Fallback"));
    }
}

