/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.CompletableFutureHelper;
import org.eclipse.microprofile.fault.tolerance.tck.asyncretry.clientserver.AsyncRetryClient;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClassLevelClientAbortOn;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClassLevelClientRetryOn;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClientAbortOn;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.RetryClientRetryOn;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.exceptions.RetryChildException;
import org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver.exceptions.RetryParentException;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCaller;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCallerExecutor;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryConditionTest
extends Arquillian {
    @Inject
    private RetryClientRetryOn clientForRetryOn;
    @Inject
    private RetryClientAbortOn clientForAbortOn;
    @Inject
    private RetryClassLevelClientRetryOn clientForClassLevelRetryOn;
    @Inject
    private RetryClassLevelClientAbortOn clientForClassLevelAbortOn;
    @Inject
    private AsyncRetryClient asyncRetryClient;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftRetryCondition.jar")).addClasses(new Class[]{RetryClientAbortOn.class, RetryClientRetryOn.class, RetryClassLevelClientRetryOn.class, RetryClassLevelClientAbortOn.class, AsyncCallerExecutor.class, AsyncCaller.class, AsyncRetryClient.class, CompletableFutureHelper.class, RetryChildException.class, RetryParentException.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftRetryCondition.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testRetryOnTrue() {
        try {
            this.clientForRetryOn.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testRetryOnTrue");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForRetryOn.getRetryCountForConnectionService(), (int)4, (String)"The execution count should be 4 (3 retries + 1)");
    }

    @Test
    public void testRetryOnFalse() {
        try {
            this.clientForRetryOn.serviceB();
            Assert.fail((String)"serviceB should throw a RuntimeException in testRetryOnFalse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForRetryOn.getRetryCountForWritingService(), (int)1, (String)"The max invocation counter should be 1 as the retry condition is false");
    }

    @Test
    public void testRetryOnTrueThrowingAChildCustomException() {
        try {
            this.clientForRetryOn.serviceC();
            Assert.fail((String)"serviceC should throw a RetryChildException in testRetryOnTrueThrowingAChildCustomException");
        }
        catch (RetryChildException retryChildException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForRetryOn.getRetryCountForConnectionService(), (int)4, (String)"The execution count should be 4 (3 retries + 1)");
    }

    @Test
    public void testRetryOnFalseAndAbortOnTrueThrowingAChildCustomException() {
        try {
            this.clientForRetryOn.serviceD();
            Assert.fail((String)"serviceC should throw a RetryChildException in testRetryOnFalseAndAbortOnTrueThrowingAChildCustomException");
        }
        catch (RetryChildException retryChildException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForRetryOn.getRetryCountForConnectionService(), (int)1, (String)"The max invocation counter should be 1 as the retry condition is false");
    }

    @Test
    public void testRetryWithAbortOnFalse() {
        try {
            this.clientForAbortOn.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testRetryWithAbortOnFalse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForAbortOn.getRetryCountForConnectionService(), (int)4, (String)"The execution count should be 4 (3 retries + 1)");
    }

    @Test
    public void testRetryWithAbortOnTrue() {
        try {
            this.clientForAbortOn.serviceB();
            Assert.fail((String)"serviceB should throw a RuntimeException in testRetryWithAbortOnTrue");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForAbortOn.getRetryCountForWritingService(), (int)1, (String)"The max invocation counter should be 1 as the abort condition is true");
    }

    @Test
    public void testClassLevelRetryOnTrue() {
        try {
            this.clientForClassLevelRetryOn.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testClassLevelRetryOnTrue");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForClassLevelRetryOn.getRetryCountForConnectionService(), (int)4, (String)"The execution count should be 4 (3 retries + 1)");
    }

    @Test
    public void testClassLevelRetryOnFalse() {
        try {
            this.clientForClassLevelRetryOn.serviceB();
            Assert.fail((String)"serviceB should throw a RuntimeException in testClassLevelRetryOnFalse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForClassLevelRetryOn.getRetryCountForWritingService(), (int)1, (String)"The execution count should be 1 as the retry condition is false");
    }

    @Test
    public void testClassLevelRetryWithAbortOnFalse() {
        try {
            this.clientForClassLevelAbortOn.serviceA();
            Assert.fail((String)"serviceA should throw a RuntimeException in testClassLevelRetryWithAbortOnFalse");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForClassLevelAbortOn.getRetryCountForConnectionService(), (int)4, (String)"The execution count should be 4 (3 retries + 1)");
    }

    @Test
    public void testClassLevelRetryWithAbortOnTrue() {
        try {
            this.clientForClassLevelAbortOn.serviceB();
            Assert.fail((String)"serviceB should throw a RuntimeException in testClassLevelRetryWithAbortOnTrue");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForClassLevelAbortOn.getRetryCountForWritingService(), (int)1, (String)"The max invocation counter should be 1 as the abort condition is true");
    }

    @Test
    public void testAsyncRetryExceptionally() {
        CompletionStage<String> future = this.asyncRetryClient.serviceA();
        this.assertCompleteExceptionally(future, IOException.class, "Simulated error");
        Assert.assertEquals((int)this.asyncRetryClient.getCountInvocationsServA(), (int)3);
    }

    @Test
    public void testNoAsynWilNotRetryExceptionally() {
        CompletableFuture future = new CompletableFuture();
        this.assertCompleteExceptionally(this.asyncRetryClient.serviceBFailExceptionally(future), IOException.class, "Simulated error");
        Assert.assertEquals((int)this.asyncRetryClient.getCountInvocationsServBFailExceptionally(), (int)1, (String)"No retries are expected");
    }

    @Test
    public void testNoAsynRetryOnMethodException() {
        CompletableFuture future = new CompletableFuture();
        try {
            this.asyncRetryClient.serviceBFailException(future);
            Assert.fail((String)"Was expecting an exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Simulated error");
        }
        Assert.assertEquals((int)this.asyncRetryClient.getCountInvocationsServBFailException(), (int)3);
    }

    @Test
    public void testRetrySuccess() {
        CompletionStage<String> future = this.asyncRetryClient.serviceC();
        this.assertCompleteOk(future, "Success");
        Assert.assertEquals((int)this.asyncRetryClient.getCountInvocationsServC(), (int)3);
    }

    @Test
    public void testRetryChainSuccess() {
        CompletionStage<String> future = this.asyncRetryClient.serviceD();
        this.assertCompleteOk(future, "Success");
        Assert.assertEquals((int)this.asyncRetryClient.getCountInvocationsServD(), (int)3);
    }

    @Test
    public void testRetryChainExceptionally() {
        this.assertCompleteExceptionally(this.asyncRetryClient.serviceE(), RuntimeException.class, "Simulated error");
        Assert.assertEquals((int)this.asyncRetryClient.getCountInvocationsServE(), (int)3);
    }

    @Test
    public void testRetryParallelExceptionally() {
        this.assertCompleteExceptionally(this.asyncRetryClient.serviceG(), RuntimeException.class, "Simulated error");
        Assert.assertEquals((int)this.asyncRetryClient.getCountInvocationsServG(), (int)3);
    }

    @Test
    public void testRetryParallelSuccess() {
        this.assertCompleteOk(this.asyncRetryClient.serviceF(), "Success then Success");
        Assert.assertEquals((int)this.asyncRetryClient.getCountInvocationsServF(), (int)3);
    }

    @Test
    public void testRetryCompletionStageWithException() {
        this.assertCompleteOk(this.asyncRetryClient.serviceH(), "Success");
        Assert.assertEquals((int)this.asyncRetryClient.getCountInvocationsServH(), (int)3);
    }

    private void assertCompleteExceptionally(CompletionStage<String> future, Class<? extends Throwable> exceptionClass, String exceptionMessage) {
        try {
            CompletableFutureHelper.toCompletableFuture(future).get(TCKConfig.getConfig().getTimeoutInMillis(1000L), TimeUnit.MILLISECONDS);
            Assert.fail((String)("We were expecting an exception: " + exceptionClass.getName() + " with message: " + exceptionMessage));
        }
        catch (InterruptedException | TimeoutException e) {
            Assert.fail((String)("Unexpected exception " + e), (Throwable)e);
        }
        catch (ExecutionException ee) {
            MatcherAssert.assertThat((String)"Cause of ExecutionException", (Object)ee.getCause(), (Matcher)Matchers.instanceOf(exceptionClass));
            Assert.assertEquals((String)ee.getCause().getMessage(), (String)exceptionMessage);
        }
    }

    private void assertCompleteOk(CompletionStage<String> future, String expectedMessage) {
        try {
            Assert.assertEquals((String)CompletableFutureHelper.toCompletableFuture(future).get(TCKConfig.getConfig().getTimeoutInMillis(1000L), TimeUnit.MILLISECONDS), (String)expectedMessage);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception" + e));
        }
    }
}

