/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E0;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E0S;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E1;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E1S;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E2;
import org.eclipse.microprofile.fault.tolerance.tck.exception.hierarchy.E2S;
import org.eclipse.microprofile.fault.tolerance.tck.retry.exception.hierarchy.RetryService;
import org.eclipse.microprofile.fault.tolerance.tck.retry.exception.hierarchy.RetryStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryExceptionHierarchyTest
extends Arquillian {
    @Inject
    private RetryService service;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftRetryExceptionHierarchy.jar")).addClasses(new Class[]{E0.class, E0S.class, E1.class, E1S.class, E2.class, E2S.class, RetryStatus.class, RetryService.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftRetryExceptionHierarchy.war")).addAsLibrary((Archive)jar);
    }

    @Test
    public void serviceAthrowsException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new Exception())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceAthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E0())), (Object)((Object)RetryStatus.RETRIED_INVOCATION));
    }

    @Test
    public void serviceAthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E1())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceAthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E2())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceAthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E2S())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceAthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E1S())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceAthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new E0S())), (Object)((Object)RetryStatus.RETRIED_INVOCATION));
    }

    @Test
    public void serviceAthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new RuntimeException())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceAthrowsError() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new Error())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    private RetryStatus invokeServiceA(Throwable exception) {
        try {
            this.service.serviceA(exception);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.service.getStatus();
    }

    @Test
    public void serviceBthrowsException() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new Exception())), (Object)((Object)RetryStatus.RETRIED_INVOCATION));
    }

    @Test
    public void serviceBthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E0())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceBthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E1())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceBthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E2())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceBthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E2S())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceBthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E1S())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceBthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new E0S())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceBthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invokeserviceB(new RuntimeException())), (Object)((Object)RetryStatus.RETRIED_INVOCATION));
    }

    @Test
    public void serviceBthrowsError() {
        Assert.assertEquals((Object)((Object)this.invokeServiceA(new Error())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    private RetryStatus invokeserviceB(Throwable exception) {
        try {
            this.service.serviceB(exception);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.service.getStatus();
    }

    @Test
    public void serviceCthrowsException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new Exception())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceCthrowsE0() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E0())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceCthrowsE1() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E1())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceCthrowsE2() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E2())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceCthrowsE2S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E2S())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceCthrowsE1S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E1S())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceCthrowsE0S() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new E0S())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceCthrowsRuntimeException() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new RuntimeException())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    @Test
    public void serviceCthrowsError() {
        Assert.assertEquals((Object)((Object)this.invokeServiceC(new Error())), (Object)((Object)RetryStatus.FIRST_INVOCATION));
    }

    private RetryStatus invokeServiceC(Throwable exception) {
        try {
            this.service.serviceC(exception);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.service.getStatus();
    }
}

