/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.asyncretry.clientserver;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCallerExecutor;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Retry;

@RequestScoped
public class AsyncRetryClient {
    private int countInvocationsServA = 0;
    private int countInvocationsServBFailException = 0;
    private int countInvocationsServBFailExceptionally = 0;
    private int countInvocationsServC = 0;
    private int countInvocationsServD = 0;
    private int countInvocationsServE = 0;
    private int countInvocationsServF = 0;
    private int countInvocationsServG = 0;
    private int countInvocationsServH = 0;
    private TCKConfig config = TCKConfig.getConfig();
    @Inject
    private AsyncCallerExecutor executor;

    @Asynchronous
    @Retry(maxRetries=2)
    public CompletionStage<String> serviceA() {
        ++this.countInvocationsServA;
        CompletableFuture<String> future = new CompletableFuture<String>();
        future.completeExceptionally(new IOException("Simulated error"));
        return future;
    }

    @Retry(maxRetries=2)
    public CompletionStage<String> serviceBFailExceptionally(CompletionStage future) {
        ++this.countInvocationsServBFailExceptionally;
        future.toCompletableFuture().completeExceptionally(new IOException("Simulated error"));
        return future;
    }

    @Retry(maxRetries=2)
    public CompletionStage<String> serviceBFailException(CompletionStage future) {
        ++this.countInvocationsServBFailException;
        throw new RuntimeException("Simulated error");
    }

    @Asynchronous
    @Retry(maxRetries=3)
    public CompletionStage<String> serviceC() {
        ++this.countInvocationsServC;
        CompletableFuture<String> future = new CompletableFuture<String>();
        if (this.countInvocationsServC < 3) {
            future.completeExceptionally(new IOException("Simulated error"));
        } else {
            future.complete("Success");
        }
        return future;
    }

    @Asynchronous
    @Retry(maxRetries=3)
    public CompletionStage<String> serviceD() {
        ++this.countInvocationsServD;
        if (this.countInvocationsServD < 3) {
            return CompletableFuture.supplyAsync(this.doTask(null), this.executor).thenCompose(s -> CompletableFuture.supplyAsync(this.doTask("Simulated error"), this.executor));
        }
        return CompletableFuture.supplyAsync(this.doTask(null), this.executor).thenCompose(s -> CompletableFuture.supplyAsync(this.doTask(null), this.executor));
    }

    @Asynchronous
    @Retry(maxRetries=2)
    public CompletionStage<String> serviceE() {
        ++this.countInvocationsServE;
        return CompletableFuture.supplyAsync(this.doTask(null), this.executor).thenCompose(s -> CompletableFuture.supplyAsync(this.doTask("Simulated error"), this.executor));
    }

    @Asynchronous
    @Retry(maxRetries=3)
    public CompletionStage<String> serviceF() {
        ++this.countInvocationsServF;
        if (this.countInvocationsServF < 3) {
            return CompletableFuture.supplyAsync(this.doTask(null), this.executor).thenCombine(CompletableFuture.supplyAsync(this.doTask("Simulated error"), this.executor), (s, s2) -> s + " then " + s2);
        }
        return CompletableFuture.supplyAsync(this.doTask(null), this.executor).thenCombine(CompletableFuture.supplyAsync(this.doTask(null), this.executor), (s, s2) -> s + " then " + s2);
    }

    @Asynchronous
    @Retry(maxRetries=2)
    public CompletionStage<String> serviceG() {
        ++this.countInvocationsServG;
        return CompletableFuture.supplyAsync(this.doTask(null), this.executor).thenCombine(CompletableFuture.supplyAsync(this.doTask("Simulated error"), this.executor), (s, s2) -> s + " then " + s2);
    }

    @Asynchronous
    @Retry(maxRetries=2)
    public CompletionStage<String> serviceH() {
        ++this.countInvocationsServH;
        if (this.countInvocationsServH < 3) {
            throw new RuntimeException("Simulated error");
        }
        CompletableFuture<String> future = new CompletableFuture<String>();
        future.complete("Success");
        return future;
    }

    public int getCountInvocationsServA() {
        return this.countInvocationsServA;
    }

    public int getCountInvocationsServBFailException() {
        return this.countInvocationsServBFailException;
    }

    public int getCountInvocationsServBFailExceptionally() {
        return this.countInvocationsServBFailExceptionally;
    }

    public int getCountInvocationsServC() {
        return this.countInvocationsServC;
    }

    public int getCountInvocationsServD() {
        return this.countInvocationsServD;
    }

    public int getCountInvocationsServE() {
        return this.countInvocationsServE;
    }

    public int getCountInvocationsServF() {
        return this.countInvocationsServF;
    }

    public int getCountInvocationsServG() {
        return this.countInvocationsServG;
    }

    public int getCountInvocationsServH() {
        return this.countInvocationsServH;
    }

    private Supplier<String> doTask(String errorMessage) {
        return () -> {
            try {
                TimeUnit.MILLISECONDS.sleep(this.config.getTimeoutInMillis(50L));
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unplanned error: " + e);
            }
            if (Objects.nonNull(errorMessage)) {
                throw new RuntimeException(errorMessage);
            }
            return "Success";
        };
    }
}

