/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.testng.Assert;

@ApplicationScoped
public class BulkheadPressureBean {
    private AtomicInteger inProgress = new AtomicInteger(0);
    private AtomicInteger maxInProgress = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Bulkhead(value=5)
    public void servicePressure(long sleepTime) {
        int currentInProgress = this.inProgress.incrementAndGet();
        this.maxInProgress.getAndUpdate(v -> Math.max(v, currentInProgress));
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Sleep interrupted", (Throwable)e);
        }
        finally {
            this.inProgress.decrementAndGet();
        }
    }

    @Asynchronous
    @Bulkhead(value=5, waitingTaskQueue=5)
    public Future<?> servicePressureAsync(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Sleep interrupted", (Throwable)e);
        }
        return CompletableFuture.completedFuture(null);
    }

    public int getMaxInProgress() {
        return this.maxInProgress.get();
    }

    public void reset() {
        Assert.assertEquals((int)this.inProgress.get(), (int)0);
        this.maxInProgress.set(0);
    }
}

