/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.disableEnv;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.microprofile.fault.tolerance.tck.util.ConcurrentExecutionTracker;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

@ApplicationScoped
public class DisableAnnotationClient {
    private int failAndRetryOnceCounter = 0;
    private int failRetryOnceThenFallbackCounter = 0;
    @Inject
    private ConcurrentExecutionTracker tracker;

    @Retry(maxRetries=1)
    public void failAndRetryOnce() {
        ++this.failAndRetryOnceCounter;
        throw new TestException();
    }

    public int getFailAndRetryOnceCounter() {
        return this.failAndRetryOnceCounter;
    }

    @Retry(maxRetries=1)
    @Fallback(fallbackMethod="fallback")
    public String failRetryOnceThenFallback() {
        ++this.failRetryOnceThenFallbackCounter;
        throw new TestException();
    }

    public int getFailRetryOnceThenFallbackCounter() {
        return this.failRetryOnceThenFallbackCounter;
    }

    public String fallback() {
        return "OK";
    }

    @CircuitBreaker(successThreshold=2, requestVolumeThreshold=1, failureRatio=1.0, delay=50000L)
    public void failWithCircuitBreaker() {
        throw new TestException();
    }

    @Timeout(value=500L)
    public void failWithTimeout() {
        try {
            Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(2000L));
            throw new TestException();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Bulkhead(value=2)
    public void waitWithBulkhead(Future<?> waitingFuture) {
        try {
            this.tracker.executionStarted();
            waitingFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.tracker.executionEnded();
        }
    }

    public void waitForBulkheadExecutions(int count) {
        this.tracker.waitForRunningExecutions(count);
    }

    @Asynchronous
    public Future<String> asyncWaitThenReturn() {
        try {
            Thread.sleep(2000L);
            return CompletableFuture.completedFuture("OK");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

