/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.retry.clientserver;

import jakarta.enterprise.context.RequestScoped;
import java.sql.Connection;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@RequestScoped
public class RetryClientWithDelay {
    private int counterForInvokingConnenectionService;
    private long timestampForConnectionService = 0L;
    private Set<Duration> delayTimes = new HashSet<Duration>();
    private static final Duration MAX_DELAY = TCKConfig.getConfig().getTimeoutInDuration(1000);

    @Retry(delay=400L, maxDuration=3200L, jitter=400L, maxRetries=10)
    public Connection serviceA() {
        return this.connectionService();
    }

    private Connection connectionService() {
        long currentTime = System.nanoTime();
        if (this.timestampForConnectionService != 0L) {
            this.delayTimes.add(Duration.ofNanos(currentTime - this.timestampForConnectionService));
        }
        this.timestampForConnectionService = currentTime;
        ++this.counterForInvokingConnenectionService;
        throw new RuntimeException("Connection failed");
    }

    public void assertDelayInRange() {
        MatcherAssert.assertThat((String)"Delay longer than expected", this.delayTimes, (Matcher)Matchers.everyItem((Matcher)Matchers.lessThan((Comparable)MAX_DELAY)));
    }

    public int getRetryCountForConnectionService() {
        return this.counterForInvokingConnenectionService;
    }
}

