/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.testng.Assert;

public class TCKConfig {
    private static final TCKConfig INSTANCE = new TCKConfig();
    public static final String RESOURCE_NAME = "timeout-multiplier";
    private double baseMultiplier;

    public static TCKConfig getConfig() {
        return INSTANCE;
    }

    private TCKConfig() {
        try (InputStream s = TCKConfig.class.getResourceAsStream("/timeout-multiplier");){
            if (s != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(s, StandardCharsets.UTF_8));
                String multiplier = reader.readLine();
                this.baseMultiplier = Double.valueOf(multiplier);
                System.out.println("Loaded timeout-multiplier from resource: " + this.baseMultiplier);
            } else {
                this.baseMultiplier = Double.valueOf(System.getProperty("org.eclipse.microprofile.fault.tolerance.tck.timeout.multiplier", "1.0"));
                System.out.println("Loaded timeout-multiplier from system property: " + this.baseMultiplier);
            }
        }
        catch (IOException e) {
            Assert.fail((String)"Resource timeout-multiplier is present but could not be read", (Throwable)e);
        }
    }

    public String getTimeoutInStr(long originalInMillis) {
        return String.valueOf(this.getTimeoutInMillis(originalInMillis));
    }

    public long getTimeoutInMillis(long originalInMillis) {
        return Math.round((double)originalInMillis * this.baseMultiplier);
    }

    public Duration getTimeoutInDuration(int originalInMillis) {
        return Duration.ofMillis(this.getTimeoutInMillis(originalInMillis));
    }

    public double getBaseMultiplier() {
        return this.baseMultiplier;
    }
}

