/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.visibility.retry;

import jakarta.inject.Inject;
import java.io.IOException;
import org.eclipse.microprofile.fault.tolerance.tck.visibility.retry.RS;
import org.eclipse.microprofile.fault.tolerance.tck.visibility.retry.RetryService;
import org.eclipse.microprofile.fault.tolerance.tck.visibility.retry.RetryServiceType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryVisibilityTest
extends Arquillian {
    @Inject
    @RS(value=RetryServiceType.BASE_ROC)
    private RetryService baseService;
    @Inject
    @RS(value=RetryServiceType.BASE_ROC_DERIVED_CLASS_NO_REDEFINITION)
    private RetryService serviceDerivedClassNoRedefinition;
    @Inject
    @RS(value=RetryServiceType.BASE_ROC_RETRY_REDEFINED_ON_CLASS)
    private RetryService serviceOverrideClassLevel;
    @Inject
    @RS(value=RetryServiceType.BASE_ROC_RETRY_REDEFINED_ON_CLASS_METHOD_OVERRIDE)
    private RetryService serviceOverrideClassLevelMethodOverride;
    @Inject
    @RS(value=RetryServiceType.BASE_ROC_RETRY_REDEFINED_ON_METHOD)
    private RetryService serviceOverrideMethodLevel;
    @Inject
    @RS(value=RetryServiceType.BASE_ROC_RETRY_MISSING_ON_METHOD)
    private RetryService serviceSuppressMethodLevel;
    @Inject
    @RS(value=RetryServiceType.BASE_ROM)
    private RetryService serviceBaseROM;
    @Inject
    @RS(value=RetryServiceType.BASE_ROM_RETRY_MISSING_ON_METHOD)
    private RetryService serviceBaseROMRetryMissingOnMethod;
    @Inject
    @RS(value=RetryServiceType.BASE_ROM_RETRY_REDEFINED_ON_CLASS)
    private RetryService serviceBaseROMOverridedClassLevelNoMethodOverride;
    @Inject
    @RS(value=RetryServiceType.BASE_ROM_RETRY_REDEFINED_ON_CLASS_METHOD_OVERRIDE)
    private RetryService serviceBaseROMOverridedClassLevelMethodOverride;
    @Inject
    @RS(value=RetryServiceType.BASE_ROM_RETRY_REDEFINED_ON_METHOD)
    private RetryService serviceBaseROMOverridedMethodLevel;
    @Inject
    @RS(value=RetryServiceType.BASE_ROM_DERIVED_CLASS_NO_REDEFINITION)
    private RetryService serviceBaseROMNoRedefinition;
    @Inject
    @RS(value=RetryServiceType.BASE_ROCM)
    private RetryService serviceBaseROCM;
    @Inject
    @RS(value=RetryServiceType.BASE_ROCM_DERIVED_CLASS_NO_REDEFINITION)
    private RetryService serviceBaseROCMNoRedefinition;
    @Inject
    @RS(value=RetryServiceType.BASE_ROCM_RETRY_REDEFINED_ON_CLASS)
    private RetryService serviceBaseROCMOverridedClassLevelNoMethodOverride;
    @Inject
    @RS(value=RetryServiceType.BASE_ROCM_RETRY_REDEFINED_ON_CLASS_METHOD_OVERRIDE)
    private RetryService serviceBaseROCMOverridedClassLevelMethodOverride;
    @Inject
    @RS(value=RetryServiceType.BASE_ROCM_RETRY_MISSING_ON_METHOD)
    private RetryService serviceBaseROCMRetryMissingOnMethod;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftRetryVisibility.jar")).addPackage("org.eclipse.microprofile.fault.tolerance.tck.visibility.retry")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftRetryVisibility.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void baseRetryServiceUsesDefaults() {
        int nbExpectedRetries = 3;
        this.checkServiceCall(nbExpectedRetries, this.baseService, "baseRetryServiceUsesDefaults");
    }

    @Test
    public void serviceDerivedClassNoRedefinition() {
        int nbExpectedRetries = 3;
        this.checkServiceCall(nbExpectedRetries, this.serviceDerivedClassNoRedefinition, "serviceDerivedClassNoRedefinition");
    }

    @Test
    public void serviceOverrideClassLevelUsesClassLevelAnnotation() {
        int nbExpectedRetries = 4;
        this.checkServiceCall(nbExpectedRetries, this.serviceOverrideClassLevel, "serviceOverrideClassLevelUsesClassLevelAnnotation");
    }

    @Test
    public void serviceOverrideClassLevelUsesClassLevelAnnotationWithMethodOverride() {
        int nbExpectedRetries = 4;
        this.checkServiceCall(nbExpectedRetries, this.serviceOverrideClassLevelMethodOverride, "serviceOverrideClassLevelUsesClassLevelAnnotationWithMethodOverride");
    }

    @Test
    public void serviceOverrideMethodLevelUsesMethodLevelAnnotation() {
        int nbExpectedRetries = 4;
        this.checkServiceCall(nbExpectedRetries, this.serviceOverrideMethodLevel, "serviceOverrideMethodLevelUsesMethodLevelAnnotation");
    }

    @Test
    public void serviceRetryRemovedAtMethodLevel() {
        int nbExpectedRetries = 3;
        this.checkServiceCall(nbExpectedRetries, this.serviceSuppressMethodLevel, "serviceRetryRemovedAtMethodLevel");
    }

    @Test
    public void serviceBaseROM() {
        int nbExpectedRetries = 3;
        this.checkServiceCall(nbExpectedRetries, this.serviceBaseROM, "serviceBaseROM");
    }

    @Test
    public void serviceBaseROMRetryMissingOnMethod() {
        int nbExpectedRetries = 0;
        this.checkServiceCall(nbExpectedRetries, this.serviceBaseROMRetryMissingOnMethod, "serviceBaseROMRetryMissingOnMethod");
    }

    @Test
    public void serviceBaseROMOverridedClassLevelNoMethodOverride() {
        int nbExpectedRetries = 4;
        this.checkServiceCall(nbExpectedRetries, this.serviceBaseROMOverridedClassLevelNoMethodOverride, "serviceBaseROMOverridedClassLevelNoMethodOverride");
    }

    @Test
    public void serviceBaseROMOverridedClassLevelMethodOverride() {
        int nbExpectedRetries = 3;
        this.checkServiceCall(nbExpectedRetries, this.serviceBaseROMOverridedClassLevelMethodOverride, "serviceBaseROMOverridedClassLevelMethodOverride");
    }

    @Test
    public void serviceBaseROMOverridedMethodLevel() {
        int nbExpectedRetries = 4;
        this.checkServiceCall(nbExpectedRetries, this.serviceBaseROMOverridedMethodLevel, "serviceBaseROMOverridedMethodLevel");
    }

    @Test
    public void serviceBaseROMNoRedefinition() {
        int nbExpectedRetries = 3;
        this.checkServiceCall(nbExpectedRetries, this.serviceBaseROMNoRedefinition, "serviceBaseROMNoRedefinition");
    }

    @Test
    public void serviceBaseROCM() {
        int nbExpectedRetries = 4;
        this.checkServiceCall(nbExpectedRetries, this.serviceBaseROCM, "serviceBaseROCM");
    }

    @Test
    public void serviceBaseROCMNoRedefinition() {
        int nbExpectedRetries = 4;
        this.checkServiceCall(nbExpectedRetries, this.serviceBaseROCMNoRedefinition, "serviceBaseROCMNoRedefinition");
    }

    @Test
    public void serviceBaseROCMOverridedClassLevelNoMethodOverride() {
        int nbExpectedRetries = 4;
        this.checkServiceCall(nbExpectedRetries, this.serviceBaseROCMOverridedClassLevelNoMethodOverride, "serviceBaseROCMOverridedClassLevelNoMethodOverride");
    }

    @Test
    public void serviceBaseROCMOverridedClassLevelMethodOverride() {
        int nbExpectedRetries = 5;
        this.checkServiceCall(nbExpectedRetries, this.serviceBaseROCMOverridedClassLevelMethodOverride, "serviceBaseROCMOverridedClassLevelMethodOverride");
    }

    @Test
    public void serviceBaseROCMRetryMissingOnMethod() {
        int nbExpectedRetries = 3;
        this.checkServiceCall(nbExpectedRetries, this.serviceBaseROCMRetryMissingOnMethod, "serviceBaseROCMRetryMissingOnMethod");
    }

    private void checkServiceCall(int nbExpectedRetries, RetryService service, String testName) {
        int expectedNbCalls = nbExpectedRetries + 1;
        try {
            service.service();
            Assert.fail((String)String.format("in %s#%s service() should have failed", RetryVisibilityTest.class.getSimpleName(), testName));
        }
        catch (IOException re) {
            Assert.assertEquals((int)service.getNumberOfServiceCalls(), (int)expectedNbCalls, (String)String.format("in %s#%s service() should have been called exactly %d times", RetryVisibilityTest.class.getSimpleName(), testName, expectedNbCalls));
        }
        catch (RuntimeException ex) {
            Assert.fail((String)String.format("no %s exception should have been thrown in %s#%s", ex.getClass().getName(), RetryVisibilityTest.class.getSimpleName(), testName));
        }
    }
}

