/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.tck.metrics.TimedConstructorBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TimedConstructorBeanTest {
    private static final String TIMER_NAME = MetricRegistry.name(TimedConstructorBean.class, (String[])new String[]{"timedConstructor"});
    private static MetricID timerMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private Instance<TimedConstructorBean> instance;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(TimedConstructorBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        timerMID = new MetricID(TIMER_NAME);
    }

    @Test
    @InSequence(value=1)
    public void timedConstructorCalled() {
        long count = 1L + Math.round(Math.random() * 10.0);
        int i = 0;
        while ((long)i < count) {
            this.instance.get();
            ++i;
        }
        Timer timer = this.registry.getTimer(timerMID);
        Assert.assertThat((String)"Timer is not registered correctly", (Object)timer, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)count)));
    }
}

