/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
public class MetricAppBean {
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(description="red-description", displayName="red-display-name")
    private Counter redCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="blue")
    private Counter blueCount;
    public static final String TAGGED_COUNTER = "taggedCounter";
    public static final String TAGGED_HISTOGRAM = "taggedHistogram";
    public static final String TAGGED_TIMER = "taggedTimer";
    public static final String TAGGED_SIMPLETIMER = "taggedSimpleTimer";
    public static final String TAGGED_METER = "taggedMeter";
    public static final String TAGGED_GAUGE = "taggedGauge";
    public static final String TAGGED_CONCURRENTGAUGE = "taggedConcurrentGauge";
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="semiColonTaggedCounter", tags={"scTag=semi;colons;are;bad"})
    private Counter semiColonTaggedCounter;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedCounter")
    private Counter counterNoTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedCounter", tags={"number=one"})
    private Counter counterNumberOneTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedCounter", tags={"number=two"})
    private Counter counterNumberTwoTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedHistogram", absolute=true, unit="marshmellow")
    private Histogram histogramNoTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedHistogram", absolute=true, unit="marshmellow", tags={"number=one"})
    private Histogram histogramOneTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedHistogram", absolute=true, unit="marshmellow", tags={"number=two"})
    private Histogram histogramTwoTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedTimer", absolute=true)
    private Timer timerNoTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedTimer", absolute=true, tags={"number=one"})
    private Timer timerOneTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedTimer", absolute=true, tags={"number=two"})
    private Timer timerTwoTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedSimpleTimer", absolute=true)
    private SimpleTimer simpleTimerNoTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedSimpleTimer", absolute=true, tags={"number=one"})
    private SimpleTimer simpleTimerOneTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedSimpleTimer", absolute=true, tags={"number=two"})
    private SimpleTimer simpleTimerTwoTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedMeter", absolute=true)
    private Meter meterNoTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedMeter", absolute=true, tags={"number=one"})
    private Meter meterOneTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="taggedMeter", absolute=true, tags={"number=two"})
    private Meter meterTwoTag;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(absolute=true)
    private Counter greenCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="purple", absolute=true, tags={"app=myShop"})
    private Counter purpleCount;
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(absolute=true, unit="jellybeans", description="jellybeans-description", displayName="jellybeans-displayName")
    private Histogram jellybeanHistogram;
    @Inject
    private MetricRegistry metrics;

    @org.eclipse.microprofile.metrics.annotation.Gauge(name="taggedGauge", absolute=true, unit="none")
    public long gaugeMeTagged() {
        return 1000L;
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(name="taggedGauge", absolute=true, unit="none", tags={"number=one"})
    public long gaugeMeTaggedOne() {
        return 1000L;
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(name="taggedGauge", absolute=true, unit="none", tags={"number=two"})
    public long gaugeMeTaggedTwo() {
        return 1000L;
    }

    @ConcurrentGauge(absolute=true)
    public void concGaugeMeA() {
    }

    @ConcurrentGauge(name="taggedConcurrentGauge", absolute=true, tags={"number=one"})
    public void concurrentGaugeMeTaggedOne() {
    }

    @ConcurrentGauge(name="taggedConcurrentGauge", absolute=true, tags={"number=two"})
    public void concurrentGaugeMeTaggedTwo() {
    }

    public void countMe() {
        Counter counter = this.metrics.counter("metricTest.test1.count");
        counter.inc();
    }

    @Counted(name="metricTest.test1.countMeA", absolute=true, description="count-me-a-description", displayName="count-me-a-display-name")
    public void countMeA() {
    }

    @Counted(name="metricTest.test1.countMeB", absolute=true, unit="jellybean")
    public long countMeB() {
        return 666666L;
    }

    public void gaugeMe() {
        Gauge gauge = this.metrics.getGauge(new MetricID("metricTest.test1.gauge"));
        if (gauge == null) {
            gauge = () -> 19L;
            Metadata metadata = Metadata.builder().withName("metricTest.test1.gauge").withType(MetricType.GAUGE).withUnit("gigabytes").build();
            this.metrics.register(metadata, (Metric)gauge);
        }
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(unit="kibibits", description="gauge-me-a-description", displayName="gauge-me-a-displayname")
    public long gaugeMeA() {
        return 1000L;
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(unit="hands")
    public long gaugeMeB() {
        return 7777777L;
    }

    public void histogramMe() {
        Metadata metadata = Metadata.builder().withName("metricTest.test1.histogram").withType(MetricType.HISTOGRAM).withUnit("bytes").build();
        Histogram histogram = this.metrics.histogram(metadata);
        for (int i = 0; i < 500; ++i) {
            histogram.update(i);
            histogram.update(999 - i);
        }
        Metadata metadata2 = Metadata.builder().withName("metricTest.test1.histogram2").withType(MetricType.HISTOGRAM).withUnit("none").build();
        Histogram histogram2 = this.metrics.histogram(metadata2);
        histogram2.update(1);
    }

    public void meterMe() {
        Meter meter = this.metrics.meter("metricTest.test1.meter");
        meter.mark();
    }

    @Metered(absolute=true, description="meter-me-a-description", displayName="meter-me-a-display-name")
    public void meterMeA() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeMe() {
        Timer timer = this.metrics.timer("metricTest.test1.timer");
        Timer.Context context = timer.time();
        try {
            Thread.sleep((long)(Math.random() * 1000.0));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            context.stop();
        }
    }

    @Timed
    public void timeMeA() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleTimeMe() {
        SimpleTimer simpleTimer = this.metrics.simpleTimer("metricTest.test1.simpleTimer");
        SimpleTimer.Context context = simpleTimer.time();
        try {
            Thread.sleep((long)(Math.random() * 1000.0));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            context.stop();
        }
    }

    @SimplyTimed
    public void simpleTimeMeA() {
    }

    public void createPromMetrics() {
        this.metrics.counter("pm_counter-with-dashes");
        this.metrics.counter("pm_counter#hash_x'y_");
        this.metrics.counter("pm_counter-umlaut-\u00e4\u00f6\u00fc");
        this.metrics.counter("pm_counter+accent_\u00ea_");
    }
}

