/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck.tracer;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tag;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestSpan
implements Span {
    private long startMicros;
    private long finishMicros;
    private long traceId;
    private long parentId;
    private long spanId;
    private String cachedOperationName;
    private Map<String, Object> tags = new HashMap<String, Object>();
    private List<Map<String, ?>> logEntries = new ArrayList();
    private boolean simulated;

    public TestSpan() {
    }

    public TestSpan(String operationName, Map<String, Object> tags, List<Map<String, ?>> logEntries) {
        this.simulated = true;
        this.cachedOperationName = operationName;
        this.tags = new HashMap<String, Object>(tags);
        this.logEntries = logEntries;
    }

    public long getStartMicros() {
        return this.startMicros;
    }

    public void setStartMicros(long newSartMicros) {
        this.startMicros = newSartMicros;
    }

    public long getFinishMicros() {
        return this.finishMicros;
    }

    public void setFinishMicros(long newFinishMicros) {
        this.finishMicros = newFinishMicros;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public void setTraceId(long newTraceId) {
        this.traceId = newTraceId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long newParentId) {
        this.parentId = newParentId;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public void setSpanId(long newSpanId) {
        this.spanId = newSpanId;
    }

    public String getCachedOperationName() {
        return this.cachedOperationName;
    }

    public void setCachedOperationName(String newCachedOperationName) {
        this.cachedOperationName = newCachedOperationName;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, Object> newTags) {
        this.tags = newTags;
    }

    public List<Map<String, ?>> getLogEntries() {
        return this.logEntries;
    }

    public void setLogEntries(List<Map<String, ?>> newLogEntries) {
        this.logEntries = newLogEntries;
    }

    public SpanContext context() {
        throw new UnsupportedOperationException();
    }

    public Span setTag(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public Span setTag(String key, boolean value) {
        throw new UnsupportedOperationException();
    }

    public Span setTag(String key, Number value) {
        throw new UnsupportedOperationException();
    }

    public <T> Span setTag(Tag<T> tag, T value) {
        throw new UnsupportedOperationException();
    }

    public Span log(Map<String, ?> fields) {
        throw new UnsupportedOperationException();
    }

    public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        throw new UnsupportedOperationException();
    }

    public Span log(String event) {
        throw new UnsupportedOperationException();
    }

    public Span log(long timestampMicroseconds, String event) {
        throw new UnsupportedOperationException();
    }

    public Span setBaggageItem(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public String getBaggageItem(String key) {
        throw new UnsupportedOperationException();
    }

    public Span setOperationName(String operationName) {
        throw new UnsupportedOperationException();
    }

    public void finish() {
        throw new UnsupportedOperationException();
    }

    public void finish(long newFinishMicros) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        ArrayList<Map.Entry<String, Object>> tagsList = new ArrayList<Map.Entry<String, Object>>();
        tagsList.addAll(this.tags.entrySet());
        tagsList.sort(new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> x, Map.Entry<String, Object> y) {
                return x.getKey().compareTo(y.getKey());
            }
        });
        return "{ operationName: " + this.cachedOperationName + ", tags: " + tagsList + ", logEntries: " + this.logEntries + "}";
    }

    public boolean equals(Object obj) {
        TestSpan otherSpan = (TestSpan)obj;
        if (otherSpan != null) {
            if (!this.cachedOperationName.equals(otherSpan.cachedOperationName)) {
                System.err.println("MISMATCH: Operation names don't match: " + this.cachedOperationName + " ; " + otherSpan.cachedOperationName);
                return false;
            }
            if (this.tags.size() != otherSpan.tags.size()) {
                System.err.println("MISMATCH: Number of tags doesn't match");
                return false;
            }
            if (!this.tags.equals(otherSpan.tags)) {
                return false;
            }
            if (this.logEntries.size() != otherSpan.logEntries.size()) {
                System.err.println("MISMATCH: Number of log entries doesn't match (" + this.logEntries.size() + ", " + otherSpan.logEntries.size() + ")");
                return false;
            }
            for (int i = 0; i < this.logEntries.size(); ++i) {
                Map<String, ?> logFieldsX = this.logEntries.get(i);
                Map<String, ?> logFieldsY = otherSpan.logEntries.get(i);
                if (logFieldsX.size() != logFieldsY.size()) {
                    System.err.printf("MISMATCH: Number of log fields doesn't match (%d, %d)\n", logFieldsX.size(), logFieldsY.size());
                    return false;
                }
                for (Map.Entry<String, ?> logEntry : logFieldsX.entrySet()) {
                    Object valY = logFieldsY.get(logEntry.getKey());
                    if (valY == null) {
                        System.err.printf("Log field %s not present in the logs\n", logEntry.getKey());
                        return false;
                    }
                    if (logEntry.getKey().equals("error.object") || valY.equals(logEntry.getValue())) continue;
                    System.err.printf("Log values do not match key=%s, %s, %s\n\n\n\n", logEntry.getKey(), logEntry.getValue(), valY);
                    return false;
                }
            }
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

