/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FromCompletionStageVerification
extends AbstractStageVerification {
    FromCompletionStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void fromCsStageShouldEmitAnElementWhenAlreadyRedeemed() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.fromCompletionStage(CompletableFuture.completedFuture(10)).toList().run(this.getEngine()))), Collections.singletonList(10));
    }

    @Test
    public void fromCsStageShouldEmitAnElementWhenRedeemedLater() throws InterruptedException {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        CompletionStage result = this.rs.fromCompletionStage(future).toList().run(this.getEngine());
        Thread.sleep(100L);
        Assert.assertFalse((boolean)result.toCompletableFuture().isDone());
        future.complete(10);
        Assert.assertEquals((Collection)((Collection)this.await(result)), Collections.singletonList(10));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void fromCsStageShouldFailWhenAlreadyRedeemedWithNull() {
        this.await(this.rs.fromCompletionStage(CompletableFuture.completedFuture(null)).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void fromCsStageShouldFailWhenRedeemedWithNullLater() throws InterruptedException {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        CompletionStage result = this.rs.fromCompletionStage(future).toList().run(this.getEngine());
        Thread.sleep(100L);
        Assert.assertFalse((boolean)result.toCompletableFuture().isDone());
        future.complete(null);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void fromCsStageShouldPropagateAlreadyRedeemedExceptions() {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new QuietRuntimeException("failed"));
        this.await(this.rs.fromCompletionStage(future).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void fromCsStageShouldPropagateExceptionsWhenFailedLater() throws InterruptedException {
        CompletableFuture future = new CompletableFuture();
        CompletionStage result = this.rs.fromCompletionStage(future).toList().run(this.getEngine());
        Thread.sleep(100L);
        Assert.assertFalse((boolean)result.toCompletableFuture().isDone());
        future.completeExceptionally(new QuietRuntimeException("failed"));
        this.await(result);
    }

    @Test
    public void fromCsStageShouldBeReusable() {
        PublisherBuilder publisher = this.rs.fromCompletionStage(CompletableFuture.completedFuture(10));
        Assert.assertEquals((Collection)((Collection)this.await(publisher.toList().run(this.getEngine()))), Collections.singletonList(10));
        Assert.assertEquals((Collection)((Collection)this.await(publisher.toList().run(this.getEngine()))), Collections.singletonList(10));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new PublisherVerification());
    }

    public class PublisherVerification
    extends AbstractStageVerification.StagePublisherVerification<String> {
        public PublisherVerification() {
            super(FromCompletionStageVerification.this);
        }

        public Publisher<String> createPublisher(long elements) {
            if (elements == 0L) {
                return FromCompletionStageVerification.this.rs.empty().buildRs(FromCompletionStageVerification.this.getEngine());
            }
            return FromCompletionStageVerification.this.rs.fromCompletionStage(CompletableFuture.completedFuture("value")).buildRs(FromCompletionStageVerification.this.getEngine());
        }

        public long maxElementsFromPublisher() {
            return 1L;
        }
    }
}

