/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.library.extension;

public class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int micro;
    public static final Version NULL_VERSION = new Version(0, 0, 0);

    public Version(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    @Override
    public int compareTo(Version other) {
        if (this.major > other.getMajor()) {
            return 1;
        }
        if (this.major == other.getMajor()) {
            if (this.minor > other.getMinor()) {
                return 1;
            }
            if (this.minor == other.getMinor()) {
                if (this.micro > other.getMicro()) {
                    return 1;
                }
                if (this.micro == other.getMicro()) {
                    return 0;
                }
            }
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.micro;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.micro != other.micro) {
            return false;
        }
        return this.minor == other.minor;
    }

    public String toString() {
        return "Version " + this.major + "." + this.minor + "." + this.micro;
    }

    public String toVersionNumberString() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.getMicro();
    }

    public static Version fromString(String version) {
        String[] split = version.split("\\.");
        return new Version(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
    }
}

