/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.arduino.platform;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Argument;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.ExpressionsPackage;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Property;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Signal;
import org.eclipse.mita.program.GeneratedFunctionDefinition;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.mita.program.validation.MethodCall;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class Validation
implements IResourceValidator {
    public void validate(Program program, EObject context, final ValidationMessageAcceptor acceptor) {
        Functions.Function1<String, Iterable<MethodCall.MethodCallSigInst>> _function_4;
        Functions.Function1<FeatureCall, Boolean> _function = new Functions.Function1<FeatureCall, Boolean>(){

            public Boolean apply(FeatureCall it) {
                return it.isOperationCall();
            }
        };
        List functionCalls1 = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)program.eAllContents(), FeatureCall.class), (Functions.Function1)_function));
        Functions.Function1<ElementReferenceExpression, Boolean> _function_1 = new Functions.Function1<ElementReferenceExpression, Boolean>(){

            public Boolean apply(ElementReferenceExpression it) {
                return it.isOperationCall();
            }
        };
        List functionCalls2 = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)program.eAllContents(), ElementReferenceExpression.class), (Functions.Function1)_function_1));
        Functions.Function1<FeatureCall, MethodCall<? extends Property>> _function_2 = new Functions.Function1<FeatureCall, MethodCall<? extends Property>>(){

            public MethodCall<? extends Property> apply(FeatureCall it) {
                FeatureCall source = it;
                EObject method = it.getFeature();
                Expression owner = it.getOwner();
                if (owner instanceof FeatureCall) {
                    EObject sigInst = ((FeatureCall)owner).getFeature();
                    if (source == null || method == null || sigInst == null) {
                        return null;
                    }
                    return MethodCall.cons((Object)source, (Object)method, (Object)sigInst, (Object)ExpressionsPackage.Literals.FEATURE_CALL__FEATURE);
                }
                return null;
            }
        };
        List _map = ListExtensions.map((List)functionCalls1, (Functions.Function1)_function_2);
        Functions.Function1<ElementReferenceExpression, MethodCall<? extends Property>> _function_3 = new Functions.Function1<ElementReferenceExpression, MethodCall<? extends Property>>(){

            public MethodCall<? extends Property> apply(ElementReferenceExpression it) {
                ElementReferenceExpression source = it;
                EObject method = it.getReference();
                if (method instanceof Operation) {
                    Expression sigInst = ModelUtils.getArgumentValue((Operation)((Operation)method), (ArgumentExpression)it, (String)"self");
                    if (source == null || method == null || sigInst == null) {
                        return null;
                    }
                    return MethodCall.cons((Object)source, (Object)method, (Object)sigInst, (Object)ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE);
                }
                return null;
            }
        };
        List _map_1 = ListExtensions.map((List)functionCalls2, (Functions.Function1)_function_3);
        final Iterable sigInstAccesses = Iterables.filter((Iterable)IterableExtensions.filterNull((Iterable)Iterables.concat((Iterable)_map, (Iterable)_map_1)), MethodCall.MethodCallSigInst.class);
        Functions.Function1<String, Iterable<MethodCall.MethodCallSigInst>> filterSigInstName = _function_4 = new Functions.Function1<String, Iterable<MethodCall.MethodCallSigInst>>(){

            public Iterable<MethodCall.MethodCallSigInst> apply(final String name) {
                Functions.Function1<MethodCall.MethodCallSigInst, Boolean> _function = new Functions.Function1<MethodCall.MethodCallSigInst, Boolean>(){

                    public Boolean apply(MethodCall.MethodCallSigInst it) {
                        EObject res;
                        EObject ref;
                        Expression init = it.getSigInst().getInitialization();
                        if (init instanceof ElementReferenceExpression && (ref = ((ElementReferenceExpression)init).getReference()) instanceof Signal && (res = ((Signal)ref).eContainer()) instanceof AbstractSystemResource) {
                            String _name = ((AbstractSystemResource)res).getName();
                            return Objects.equal((Object)_name, (Object)name);
                        }
                        return false;
                    }
                };
                return IterableExtensions.filter((Iterable)sigInstAccesses, (Functions.Function1)_function);
            }
        };
        Set gpios = IterableExtensions.toSet((Iterable)((Iterable)filterSigInstName.apply((Object)"GPIO")));
        Functions.Function1<MethodCall.MethodCallSigInst, Boolean> _function_5 = new Functions.Function1<MethodCall.MethodCallSigInst, Boolean>(){

            public Boolean apply(MethodCall.MethodCallSigInst it) {
                boolean _xifexpression = false;
                Operation _method = it.getMethod();
                if (_method instanceof GeneratedFunctionDefinition) {
                    String _name = it.getMethod().getName();
                    _xifexpression = Objects.equal((Object)_name, (Object)"write");
                } else {
                    _xifexpression = false;
                }
                return _xifexpression;
            }
        };
        final Set writes = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)sigInstAccesses, (Functions.Function1)_function_5));
        HashSet _hashSet = new HashSet(gpios);
        Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>> _function_6 = new Procedures.Procedure1<HashSet<MethodCall.MethodCallSigInst>>(){

            public void apply(HashSet<MethodCall.MethodCallSigInst> it) {
                it.retainAll(writes);
            }
        };
        HashSet gpioWrites = (HashSet)ObjectExtensions.operator_doubleArrow(_hashSet, (Procedures.Procedure1)_function_6);
        Consumer<MethodCall.MethodCallSigInst> _function_7 = new Consumer<MethodCall.MethodCallSigInst>(){

            @Override
            public void accept(MethodCall.MethodCallSigInst it) {
                Validation.this.validateGpioWrite(it, acceptor);
            }
        };
        gpioWrites.forEach(_function_7);
    }

    public void validateGpioWrite(MethodCall.MethodCallSigInst call, ValidationMessageAcceptor acceptor) {
        boolean _contains;
        Expression _initialization = call.getSigInst().getInitialization();
        ElementReferenceExpression init = (ElementReferenceExpression)_initialization;
        Expression value = ((Argument)init.getArguments().get(1)).getValue();
        if (value instanceof ElementReferenceExpression && (_contains = ((ElementReferenceExpression)value).getReference().toString().contains("INPUT"))) {
            acceptor.acceptError("Can not write to inputs", (EObject)call.getSource(), call.getStructFeature(), 0, "CANT_WRITE_TO_INPUTS", new String[0]);
        }
    }
}

